/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRewriter {
    private final ModuleManager mgr;

    public ModuleManager getModuleManager() {
        return this.mgr;
    }

    public CajoledModule rewrite(List<CajoledModule> modules) {
        if (modules.size() == 1) {
            return modules.get(0);
        }
        FilePosition unk = FilePosition.UNKNOWN;
        BuildInfo buildInfo = this.mgr.getBuildInfo();
        Expression moduleInvocations = null;
        for (CajoledModule module : modules) {
            Expression invocation = (Expression)QuasiBuilder.substV("___.prepareModule(@moduleBody).instantiate___(___, IMPORTS___)", "moduleBody", module.getModuleBody());
            moduleInvocations = moduleInvocations != null ? Operation.createInfix(Operator.COMMA, moduleInvocations, invocation) : invocation;
        }
        ObjectConstructor oc = (ObjectConstructor)QuasiBuilder.substV("({  instantiate: function (___, IMPORTS___) {    return @moduleInvocations?;  },  cajolerName: @cajolerName,  cajolerVersion: @cajolerVersion,  cajoledDate: @cajoledDate})", "moduleInvocations", moduleInvocations, "cajolerName", StringLiteral.valueOf(unk, "com.google.caja"), "cajolerVersion", StringLiteral.valueOf(unk, buildInfo.getBuildVersion()), "cajoledDate", new IntegerLiteral(unk, buildInfo.getCurrentTime()));
        return new CajoledModule(oc);
    }

    public ModuleRewriter(ModuleManager mgr) {
        this.mgr = mgr;
    }

    public ModuleRewriter(PluginMeta meta, BuildInfo buildInfo, UriFetcher uriFetcher, MessageQueue mq) {
        this(new ModuleManager(meta, buildInfo, uriFetcher, mq));
    }

    public ModuleRewriter(PluginMeta meta, BuildInfo buildInfo, boolean isFromValija, MessageQueue mq) {
        this(meta, buildInfo, UriFetcher.NULL_NETWORK, mq);
    }
}

