/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.plugin.Job;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;

public final class JobEnvelope {
    public String placeholderId;
    public JobCache.Keys cacheKeys;
    public final ContentType sourceType;
    public final boolean fromCache;
    public final Job job;

    public JobEnvelope(String placeholderId, JobCache.Keys cacheKeys, ContentType sourceType, boolean fromCache, Job job) {
        this.placeholderId = placeholderId;
        this.cacheKeys = cacheKeys;
        this.sourceType = sourceType;
        this.fromCache = fromCache;
        this.job = job;
    }

    public static JobEnvelope of(Job job) {
        return new JobEnvelope(null, JobCache.none(), job.getType(), false, job);
    }

    public JobEnvelope withJob(Job job) {
        return new JobEnvelope(this.placeholderId, this.cacheKeys, this.sourceType, this.fromCache, job);
    }

    public String toString() {
        if (this.sourceType != this.job.getType() || this.placeholderId != null || this.fromCache) {
            StringBuilder sb = new StringBuilder();
            sb.append("(JobEnvelope");
            if (this.sourceType != this.job.getType()) {
                sb.append(' ').append((Object)this.sourceType);
            }
            if (this.placeholderId != null) {
                sb.append(" phid=").append(this.placeholderId);
            }
            if (this.fromCache) {
                sb.append(" cached");
            }
            return sb.append(' ').append(this.job).append(')').toString();
        }
        return this.job.toString();
    }

    public boolean areFromSameSource(JobEnvelope that) {
        return that != null && ((Object)this.cacheKeys).equals(that.cacheKeys) && (this.placeholderId != null ? this.placeholderId.equals(that.placeholderId) : that.placeholderId == null);
    }
}

