/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.ModuleRewriter;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Pipeline;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsolidateCodeStage
implements Pipeline.Stage<Jobs> {
    private final ModuleManager mgr;

    public ConsolidateCodeStage(ModuleManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public boolean apply(Jobs jobs) {
        List<JobEnvelope> jsJobs = jobs.getJobsByType(ContentType.JS, new ContentType[0]);
        List<CajoledModule> modules = Lists.newArrayList();
        for (JobEnvelope env : jsJobs) {
            CajoledModule module = (CajoledModule)env.job.getRoot();
            if (module.getSrc() != null) continue;
            modules.add(module);
        }
        jobs.getJobs().removeAll(jsJobs);
        ModuleRewriter rw = new ModuleRewriter(this.mgr);
        jobs.getJobs().add(JobEnvelope.of(Job.cajoledJob(rw.rewrite(modules))));
        return jobs.hasNoFatalErrors();
    }
}

