/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.precajole.StaticPrecajoleMap;
import com.google.caja.util.Json;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecajoleInfoServlet
extends HttpServlet {
    private static String[] COMMENT = new String[]{"The cajoler has the following resources precajoled.", "All URLs in a group are treated as the same resource."};

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        if (req.getRequestURI().contains(";")) {
            throw new ServletException("Invalid URL path parameter");
        }
        try {
            String rendered;
            JSONObject info = this.jsonInfo();
            String format = req.getParameter("format");
            if ("json".equals(format)) {
                rendered = info.toString();
                resp.setContentType("application/json;charset=utf-8");
            } else if ("html".equals(format)) {
                rendered = this.formatHtml(info);
                resp.setContentType("text/html;charset=utf-8");
            } else if ("text".equals(format)) {
                resp.setContentType("text/plain;charset=utf-8");
                rendered = this.formatText(info);
            } else {
                resp.sendError(400, "Please specify format=json, text, or html");
                return;
            }
            resp.setHeader("X-Content-Type-Options", "nosniff");
            byte[] bytes = this.utf8(rendered);
            resp.setContentLength(bytes.length);
            resp.getOutputStream().write(bytes);
            resp.getOutputStream().close();
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String formatHtml(JSONObject info) {
        StringBuilder out = new StringBuilder();
        out.append("<!doctype html>\n");
        out.append("<html>\n");
        out.append("<body>\n");
        out.append("  <div>\n");
        out.append("    <a href='?format=text'>[plaintext]</a>\n");
        out.append("    <a href='?format=json'>[json]</a>\n");
        out.append("  </div>\n");
        out.append("  <pre id='info'></pre>\n");
        out.append("  <script>\n");
        out.append("    var info = ").append(info.toString()).append(";\n");
        out.append("    var s = JSON.stringify(info, null, '  ');\n");
        out.append("    var t = document.createTextNode(s);\n");
        out.append("    document.getElementById('info').appendChild(t);\n");
        out.append("  </script>\n");
        out.append("</body>\n");
        out.append("</html>\n");
        return out.toString();
    }

    private String formatText(JSONObject info) {
        StringBuilder out = new StringBuilder();
        this.formatTextTo(out, info, "");
        return out.toString();
    }

    private void formatTextTo(StringBuilder out, Object obj, String indent) {
        if (obj instanceof JSONObject) {
            JSONObject jobj = (JSONObject)obj;
            for (String key : this.jsonKeys(jobj)) {
                out.append(indent).append(key).append("\n");
                this.formatTextTo(out, jobj.get((Object)key), "  " + indent);
            }
        } else if (obj instanceof JSONArray) {
            JSONArray jarr = (JSONArray)obj;
            for (int k = 0; k < jarr.size(); ++k) {
                this.formatTextTo(out, jarr.get(k), indent);
            }
            out.append(indent).append("\n");
        } else {
            out.append(indent).append(obj.toString()).append("\n");
        }
    }

    private List<String> jsonKeys(JSONObject obj) {
        ArrayList<String> list = new ArrayList<String>(obj.keySet());
        Collections.sort(list);
        return list;
    }

    private byte[] utf8(String s) throws ServletException {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private JSONObject jsonInfo() {
        JSONObject info = new JSONObject();
        JSONArray comment = new JSONArray();
        for (String line : COMMENT) {
            Json.push(comment, line);
        }
        Json.put(info, "comment", comment);
        JSONArray groups = new JSONArray();
        for (List<String> urls : this.getUrlGroups()) {
            JSONArray group = new JSONArray();
            for (String url : urls) {
                Json.push(group, url);
            }
            Json.push(groups, group);
        }
        Json.put(info, "urlGroups", groups);
        return info;
    }

    private List<List<String>> getUrlGroups() {
        StaticPrecajoleMap spm = StaticPrecajoleMap.getInstance();
        List<List<String>> urlGroups = spm.getUrlGroups();
        for (List<String> urls : urlGroups) {
            Collections.sort(urls);
        }
        Collections.sort(urlGroups, new Comparator<List<String>>(){

            @Override
            public int compare(List<String> a, List<String> b) {
                return a.get(0).compareTo(b.get(0));
            }
        });
        return urlGroups;
    }
}

