/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServiceMessageType implements MessageTypeInt
{
    WRONG_BUILD_VERSION("Build version error: Expected %s but was %s", MessageLevel.FATAL_ERROR),
    EXCEPTION_IN_SERVICE("Service threw exception %s", MessageLevel.FATAL_ERROR),
    INVALID_ARGUMENT("Invalid value %s for argument %s", MessageLevel.FATAL_ERROR),
    INVALID_INPUT_URL("Invalid input URL %s", MessageLevel.FATAL_ERROR),
    MISSING_ARGUMENT("Missing argument %s", MessageLevel.FATAL_ERROR),
    UNSUPPORTED_CONTENT_TYPES("Requested content types are unsupported", MessageLevel.FATAL_ERROR),
    UNEXPECTED_INPUT_MIME_TYPE("Expected input MIME type %s but found %s", MessageLevel.FATAL_ERROR);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private ServiceMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }
}

