/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.SyntheticAttributeKey;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyntheticAttributes
extends AbstractMap<SyntheticAttributeKey<?>, Object>
implements Serializable {
    private static final long serialVersionUID = 1124793823020078634L;
    private boolean hasOwnCopy;
    private Map<SyntheticAttributeKey<?>, Object> attributes;
    private boolean immutable = false;

    public SyntheticAttributes() {
        this.clear();
    }

    public SyntheticAttributes(SyntheticAttributes sa) {
        this.attributes = sa.attributes;
        this.immutable = sa.immutable;
        sa.hasOwnCopy = false;
    }

    public void makeImmutable() {
        if (this.immutable) {
            return;
        }
        this.requireOwnCopy();
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public void clear() {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        this.attributes = Collections.emptyMap();
        this.hasOwnCopy = false;
    }

    public <T> T get(SyntheticAttributeKey<T> k) {
        return (T)this.attributes.get(k);
    }

    @Override
    public Object get(Object k) {
        return this.attributes.get(k);
    }

    public <T> T set(SyntheticAttributeKey<T> k, T v) {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        if (null != v && !k.getType().isInstance(v)) {
            throw new ClassCastException(v + " to " + k.getType());
        }
        this.requireOwnCopy();
        return (T)this.attributes.put(k, v);
    }

    @Override
    @Deprecated
    public Object put(SyntheticAttributeKey<?> k, Object v) {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        if (null != v && !k.getType().isInstance(v)) {
            throw new ClassCastException(v + " to " + k.getType());
        }
        this.requireOwnCopy();
        return this.attributes.put(k, v);
    }

    public boolean is(SyntheticAttributeKey<Boolean> k) {
        return Boolean.TRUE.equals(this.attributes.get(k));
    }

    public <T> T remove(SyntheticAttributeKey<T> k) {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        return (T)this.remove((Object)k);
    }

    @Override
    public Object remove(Object k) {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        if (!this.hasOwnCopy) {
            if (this.attributes.isEmpty()) {
                return null;
            }
            this.requireOwnCopy();
        }
        return this.attributes.remove(k);
    }

    private void requireOwnCopy() {
        if (!this.hasOwnCopy) {
            this.attributes = new HashMap(this.attributes);
            this.hasOwnCopy = true;
        }
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.attributes.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.attributes.containsValue(v);
    }

    @Override
    public Set<Map.Entry<SyntheticAttributeKey<?>, Object>> entrySet() {
        return Collections.unmodifiableMap(this.attributes).entrySet();
    }
}

