/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.ReferencePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public abstract class ReferenceValueData
extends AbstractValueData {
    protected Identifier value;

    protected ReferenceValueData(int orderNumber, Identifier value) {
        super(orderNumber);
        this.value = value;
    }

    @Override
    protected boolean internalEquals(ValueData another) {
        if (another instanceof ReferenceValueData) {
            return ((ReferenceValueData)another).value.equals(this.value);
        }
        return false;
    }

    @Override
    protected byte[] spoolInternalValue() {
        try {
            return this.value.getString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
        }
    }

    public String toString() {
        return this.value.getString();
    }

    @Override
    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new ReferencePersistedValueData(orderNumber, this.value);
    }

    @Override
    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    @Override
    protected String getString() {
        return this.value.getString();
    }

    @Override
    protected String getReference() throws ValueFormatException {
        return this.value.getString();
    }
}

