/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ACLReader;

public class PersistedNodeDataReader {
    public PersistedNodeData read(ObjectReader in) throws UnknownClassIdException, IOException {
        InternalQName primaryTypeName;
        QPath qpath;
        int key = in.readInt();
        if (key != 9) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        try {
            String sQPath = in.readString();
            qpath = QPath.parse(sQPath);
        }
        catch (IllegalPathException e) {
            throw new IOException("Deserialization error. " + (Object)((Object)e)){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        String identifier = in.readString();
        String parentIdentifier = null;
        if (in.readByte() == 1) {
            parentIdentifier = in.readString();
        }
        int persistedVersion = in.readInt();
        int orderNum = in.readInt();
        try {
            primaryTypeName = InternalQName.parse(in.readString());
        }
        catch (IllegalNameException e) {
            throw new IOException(e.getMessage()){
                private static final long serialVersionUID = 3489809179234435267L;

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        InternalQName[] mixinTypeNames = null;
        if (in.readByte() == 1) {
            int count = in.readInt();
            mixinTypeNames = new InternalQName[count];
            for (int i = 0; i < count; ++i) {
                try {
                    mixinTypeNames[i] = InternalQName.parse(in.readString());
                    continue;
                }
                catch (IllegalNameException e) {
                    throw new IOException(e.getMessage()){
                        private static final long serialVersionUID = 3489809179234435268L;

                        @Override
                        public Throwable getCause() {
                            return e;
                        }
                    };
                }
            }
        }
        AccessControlList acl = null;
        if (in.readByte() == 1) {
            ACLReader rdr = new ACLReader();
            acl = rdr.read(in);
        }
        return new PersistedNodeData(identifier, qpath, parentIdentifier, persistedVersion, orderNum, primaryTypeName, mixinTypeNames, acl);
    }
}

