/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.driver.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.SearchService;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.search.es.ElasticSearchServiceConnector;
import org.exoplatform.commons.search.service.UnifiedSearchService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JcrSearchDriver
extends SearchService {
    private static final Log LOG = ExoLogger.getLogger(JcrSearchDriver.class);
    private String specialCharacters;
    private String fuzzySyntax;
    private String esFuzzySyntax;

    public JcrSearchDriver(InitParams initParams) {
        this.specialCharacters = ((Parameter)initParams.get((Object)"exo.search.excluded-characters")).toString();
        this.specialCharacters = this.specialCharacters.replace(".", "\\.").replace("-", "\\-");
        this.fuzzySyntax = JcrSearchDriver.getFuzzySyntax(false);
        this.esFuzzySyntax = JcrSearchDriver.getFuzzySyntax(true);
    }

    public Map<String, Collection<SearchResult>> search(SearchContext context, String query, Collection<String> sites, Collection<String> types, int offset, int limit, String sort, String order) {
        query = this.replaceSpecialCharacters(query);
        HashMap<String, ArrayList<String>> terms = JcrSearchDriver.parse(query);
        HashMap<String, Collection<SearchResult>> results = new HashMap<String, Collection<SearchResult>>();
        if (StringUtils.isBlank((String)query)) {
            return results;
        }
        if (null == types || types.isEmpty()) {
            return results;
        }
        List<String> enabledTypes = UnifiedSearchService.getEnabledSearchTypes();
        for (SearchServiceConnector connector : this.getConnectors()) {
            if (!enabledTypes.contains(connector.getSearchType()) || !types.contains("all") && !types.contains(connector.getSearchType())) continue;
            LOG.debug((Object)("\n[UNIFIED SEARCH]: connector = " + connector.getClass().getSimpleName()));
            try {
                String connectorQuery = null;
                connectorQuery = connector instanceof ElasticSearchServiceConnector ? JcrSearchDriver.repeat("\\\"%s\\\"", (Collection<String>)terms.get("quoted"), " ") + " " + JcrSearchDriver.repeat("%s" + this.esFuzzySyntax, (Collection<String>)terms.get("single"), " ") : JcrSearchDriver.repeat("\\\"%s\\\"", (Collection<String>)terms.get("quoted"), " ") + " " + JcrSearchDriver.repeat("%s" + this.fuzzySyntax, (Collection<String>)terms.get("single"), " ");
                results.put(connector.getSearchType(), connector.search(context, connectorQuery, sites, offset, limit, sort, order));
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return results;
    }

    private static HashMap<String, ArrayList<String>> parse(String input) {
        HashMap<String, ArrayList<String>> terms = new HashMap<String, ArrayList<String>>();
        ArrayList<String> quoted = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\"([^\"]+)\"").matcher(input);
        while (matcher.find()) {
            String founds = matcher.group(1);
            quoted.add(founds);
        }
        terms.put("quoted", quoted);
        String remain = matcher.replaceAll("").replaceAll("\"", "").trim();
        ArrayList<String> single = new ArrayList<String>();
        if (!remain.isEmpty()) {
            single.addAll(Arrays.asList(remain.split("\\s+")));
        }
        terms.put("single", single);
        return terms;
    }

    private static String repeat(String format, Collection<String> strArr, String delimiter) {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String str : strArr) {
            if (!JcrSearchDriver.isEnableFuzzySearch()) {
                String disableFuzzy = str.replace("~", "");
                sb.append(delim).append(disableFuzzy);
                delim = delimiter;
                continue;
            }
            if (!JcrSearchDriver.isFuzzyManual(str) && str.indexOf("~") != -1) {
                str = str.replace(str.substring(str.indexOf("~")), "~0.5");
                sb.append(delim).append(str);
                delim = delimiter;
                continue;
            }
            if (!JcrSearchDriver.isFuzzyManual(str) && JcrSearchDriver.isEnableFuzzySearch()) {
                sb.append(delim).append(String.format(format, str));
                delim = delimiter;
                continue;
            }
            sb.append(delim).append(str);
            delim = delimiter;
        }
        return sb.toString();
    }

    private static String getFuzzySyntax(boolean esFuzzyExpression) {
        String fuzzySyntax = "";
        String fuzzySimilarity = System.getProperty("unified-search.engine.fuzzy.similarity");
        Double fuzzySimilarityDouble = 0.5;
        if (JcrSearchDriver.isEnableFuzzySearch()) {
            if (fuzzySimilarity != null) {
                try {
                    fuzzySimilarityDouble = Double.parseDouble(fuzzySimilarity);
                }
                catch (NumberFormatException e) {
                    fuzzySimilarityDouble = 0.5;
                }
            }
            if (fuzzySimilarityDouble < 0.0 || fuzzySimilarityDouble >= 1.0) {
                fuzzySimilarityDouble = 0.5;
            }
            if (esFuzzyExpression) {
                fuzzySimilarityDouble = 2 - (int)(fuzzySimilarityDouble * 2.0);
            }
            fuzzySyntax = "~" + String.valueOf(fuzzySimilarityDouble);
        }
        return fuzzySyntax;
    }

    private static boolean isFuzzyManual(String input) {
        Matcher matcher = Pattern.compile(".[~][0]([\\.][0-9])").matcher(input);
        return matcher.find();
    }

    private static boolean isEnableFuzzySearch() {
        String fuzzyEnable = System.getProperty("unified-search.engine.fuzzy.enable");
        return fuzzyEnable != null && Boolean.parseBoolean(fuzzyEnable) || fuzzyEnable == null;
    }

    private String replaceSpecialCharacters(String query) {
        return query.replaceAll("[" + this.specialCharacters + "]", " ");
    }
}

