/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Set;
import org.exoplatform.commons.utils.LazyList;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.gatein.common.io.IOTools;

public class Safe {
    private static final Field listAccessField;

    private Safe() {
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o2 != null && o1.equals(o2);
    }

    public static boolean close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes;
            byte[] byArray = bytes = IOTools.getBytes((InputStream)is);
            return byArray;
        }
        catch (IOException ignore) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOTools.safeClose((Closeable)is);
        }
    }

    public static <E> Set<E> unmodifiableSet(Set<E> set) {
        if (set == null) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> ListAccess<E> unwrap(PageList<E> pageList) {
        LazyPageList lazyPageList = (LazyPageList)pageList;
        try {
            LazyList lazyList = (LazyList)lazyPageList.getAll();
            return (ListAccess)listAccessField.get(lazyList);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    static {
        try {
            listAccessField = LazyList.class.getDeclaredField("listAccess");
            listAccessField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }
}

