/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

public class XMLDeclarationParser {
    public static final char APOS = '\'';
    public static final char CR = '\r';
    public static final char EQ = '=';
    public static final char GT = '>';
    public static final char LF = '\n';
    public static final char LT = '<';
    public static final char QUESTION_MARK = '?';
    public static final char QUOT = '\"';
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final String ENCODING = "encoding";
    public static final String STANDALONE = "standalone";
    public static final String VERSION = "version";
    public static final String XML = "xml";
    private static final int INVALID = -1;
    private boolean atEndOfInput = false;
    private Map<String, String> attributes = new HashMap<String, String>(4);
    private StringBuilder charBuffer = new StringBuilder(16);
    private int currentChar = -1;
    private Reader in;
    private int pos = 0;

    public XMLDeclarationParser(Reader in) {
        this.in = in;
    }

    public XMLDeclarationParser(String xml) {
        this(new StringReader(xml));
    }

    private void consumeOptionalWhiteSpace() throws IOException {
        block3: while (!this.atEndOfInput) {
            int ch = this.current();
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.next();
                    continue block3;
                }
            }
            return;
        }
    }

    private int current() throws IOException {
        if (this.currentChar < 0) {
            this.next();
        }
        return this.currentChar;
    }

    private void ensureNotEndOfInput() throws SAXException, IOException {
        if (this.current() < 0) {
            throw new SAXException("Unexpected end of input.");
        }
    }

    private String key() throws IOException {
        this.charBuffer.setLength(0);
        block3: while (!this.atEndOfInput) {
            int ch = this.current();
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 61: {
                    break block3;
                }
                default: {
                    this.charBuffer.append((char)ch);
                    this.next();
                    continue block3;
                }
            }
        }
        return this.charBuffer.toString();
    }

    private void keyVal() throws IOException, SAXException {
        String key = this.key();
        this.consumeOptionalWhiteSpace();
        this.match('=');
        this.consumeOptionalWhiteSpace();
        String value = this.value();
        this.attributes.put(key, value);
        this.consumeOptionalWhiteSpace();
    }

    private void match(char toMatch) throws SAXException, IOException {
        this.ensureNotEndOfInput();
        int ch = this.current();
        if (ch != toMatch) {
            throw new SAXException("Unexpected character '" + (char)ch + "' at position " + this.pos + "; expected '" + toMatch + "'.");
        }
        this.next();
    }

    private void match(String toMatch) throws SAXException, IOException {
        for (int i = 0; i < toMatch.length(); ++i) {
            this.match(toMatch.charAt(i));
        }
    }

    private void matchWhiteSpace() throws IOException, SAXException {
        this.ensureNotEndOfInput();
        int ch = this.current();
        switch (ch) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.next();
                break;
            }
            default: {
                throw new SAXException("Whitespace expected at postion " + this.pos + " of an XML declaration.");
            }
        }
        this.consumeOptionalWhiteSpace();
    }

    private int next() throws IOException {
        if (!this.atEndOfInput) {
            this.currentChar = this.in.read();
            ++this.pos;
            if (this.currentChar < 0) {
                this.atEndOfInput = true;
            }
        }
        return this.currentChar;
    }

    public Map<String, String> parse() throws SAXException, IOException {
        this.match('<');
        this.match('?');
        this.match(XML);
        this.matchWhiteSpace();
        while (this.current() != 63 && !this.atEndOfInput) {
            this.keyVal();
        }
        this.match('?');
        this.match('>');
        return this.attributes;
    }

    private String value() throws IOException, SAXException {
        this.ensureNotEndOfInput();
        int quote = this.current();
        switch (quote) {
            case 34: 
            case 39: {
                this.next();
                break;
            }
            default: {
                throw new SAXException("Unexpected character '" + (char)quote + "' at position " + this.pos + "; expected '" + '\"' + "' or '" + '\'' + "'.");
            }
        }
        this.charBuffer.setLength(0);
        while (!this.atEndOfInput) {
            int ch = this.current();
            if (ch == quote) {
                this.next();
                break;
            }
            this.charBuffer.append((char)ch);
            this.next();
        }
        return this.charBuffer.toString();
    }
}

