/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.version;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class Version {
    public static final String productName;
    public static final String productVersion;
    public static final String implementationVersion;
    public static final String prettyVersion;
    private static final Logger log;

    static {
        log = LoggerFactory.getLogger(Version.class);
        URL url = Version.class.getProtectionDomain().getCodeSource().getLocation();
        Manifest manifest = null;
        try {
            InputStream stream = new URL(url.toString() + "META-INF/MANIFEST.MF").openStream();
            if (stream != null) {
                manifest = new Manifest(stream);
            }
        }
        catch (IOException e) {
            log.debug((Object)"Unable to get the MANIFEST.MF from the gatein portal common component jar.");
        }
        if (manifest != null) {
            productName = manifest.getMainAttributes().getValue("JBoss-Product-Release-Name");
            productVersion = manifest.getMainAttributes().getValue("JBoss-Product-Release-Version");
            implementationVersion = manifest.getMainAttributes().getValue("Implementation-Version");
        } else {
            productName = null;
            productVersion = "Unknown";
            implementationVersion = "Unknown";
        }
        String iVersion = implementationVersion == null ? "Unknown" : implementationVersion;
        String version = productVersion == null ? iVersion : productVersion;
        prettyVersion = productName == null ? String.format("GateIn Portal %s", iVersion) : String.format("%s %s (GateIn Portal %s)", productName, version, iVersion);
    }
}

