/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.RightSet;
import org.xwiki.security.authorization.RuleState;
import org.xwiki.security.authorization.SecurityAccess;

public class XWikiSecurityAccess
implements SecurityAccess {
    private static XWikiSecurityAccess defaultAccess;
    private static int defaultAccessSize;
    protected RightSet allowed = new RightSet();
    protected RightSet denied = new RightSet();

    public static synchronized XWikiSecurityAccess getDefaultAccess() {
        if (defaultAccess == null || Right.size() != defaultAccessSize) {
            defaultAccessSize = Right.size();
            defaultAccess = new XWikiSecurityAccess();
            for (Right right : Right.values()) {
                defaultAccess.set(right, right.getDefaultState());
            }
        }
        return defaultAccess;
    }

    void set(Right right, RuleState state) {
        switch (state) {
            case ALLOW: {
                this.allow(right);
                break;
            }
            case DENY: {
                this.deny(right);
                break;
            }
            case UNDETERMINED: {
                this.clear(right);
                break;
            }
        }
    }

    void allow(Right right) {
        this.allowed.add(right);
        this.denied.remove(right);
    }

    void deny(Right right) {
        this.denied.add(right);
        this.allowed.remove(right);
    }

    void clear(Right right) {
        this.allowed.remove(right);
        this.denied.remove(right);
    }

    @Override
    public RuleState get(Right right) {
        if (this.denied.contains(right)) {
            return RuleState.DENY;
        }
        if (this.allowed.contains(right)) {
            return RuleState.ALLOW;
        }
        return RuleState.UNDETERMINED;
    }

    public XWikiSecurityAccess clone() throws CloneNotSupportedException {
        XWikiSecurityAccess clone = (XWikiSecurityAccess)super.clone();
        clone.allowed = this.allowed.clone();
        clone.denied = this.denied.clone();
        return clone;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XWikiSecurityAccess)) {
            return false;
        }
        XWikiSecurityAccess other = (XWikiSecurityAccess)object;
        return other.allowed.equals(this.allowed) && other.denied.equals(this.denied);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.allowed).append((Object)this.denied).toHashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Right r : Right.values()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(r).append(": ").append((Object)this.get(r));
        }
        return b.toString();
    }
}

