/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.media;

import com.google.api.client.googleapis.MethodOverride;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.googleapis.media.MediaUploadExponentialBackOffPolicy;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.ExponentialBackOffPolicy;
import com.google.api.client.http.GZipEncoding;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.util.ByteStreams;
import com.google.api.client.util.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;

public final class MediaHttpUploader {
    public static final String CONTENT_LENGTH_HEADER = "X-Upload-Content-Length";
    public static final String CONTENT_TYPE_HEADER = "X-Upload-Content-Type";
    private UploadState uploadState = UploadState.NOT_STARTED;
    static final int MB = 0x100000;
    private static final int KB = 1024;
    public static final int MINIMUM_CHUNK_SIZE = 262144;
    public static final int DEFAULT_CHUNK_SIZE = 0xA00000;
    private final AbstractInputStreamContent mediaContent;
    private final HttpRequestFactory requestFactory;
    private final HttpTransport transport;
    private HttpContent metadata;
    private long mediaContentLength;
    private boolean isMediaContentLengthCalculated;
    private String initiationRequestMethod = "POST";
    private HttpHeaders initiationHeaders = new HttpHeaders();
    private HttpRequest currentRequest;
    private InputStream contentInputStream;
    private boolean backOffPolicyEnabled = true;
    private boolean directUploadEnabled;
    private MediaHttpUploaderProgressListener progressListener;
    private long bytesUploaded;
    private int chunkSize = 0xA00000;
    private Byte cachedByte;
    private byte[] currentRequestContentBuffer;
    private boolean disableGZipContent;

    public MediaHttpUploader(AbstractInputStreamContent mediaContent, HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this.mediaContent = (AbstractInputStreamContent)Preconditions.checkNotNull((Object)mediaContent);
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse upload(GenericUrl initiationRequestUrl) throws IOException {
        GenericUrl uploadUrl;
        Preconditions.checkArgument((this.uploadState == UploadState.NOT_STARTED ? 1 : 0) != 0);
        if (this.directUploadEnabled) {
            this.updateStateAndNotifyListener(UploadState.MEDIA_IN_PROGRESS);
            AbstractInputStreamContent content = this.mediaContent;
            if (this.metadata != null) {
                content = new MultipartContent().setContentParts(Arrays.asList(this.metadata, this.mediaContent));
                initiationRequestUrl.put("uploadType", (Object)"multipart");
            } else {
                initiationRequestUrl.put("uploadType", (Object)"media");
            }
            HttpRequest request = this.requestFactory.buildRequest(this.initiationRequestMethod, initiationRequestUrl, (HttpContent)content);
            request.getHeaders().putAll((Map)this.initiationHeaders);
            HttpResponse response = this.executeCurrentRequestWithBackOffAndGZip(request);
            boolean responseProcessed = false;
            try {
                if (this.getMediaContentLength() >= 0L) {
                    this.bytesUploaded = this.getMediaContentLength();
                }
                this.updateStateAndNotifyListener(UploadState.MEDIA_COMPLETE);
                responseProcessed = true;
            }
            finally {
                if (!responseProcessed) {
                    response.disconnect();
                }
            }
            return response;
        }
        HttpResponse initialResponse = this.executeUploadInitiation(initiationRequestUrl);
        if (!initialResponse.isSuccessStatusCode()) {
            return initialResponse;
        }
        try {
            uploadUrl = new GenericUrl(initialResponse.getHeaders().getLocation());
        }
        finally {
            initialResponse.disconnect();
        }
        this.contentInputStream = this.mediaContent.getInputStream();
        if (!this.contentInputStream.markSupported() && this.getMediaContentLength() >= 0L) {
            this.contentInputStream = new BufferedInputStream(this.contentInputStream);
        }
        while (true) {
            this.currentRequest = this.requestFactory.buildPutRequest(uploadUrl, null);
            this.setContentAndHeadersOnCurrentRequest(this.bytesUploaded);
            if (this.backOffPolicyEnabled) {
                this.currentRequest.setBackOffPolicy((BackOffPolicy)new MediaUploadExponentialBackOffPolicy(this));
            }
            if (this.getMediaContentLength() < 0L && !this.disableGZipContent) {
                this.currentRequest.setEncoding((HttpEncoding)new GZipEncoding());
            }
            HttpResponse response = this.executeCurrentRequest(this.currentRequest);
            boolean returningResponse = false;
            try {
                HttpResponse httpResponse;
                if (response.isSuccessStatusCode()) {
                    this.bytesUploaded = this.getMediaContentLength();
                    if (this.mediaContent.getCloseInputStream()) {
                        this.contentInputStream.close();
                    }
                    this.updateStateAndNotifyListener(UploadState.MEDIA_COMPLETE);
                    returningResponse = true;
                    httpResponse = response;
                    return httpResponse;
                }
                if (response.getStatusCode() != 308) {
                    returningResponse = true;
                    httpResponse = response;
                    return httpResponse;
                }
                String updatedUploadUrl = response.getHeaders().getLocation();
                if (updatedUploadUrl != null) {
                    uploadUrl = new GenericUrl(updatedUploadUrl);
                }
                this.bytesUploaded = this.getNextByteIndex(response.getHeaders().getRange());
                this.currentRequestContentBuffer = null;
                this.updateStateAndNotifyListener(UploadState.MEDIA_IN_PROGRESS);
                continue;
            }
            finally {
                if (returningResponse) continue;
                response.disconnect();
                continue;
            }
            break;
        }
    }

    private long getMediaContentLength() throws IOException {
        if (!this.isMediaContentLengthCalculated) {
            this.mediaContentLength = this.mediaContent.getLength();
            this.isMediaContentLengthCalculated = true;
        }
        return this.mediaContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeUploadInitiation(GenericUrl initiationRequestUrl) throws IOException {
        this.updateStateAndNotifyListener(UploadState.INITIATION_STARTED);
        initiationRequestUrl.put("uploadType", (Object)"resumable");
        EmptyContent content = this.metadata == null ? new EmptyContent() : this.metadata;
        HttpRequest request = this.requestFactory.buildRequest(this.initiationRequestMethod, initiationRequestUrl, (HttpContent)content);
        this.initiationHeaders.set(CONTENT_TYPE_HEADER, (Object)this.mediaContent.getType());
        if (this.getMediaContentLength() >= 0L) {
            this.initiationHeaders.set(CONTENT_LENGTH_HEADER, (Object)this.getMediaContentLength());
        }
        request.getHeaders().putAll((Map)this.initiationHeaders);
        HttpResponse response = this.executeCurrentRequestWithBackOffAndGZip(request);
        boolean notificationCompleted = false;
        try {
            this.updateStateAndNotifyListener(UploadState.INITIATION_COMPLETE);
            notificationCompleted = true;
        }
        finally {
            if (!notificationCompleted) {
                response.disconnect();
            }
        }
        return response;
    }

    private HttpResponse executeCurrentRequest(HttpRequest request) throws IOException {
        new MethodOverride().intercept(request);
        request.setThrowExceptionOnExecuteError(false);
        request.setRetryOnExecuteIOException(true);
        HttpResponse response = request.execute();
        return response;
    }

    private HttpResponse executeCurrentRequestWithBackOffAndGZip(HttpRequest request) throws IOException {
        if (this.backOffPolicyEnabled) {
            request.setBackOffPolicy((BackOffPolicy)new ExponentialBackOffPolicy());
        }
        if (!this.disableGZipContent && !(request.getContent() instanceof EmptyContent)) {
            request.setEncoding((HttpEncoding)new GZipEncoding());
        }
        HttpResponse response = this.executeCurrentRequest(request);
        return response;
    }

    private void setContentAndHeadersOnCurrentRequest(long bytesWritten) throws IOException {
        String mediaContentLengthStr;
        InputStreamContent contentChunk;
        int blockSize = this.getMediaContentLength() >= 0L ? (int)Math.min((long)this.chunkSize, this.getMediaContentLength() - bytesWritten) : this.chunkSize;
        int actualBlockSize = blockSize;
        if (this.getMediaContentLength() >= 0L) {
            this.contentInputStream.mark(blockSize);
            InputStream limitInputStream = ByteStreams.limit((InputStream)this.contentInputStream, (long)blockSize);
            contentChunk = new InputStreamContent(this.mediaContent.getType(), limitInputStream).setRetrySupported(true).setLength((long)blockSize).setCloseInputStream(false);
            mediaContentLengthStr = String.valueOf(this.getMediaContentLength());
        } else {
            int actualBytesRead;
            int bytesAllowedToRead;
            int contentBufferStartIndex = 0;
            if (this.currentRequestContentBuffer == null) {
                bytesAllowedToRead = this.cachedByte == null ? blockSize + 1 : blockSize;
                this.currentRequestContentBuffer = new byte[blockSize + 1];
                if (this.cachedByte != null) {
                    this.currentRequestContentBuffer[0] = this.cachedByte;
                }
                actualBytesRead = ByteStreams.read((InputStream)this.contentInputStream, (byte[])this.currentRequestContentBuffer, (int)(blockSize + 1 - bytesAllowedToRead), (int)bytesAllowedToRead);
            } else {
                bytesAllowedToRead = (int)((long)this.chunkSize - (bytesWritten - this.bytesUploaded) + 1L);
                contentBufferStartIndex = (int)(bytesWritten - this.bytesUploaded);
                actualBytesRead = bytesAllowedToRead;
            }
            if (actualBytesRead < bytesAllowedToRead) {
                actualBlockSize = Math.max(0, actualBytesRead);
                if (this.cachedByte != null) {
                    ++actualBlockSize;
                }
                mediaContentLengthStr = String.valueOf(bytesWritten + (long)actualBlockSize);
            } else {
                this.cachedByte = this.currentRequestContentBuffer[blockSize];
                mediaContentLengthStr = "*";
            }
            contentChunk = new ByteArrayContent(this.mediaContent.getType(), this.currentRequestContentBuffer, contentBufferStartIndex, actualBlockSize);
        }
        this.currentRequest.setContent((HttpContent)contentChunk);
        if (actualBlockSize == 0) {
            this.currentRequest.getHeaders().setContentRange("bytes */0");
        } else {
            this.currentRequest.getHeaders().setContentRange("bytes " + bytesWritten + "-" + (bytesWritten + (long)actualBlockSize - 1L) + "/" + mediaContentLengthStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverErrorCallback() throws IOException {
        Preconditions.checkNotNull((Object)this.currentRequest, (Object)"The current request should not be null");
        HttpRequest request = this.requestFactory.buildPutRequest(this.currentRequest.getUrl(), (HttpContent)new EmptyContent());
        request.getHeaders().setContentRange("bytes */" + (this.getMediaContentLength() >= 0L ? Long.valueOf(this.getMediaContentLength()) : "*"));
        HttpResponse response = this.executeCurrentRequestWithBackOffAndGZip(request);
        try {
            long bytesWritten = this.getNextByteIndex(response.getHeaders().getRange());
            String updatedUploadUrl = response.getHeaders().getLocation();
            if (updatedUploadUrl != null) {
                this.currentRequest.setUrl(new GenericUrl(updatedUploadUrl));
            }
            if (this.getMediaContentLength() >= 0L) {
                this.contentInputStream.reset();
                long skipValue = this.bytesUploaded - bytesWritten;
                long actualSkipValue = this.contentInputStream.skip(skipValue);
                Preconditions.checkState((skipValue == actualSkipValue ? 1 : 0) != 0);
            }
            this.setContentAndHeadersOnCurrentRequest(bytesWritten);
        }
        finally {
            response.disconnect();
        }
    }

    private long getNextByteIndex(String rangeHeader) {
        if (rangeHeader == null) {
            return 0L;
        }
        return Long.parseLong(rangeHeader.substring(rangeHeader.indexOf(45) + 1)) + 1L;
    }

    public HttpContent getMetadata() {
        return this.metadata;
    }

    public MediaHttpUploader setMetadata(HttpContent metadata) {
        this.metadata = metadata;
        return this;
    }

    public HttpContent getMediaContent() {
        return this.mediaContent;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public MediaHttpUploader setBackOffPolicyEnabled(boolean backOffPolicyEnabled) {
        this.backOffPolicyEnabled = backOffPolicyEnabled;
        return this;
    }

    public boolean isBackOffPolicyEnabled() {
        return this.backOffPolicyEnabled;
    }

    public MediaHttpUploader setDirectUploadEnabled(boolean directUploadEnabled) {
        this.directUploadEnabled = directUploadEnabled;
        return this;
    }

    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    public MediaHttpUploader setProgressListener(MediaHttpUploaderProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public MediaHttpUploaderProgressListener getProgressListener() {
        return this.progressListener;
    }

    public MediaHttpUploader setChunkSize(int chunkSize) {
        Preconditions.checkArgument((chunkSize > 0 && chunkSize % 262144 == 0 ? 1 : 0) != 0);
        this.chunkSize = chunkSize;
        return this;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public boolean getDisableGZipContent() {
        return this.disableGZipContent;
    }

    public MediaHttpUploader setDisableGZipContent(boolean disableGZipContent) {
        this.disableGZipContent = disableGZipContent;
        return this;
    }

    public String getInitiationRequestMethod() {
        return this.initiationRequestMethod;
    }

    public MediaHttpUploader setInitiationRequestMethod(String initiationRequestMethod) {
        Preconditions.checkArgument((initiationRequestMethod.equals("POST") || initiationRequestMethod.equals("PUT") ? 1 : 0) != 0);
        this.initiationRequestMethod = initiationRequestMethod;
        return this;
    }

    public MediaHttpUploader setInitiationHeaders(HttpHeaders initiationHeaders) {
        this.initiationHeaders = initiationHeaders;
        return this;
    }

    public HttpHeaders getInitiationHeaders() {
        return this.initiationHeaders;
    }

    public long getNumBytesUploaded() {
        return this.bytesUploaded;
    }

    private void updateStateAndNotifyListener(UploadState uploadState) throws IOException {
        this.uploadState = uploadState;
        if (this.progressListener != null) {
            this.progressListener.progressChanged(this);
        }
    }

    public UploadState getUploadState() {
        return this.uploadState;
    }

    public double getProgress() throws IOException {
        Preconditions.checkArgument((this.getMediaContentLength() >= 0L ? 1 : 0) != 0, (Object)"Cannot call getProgress() if the specified AbstractInputStreamContent has no content length. Use  getNumBytesUploaded() to denote progress instead.");
        return this.getMediaContentLength() == 0L ? 0.0 : (double)this.bytesUploaded / (double)this.getMediaContentLength();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UploadState {
        NOT_STARTED,
        INITIATION_STARTED,
        INITIATION_COMPLETE,
        MEDIA_IN_PROGRESS,
        MEDIA_COMPLETE;

    }
}

