/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.gatein.api.ApiException;
import org.gatein.api.common.i18n.Localized;
import org.gatein.api.common.i18n.LocalizedString;
import org.gatein.api.navigation.PublicationDate;
import org.gatein.api.navigation.Visibility;

public class ObjectFactory {
    private ObjectFactory() {
    }

    public static LocalizedString createLocalizedString(Map<Locale, Described.State> descriptions) {
        if (descriptions == null) {
            return null;
        }
        HashMap<Locale, String> m = new HashMap<Locale, String>();
        for (Map.Entry<Locale, Described.State> entry : descriptions.entrySet()) {
            if (entry.getValue().getName() == null) continue;
            m.put(entry.getKey(), entry.getValue().getName());
        }
        return new LocalizedString(m);
    }

    public static Map<Locale, Described.State> createDescriptions(LocalizedString string) {
        HashMap<Locale, Described.State> descriptions = new HashMap<Locale, Described.State>();
        for (Localized.Value v : string.getLocalizedValues()) {
            descriptions.put(v.getLocale(), new Described.State((String)((Object)v.getValue()), null));
        }
        return descriptions;
    }

    public static org.exoplatform.portal.mop.Visibility createVisibility(Visibility.Status flag) {
        switch (flag) {
            case VISIBLE: {
                return org.exoplatform.portal.mop.Visibility.DISPLAYED;
            }
            case HIDDEN: {
                return org.exoplatform.portal.mop.Visibility.HIDDEN;
            }
            case SYSTEM: {
                return org.exoplatform.portal.mop.Visibility.SYSTEM;
            }
        }
        throw new ApiException("Unknown visibility flag " + flag);
    }

    public static Visibility createVisibility(NodeState nodeState) {
        Visibility.Status flag = ObjectFactory.createFlag(nodeState.getVisibility());
        if (flag == Visibility.Status.PUBLICATION) {
            long start = nodeState.getStartPublicationTime();
            long end = nodeState.getEndPublicationTime();
            PublicationDate publicationDate = null;
            if (start != -1L && end != -1L) {
                publicationDate = PublicationDate.between((Date)new Date(start), (Date)new Date(end));
            } else if (start != -1L) {
                publicationDate = PublicationDate.startingOn((Date)new Date(start));
            } else if (end != -1L) {
                publicationDate = PublicationDate.endingOn((Date)new Date(end));
            }
            return new Visibility(publicationDate);
        }
        return new Visibility(flag);
    }

    private static Visibility.Status createFlag(org.exoplatform.portal.mop.Visibility visibility) {
        switch (visibility) {
            case DISPLAYED: {
                return Visibility.Status.VISIBLE;
            }
            case HIDDEN: {
                return Visibility.Status.HIDDEN;
            }
            case SYSTEM: {
                return Visibility.Status.SYSTEM;
            }
            case TEMPORAL: {
                return Visibility.Status.PUBLICATION;
            }
        }
        throw new ApiException("Unknown internal visibility '" + visibility + "'");
    }
}

