/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.FunctionInjector;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.javascript.jscomp.SpecializeModule;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class InlineFunctions
implements SpecializationAwareCompilerPass {
    private final Map<String, FunctionState> fns = Maps.newHashMap();
    private final Map<Node, String> anonFns = Maps.newHashMap();
    private final AbstractCompiler compiler;
    private final FunctionInjector injector;
    private final boolean blockFunctionInliningEnabled;
    private final boolean inlineGlobalFunctions;
    private final boolean inlineLocalFunctions;
    private final boolean assumeMinimumCapture;
    private SpecializeModule.SpecializationState specializationState;

    InlineFunctions(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier, boolean inlineGlobalFunctions, boolean inlineLocalFunctions, boolean blockFunctionInliningEnabled, boolean assumeStrictThis, boolean assumeMinimumCapture) {
        Preconditions.checkArgument((compiler != null ? 1 : 0) != 0);
        Preconditions.checkArgument((safeNameIdSupplier != null ? 1 : 0) != 0);
        this.compiler = compiler;
        this.inlineGlobalFunctions = inlineGlobalFunctions;
        this.inlineLocalFunctions = inlineLocalFunctions;
        this.blockFunctionInliningEnabled = blockFunctionInliningEnabled;
        this.assumeMinimumCapture = assumeMinimumCapture;
        this.injector = new FunctionInjector(compiler, safeNameIdSupplier, true, assumeStrictThis, assumeMinimumCapture);
    }

    FunctionState getOrCreateFunctionState(String fnName) {
        FunctionState fs = this.fns.get(fnName);
        if (fs == null) {
            fs = new FunctionState();
            this.fns.put(fnName, fs);
        }
        return fs;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState specializationState) {
        this.specializationState = specializationState;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, new FindCandidateFunctions());
        if (this.fns.isEmpty()) {
            return;
        }
        NodeTraversal.traverse(this.compiler, root, new FindCandidatesReferences(this.fns, this.anonFns));
        this.trimCanidatesNotMeetingMinimumRequirements();
        if (this.fns.isEmpty()) {
            return;
        }
        HashSet fnNames = Sets.newHashSet(this.fns.keySet());
        this.injector.setKnownConstants(fnNames);
        this.trimCanidatesUsingOnCost();
        if (this.fns.isEmpty()) {
            return;
        }
        this.resolveInlineConflicts();
        this.decomposeExpressions();
        NodeTraversal.traverse(this.compiler, root, new CallVisitor(this.fns, this.anonFns, new Inline(this.injector, this.specializationState)));
        this.removeInlinedFunctions();
    }

    private void maybeAddFunction(Function fn, JSModule module) {
        String name = fn.getName();
        FunctionState fs = this.getOrCreateFunctionState(name);
        if (fs.hasExistingFunctionDefinition()) {
            fs.setInline(false);
        } else if (fs.canInline()) {
            fs.setFn(fn);
            if (this.injector.isDirectCallNodeReplacementPossible(fn.getFunctionNode())) {
                fs.inlineDirectly(true);
            }
            if (!this.isCandidateFunction(fn)) {
                fs.setInline(false);
            }
            if (fs.canInline()) {
                Node block;
                fs.setModule(module);
                Node fnNode = fn.getFunctionNode();
                Set<String> namesToAlias = FunctionArgumentInjector.findModifiedParameters(fnNode);
                if (!namesToAlias.isEmpty()) {
                    fs.inlineDirectly(false);
                    fs.setNamesToAlias(namesToAlias);
                }
                if (NodeUtil.referencesThis(block = NodeUtil.getFunctionBody(fnNode))) {
                    fs.setReferencesThis(true);
                }
                if (NodeUtil.containsFunction(block)) {
                    fs.setHasInnerFunctions(true);
                    if (!this.assumeMinimumCapture && this.hasLocalNames(fnNode)) {
                        fs.setInline(false);
                    }
                }
            }
            if (fs.canInline() && !fs.canInlineDirectly() && !this.blockFunctionInliningEnabled) {
                fs.setInline(false);
            }
        }
    }

    private boolean hasLocalNames(Node fnNode) {
        Node block = NodeUtil.getFunctionBody(fnNode);
        return NodeUtil.getFunctionParameters(fnNode).hasChildren() || NodeUtil.has(block, new NodeUtil.MatchDeclaration(), new NodeUtil.MatchShallowStatement());
    }

    private static Node getContainingFunction(NodeTraversal t) {
        return t.inGlobalScope() ? null : t.getScopeRoot();
    }

    private boolean isCandidateFunction(Function fn) {
        String fnName = fn.getName();
        if (this.compiler.getCodingConvention().isExported(fnName)) {
            return false;
        }
        if ("JSCompiler_renameProperty".equals(fnName)) {
            return false;
        }
        if (this.specializationState != null && !this.specializationState.canFixupFunction(fn.getFunctionNode())) {
            return false;
        }
        Node fnNode = fn.getFunctionNode();
        return this.injector.doesFunctionMeetMinimumRequirements(fnName, fnNode);
    }

    static boolean isCandidateUsage(Node name) {
        Node gramps;
        Node parent = name.getParent();
        Preconditions.checkState((boolean)name.isName());
        if (parent.isVar() || parent.isFunction()) {
            return true;
        }
        if (parent.isCall() && parent.getFirstChild() == name) {
            return true;
        }
        return NodeUtil.isGet(parent) && name == parent.getFirstChild() && name.getNext().isString() && name.getNext().getString().equals("call") && (gramps = name.getAncestor(2)).isCall() && gramps.getFirstChild() == parent;
    }

    private void trimCanidatesNotMeetingMinimumRequirements() {
        Iterator<Map.Entry<String, FunctionState>> i = this.fns.entrySet().iterator();
        while (i.hasNext()) {
            FunctionState fs = i.next().getValue();
            if (fs.hasExistingFunctionDefinition() && fs.canInline()) continue;
            i.remove();
        }
    }

    void trimCanidatesUsingOnCost() {
        Iterator<Map.Entry<String, FunctionState>> i = this.fns.entrySet().iterator();
        while (i.hasNext()) {
            FunctionState fs = i.next().getValue();
            if (fs.hasReferences()) {
                boolean lowersCost = this.mimimizeCost(fs);
                if (lowersCost) continue;
                i.remove();
                continue;
            }
            if (fs.canRemove()) continue;
            i.remove();
        }
    }

    private boolean mimimizeCost(FunctionState fs) {
        if (!this.inliningLowersCost(fs)) {
            if (fs.hasBlockInliningReferences()) {
                fs.setRemove(false);
                fs.removeBlockInliningReferences();
                if (!fs.hasReferences() || !this.inliningLowersCost(fs)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean inliningLowersCost(FunctionState fs) {
        return this.injector.inliningLowersCost(fs.getModule(), fs.getFn().getFunctionNode(), fs.getReferences(), fs.getNamesToAlias(), fs.canRemove(), fs.getReferencesThis());
    }

    private void resolveInlineConflicts() {
        for (FunctionState fs : this.fns.values()) {
            this.resolveInlineConflictsForFunction(fs);
        }
    }

    private void resolveInlineConflictsForFunction(FunctionState fs) {
        if (!fs.hasReferences() || !fs.canInline()) {
            return;
        }
        Node fnNode = fs.getFn().getFunctionNode();
        Set<String> names = this.findCalledFunctions(fnNode);
        if (!names.isEmpty()) {
            for (String name : names) {
                FunctionState fsCalled = this.fns.get(name);
                if (fsCalled == null || !fsCalled.canRemove()) continue;
                fsCalled.setRemove(false);
                if (this.mimimizeCost(fsCalled)) continue;
                fsCalled.setInline(false);
            }
            fs.setSafeFnNode(fs.getFn().getFunctionNode().cloneTree());
        }
    }

    private Set<String> findCalledFunctions(Node node) {
        HashSet changed = Sets.newHashSet();
        this.findCalledFunctions(NodeUtil.getFunctionBody(node), changed);
        return changed;
    }

    private void findCalledFunctions(Node node, Set<String> changed) {
        Preconditions.checkArgument((changed != null ? 1 : 0) != 0);
        if (node.isName() && InlineFunctions.isCandidateUsage(node)) {
            changed.add(node.getString());
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            this.findCalledFunctions(c, changed);
        }
    }

    private void decomposeExpressions() {
        for (FunctionState fs : this.fns.values()) {
            if (!fs.canInline()) continue;
            for (Reference ref : fs.getReferences()) {
                if (!ref.requiresDecomposition) continue;
                this.injector.maybePrepareCall(ref.callNode);
            }
        }
    }

    void removeInlinedFunctions() {
        for (FunctionState fs : this.fns.values()) {
            if (!fs.canRemove()) continue;
            Function fn = fs.getFn();
            Preconditions.checkState((boolean)fs.canInline());
            Preconditions.checkState((fn != null ? 1 : 0) != 0);
            this.verifyAllReferencesInlined(fs);
            if (this.specializationState != null) {
                this.specializationState.reportRemovedFunction(fn.getFunctionNode(), fn.getDeclaringBlock());
            }
            fn.remove();
        }
    }

    void verifyAllReferencesInlined(FunctionState fs) {
        for (Reference ref : fs.getReferences()) {
            if (ref.inlined) continue;
            throw new IllegalStateException("Call site missed.\n call: " + ref.callNode.toStringTree() + "\n parent:  " + ref.callNode.getParent().toStringTree());
        }
    }

    class Reference
    extends FunctionInjector.Reference {
        final boolean requiresDecomposition;
        boolean inlined;

        Reference(Node callNode, JSModule module, FunctionInjector.InliningMode mode, boolean decompose) {
            super(callNode, module, mode);
            this.inlined = false;
            this.requiresDecomposition = decompose;
        }
    }

    private class FunctionExpression
    implements Function {
        private final Node fn;
        private final String fakeName;

        public FunctionExpression(Node fn, int index) {
            this.fn = fn;
            this.fakeName = String.valueOf(index);
        }

        @Override
        public String getName() {
            return this.fakeName;
        }

        @Override
        public Node getFunctionNode() {
            return this.fn;
        }

        @Override
        public void remove() {
        }

        @Override
        public Node getDeclaringBlock() {
            return null;
        }
    }

    private class FunctionVar
    implements Function {
        private final Node var;

        public FunctionVar(Node var) {
            this.var = var;
        }

        @Override
        public String getName() {
            return this.var.getFirstChild().getString();
        }

        @Override
        public Node getFunctionNode() {
            return this.var.getFirstChild().getFirstChild();
        }

        @Override
        public void remove() {
            InlineFunctions.this.compiler.reportChangeToEnclosingScope(this.var);
            NodeUtil.removeChild(this.var.getParent(), this.var);
        }

        @Override
        public Node getDeclaringBlock() {
            return this.var.getParent();
        }
    }

    private class NamedFunction
    implements Function {
        private final Node fn;

        public NamedFunction(Node fn) {
            this.fn = fn;
        }

        @Override
        public String getName() {
            return this.fn.getFirstChild().getString();
        }

        @Override
        public Node getFunctionNode() {
            return this.fn;
        }

        @Override
        public void remove() {
            InlineFunctions.this.compiler.reportChangeToEnclosingScope(this.fn);
            NodeUtil.removeChild(this.fn.getParent(), this.fn);
        }

        @Override
        public Node getDeclaringBlock() {
            return this.fn.getParent();
        }
    }

    private static interface Function {
        public String getName();

        public Node getFunctionNode();

        public void remove();

        public Node getDeclaringBlock();
    }

    private static class FunctionState {
        private Function fn = null;
        private Node safeFnNode = null;
        private boolean inline = true;
        private boolean remove = true;
        private boolean inlineDirectly = false;
        private boolean referencesThis = false;
        private boolean hasInnerFunctions = false;
        private Map<Node, Reference> references = null;
        private JSModule module = null;
        private Set<String> namesToAlias = null;

        private FunctionState() {
        }

        boolean hasExistingFunctionDefinition() {
            return this.fn != null;
        }

        public void setReferencesThis(boolean referencesThis) {
            this.referencesThis = referencesThis;
        }

        public boolean getReferencesThis() {
            return this.referencesThis;
        }

        public void setHasInnerFunctions(boolean hasInnerFunctions) {
            this.hasInnerFunctions = hasInnerFunctions;
        }

        public boolean hasInnerFunctions() {
            return this.hasInnerFunctions;
        }

        void removeBlockInliningReferences() {
            Iterator<Map.Entry<Node, Reference>> i = this.getReferencesInternal().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Node, Reference> entry = i.next();
                if (entry.getValue().mode != FunctionInjector.InliningMode.BLOCK) continue;
                i.remove();
            }
        }

        public boolean hasBlockInliningReferences() {
            for (Reference r : this.getReferencesInternal().values()) {
                if (r.mode != FunctionInjector.InliningMode.BLOCK) continue;
                return true;
            }
            return false;
        }

        public Function getFn() {
            return this.fn;
        }

        public void setFn(Function fn) {
            Preconditions.checkState((this.fn == null ? 1 : 0) != 0);
            this.fn = fn;
        }

        public Node getSafeFnNode() {
            return this.safeFnNode != null ? this.safeFnNode : this.fn.getFunctionNode();
        }

        public void setSafeFnNode(Node safeFnNode) {
            this.safeFnNode = safeFnNode;
        }

        public boolean canInline() {
            return this.inline;
        }

        public void setInline(boolean inline) {
            this.inline = inline;
            if (!inline) {
                this.references = null;
                this.remove = false;
            }
        }

        public boolean canRemove() {
            return this.remove;
        }

        public void setRemove(boolean remove) {
            this.remove = remove;
        }

        public boolean canInlineDirectly() {
            return this.inlineDirectly;
        }

        public void inlineDirectly(boolean directReplacement) {
            this.inlineDirectly = directReplacement;
        }

        public boolean hasReferences() {
            return this.references != null && !this.references.isEmpty();
        }

        private Map<Node, Reference> getReferencesInternal() {
            if (this.references == null) {
                return Collections.emptyMap();
            }
            return this.references;
        }

        public void addReference(Reference ref) {
            if (this.references == null) {
                this.references = Maps.newLinkedHashMap();
            }
            this.references.put(ref.callNode, ref);
        }

        public Collection<Reference> getReferences() {
            return this.getReferencesInternal().values();
        }

        public Reference getReference(Node n) {
            return this.getReferencesInternal().get(n);
        }

        public Set<String> getNamesToAlias() {
            if (this.namesToAlias == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(this.namesToAlias);
        }

        public void setNamesToAlias(Set<String> names) {
            this.namesToAlias = names;
        }

        public void setModule(JSModule module) {
            this.module = module;
        }

        public JSModule getModule() {
            return this.module;
        }
    }

    private static class Inline
    implements CallVisitorCallback {
        private final FunctionInjector injector;
        private final SpecializeModule.SpecializationState specializationState;

        Inline(FunctionInjector injector, SpecializeModule.SpecializationState specializationState) {
            this.injector = injector;
            this.specializationState = specializationState;
        }

        @Override
        public void visitCallSite(NodeTraversal t, Node callNode, Node parent, FunctionState fs) {
            Reference ref;
            Preconditions.checkState((boolean)fs.hasExistingFunctionDefinition());
            if (fs.canInline() && (ref = fs.getReference(callNode)) != null) {
                Node containingFunction;
                if (this.specializationState != null && (containingFunction = InlineFunctions.getContainingFunction(t)) != null) {
                    this.specializationState.reportSpecializedFunction(containingFunction);
                }
                this.inlineFunction(t, callNode, fs, ref.mode);
                ref.inlined = true;
            }
        }

        private void inlineFunction(NodeTraversal t, Node callNode, FunctionState fs, FunctionInjector.InliningMode mode) {
            Function fn = fs.getFn();
            String fnName = fn.getName();
            Node fnNode = fs.getSafeFnNode();
            t.getCompiler().reportChangeToEnclosingScope(callNode);
            this.injector.inline(callNode, fnName, fnNode, mode);
            t.getCompiler().addToDebugLog("Inlined function: " + fn.getName());
        }
    }

    private class FindCandidatesReferences
    extends CallVisitor
    implements CallVisitorCallback {
        FindCandidatesReferences(Map<String, FunctionState> fns, Map<Node, String> anonFns) {
            super(fns, anonFns, null);
            this.callback = this;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            super.visit(t, n, parent);
            if (n.isName()) {
                this.checkNameUsage(n, parent);
            }
        }

        @Override
        public void visitCallSite(NodeTraversal t, Node callNode, Node parent, FunctionState fs) {
            this.maybeAddReference(t, fs, callNode, t.getModule());
        }

        void maybeAddReference(NodeTraversal t, FunctionState fs, Node callNode, JSModule module) {
            if (!fs.canInline()) {
                return;
            }
            boolean referenceAdded = false;
            FunctionInjector.InliningMode mode = fs.canInlineDirectly() ? FunctionInjector.InliningMode.DIRECT : FunctionInjector.InliningMode.BLOCK;
            referenceAdded = this.maybeAddReferenceUsingMode(t, fs, callNode, module, mode);
            if (!referenceAdded && mode == FunctionInjector.InliningMode.DIRECT && InlineFunctions.this.blockFunctionInliningEnabled) {
                mode = FunctionInjector.InliningMode.BLOCK;
                referenceAdded = this.maybeAddReferenceUsingMode(t, fs, callNode, module, mode);
            }
            if (!referenceAdded) {
                fs.setRemove(false);
            }
        }

        private boolean maybeAddReferenceUsingMode(NodeTraversal t, FunctionState fs, Node callNode, JSModule module, FunctionInjector.InliningMode mode) {
            Node containingFunction;
            if (InlineFunctions.this.specializationState != null && (containingFunction = InlineFunctions.getContainingFunction(t)) != null && !InlineFunctions.this.specializationState.canFixupFunction(containingFunction)) {
                return false;
            }
            FunctionInjector.CanInlineResult result = InlineFunctions.this.injector.canInlineReferenceToFunction(t, callNode, fs.getFn().getFunctionNode(), fs.getNamesToAlias(), mode, fs.getReferencesThis(), fs.hasInnerFunctions());
            if (result != FunctionInjector.CanInlineResult.NO) {
                boolean decompose = result == FunctionInjector.CanInlineResult.AFTER_PREPARATION;
                fs.addReference(new Reference(callNode, module, mode, decompose));
                return true;
            }
            return false;
        }

        private void checkNameUsage(Node n, Node parent) {
            Node target;
            Preconditions.checkState((boolean)n.isName());
            if (InlineFunctions.isCandidateUsage(n)) {
                return;
            }
            String name = n.getString();
            FunctionState fs = (FunctionState)InlineFunctions.this.fns.get(name);
            if (fs == null) {
                return;
            }
            if (parent.isNew() && (target = parent.getFirstChild()).isName() && target.getString().equals("JSCompiler_ObjectPropertyString")) {
                fs.setInline(false);
            }
            if (parent.isAssign() && parent.getFirstChild() == n) {
                fs.setInline(false);
            } else {
                fs.setRemove(false);
            }
        }
    }

    private static class CallVisitor
    extends NodeTraversal.AbstractPostOrderCallback {
        protected CallVisitorCallback callback;
        private Map<String, FunctionState> functionMap;
        private Map<Node, String> anonFunctionMap;

        CallVisitor(Map<String, FunctionState> fns, Map<Node, String> anonFns, CallVisitorCallback callback) {
            this.functionMap = fns;
            this.anonFunctionMap = anonFns;
            this.callback = callback;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 37: {
                    FunctionState fs;
                    Node child = n.getFirstChild();
                    String name = null;
                    if (child.isName()) {
                        name = child.getString();
                    } else if (child.isFunction()) {
                        name = this.anonFunctionMap.get(child);
                    } else if (NodeUtil.isFunctionObjectCall(n)) {
                        Preconditions.checkState((boolean)NodeUtil.isGet(child));
                        Node fnIdentifingNode = child.getFirstChild();
                        if (fnIdentifingNode.isName()) {
                            name = fnIdentifingNode.getString();
                        } else if (fnIdentifingNode.isFunction()) {
                            name = this.anonFunctionMap.get(fnIdentifingNode);
                        }
                    }
                    if (name == null || (fs = this.functionMap.get(name)) == null) break;
                    this.callback.visitCallSite(t, n, parent, fs);
                }
            }
        }
    }

    private static interface CallVisitorCallback {
        public void visitCallSite(NodeTraversal var1, Node var2, Node var3, FunctionState var4);
    }

    private class FindCandidateFunctions
    implements NodeTraversal.Callback {
        private int callsSeen = 0;

        private FindCandidateFunctions() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return InlineFunctions.this.inlineLocalFunctions || nodeTraversal.inGlobalScope();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (t.inGlobalScope() && InlineFunctions.this.inlineGlobalFunctions || !t.inGlobalScope() && InlineFunctions.this.inlineLocalFunctions) {
                this.findNamedFunctions(t, n, parent);
                this.findFunctionExpressions(t, n);
            }
        }

        public void findNamedFunctions(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isStatement(n)) {
                return;
            }
            switch (n.getType()) {
                case 118: {
                    Preconditions.checkState((boolean)n.hasOneChild());
                    Node nameNode = n.getFirstChild();
                    if (!nameNode.isName() || !nameNode.hasChildren() || !nameNode.getFirstChild().isFunction()) break;
                    InlineFunctions.this.maybeAddFunction(new FunctionVar(n), t.getModule());
                    break;
                }
                case 105: {
                    Preconditions.checkState((NodeUtil.isStatementBlock(parent) || parent.isLabel() ? 1 : 0) != 0);
                    if (NodeUtil.isFunctionExpression(n)) break;
                    NamedFunction fn = new NamedFunction(n);
                    InlineFunctions.this.maybeAddFunction(fn, t.getModule());
                }
            }
        }

        public void findFunctionExpressions(NodeTraversal t, Node n) {
            switch (n.getType()) {
                case 37: {
                    Node fnIdentifingNode;
                    Node fnNode = null;
                    if (n.getFirstChild().isFunction()) {
                        fnNode = n.getFirstChild();
                    } else if (NodeUtil.isFunctionObjectCall(n) && (fnIdentifingNode = n.getFirstChild().getFirstChild()).isFunction()) {
                        fnNode = fnIdentifingNode;
                    }
                    if (fnNode == null) break;
                    FunctionExpression fn = new FunctionExpression(fnNode, this.callsSeen++);
                    InlineFunctions.this.maybeAddFunction(fn, t.getModule());
                    InlineFunctions.this.anonFns.put(fnNode, fn.getName());
                }
            }
        }
    }
}

