/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.TypeSafeDispatcher;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.head.ErrorReporter;
import com.google.javascript.rhino.head.Node;
import com.google.javascript.rhino.head.Token;
import com.google.javascript.rhino.head.ast.ArrayLiteral;
import com.google.javascript.rhino.head.ast.Assignment;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.AstRoot;
import com.google.javascript.rhino.head.ast.Block;
import com.google.javascript.rhino.head.ast.BreakStatement;
import com.google.javascript.rhino.head.ast.CatchClause;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.ConditionalExpression;
import com.google.javascript.rhino.head.ast.ContinueStatement;
import com.google.javascript.rhino.head.ast.DoLoop;
import com.google.javascript.rhino.head.ast.ElementGet;
import com.google.javascript.rhino.head.ast.EmptyExpression;
import com.google.javascript.rhino.head.ast.EmptyStatement;
import com.google.javascript.rhino.head.ast.ExpressionStatement;
import com.google.javascript.rhino.head.ast.ForInLoop;
import com.google.javascript.rhino.head.ast.ForLoop;
import com.google.javascript.rhino.head.ast.FunctionCall;
import com.google.javascript.rhino.head.ast.FunctionNode;
import com.google.javascript.rhino.head.ast.IfStatement;
import com.google.javascript.rhino.head.ast.InfixExpression;
import com.google.javascript.rhino.head.ast.KeywordLiteral;
import com.google.javascript.rhino.head.ast.Label;
import com.google.javascript.rhino.head.ast.LabeledStatement;
import com.google.javascript.rhino.head.ast.Name;
import com.google.javascript.rhino.head.ast.NewExpression;
import com.google.javascript.rhino.head.ast.NumberLiteral;
import com.google.javascript.rhino.head.ast.ObjectLiteral;
import com.google.javascript.rhino.head.ast.ObjectProperty;
import com.google.javascript.rhino.head.ast.ParenthesizedExpression;
import com.google.javascript.rhino.head.ast.PropertyGet;
import com.google.javascript.rhino.head.ast.RegExpLiteral;
import com.google.javascript.rhino.head.ast.ReturnStatement;
import com.google.javascript.rhino.head.ast.Scope;
import com.google.javascript.rhino.head.ast.StringLiteral;
import com.google.javascript.rhino.head.ast.SwitchCase;
import com.google.javascript.rhino.head.ast.SwitchStatement;
import com.google.javascript.rhino.head.ast.ThrowStatement;
import com.google.javascript.rhino.head.ast.TryStatement;
import com.google.javascript.rhino.head.ast.UnaryExpression;
import com.google.javascript.rhino.head.ast.VariableDeclaration;
import com.google.javascript.rhino.head.ast.VariableInitializer;
import com.google.javascript.rhino.head.ast.WhileLoop;
import com.google.javascript.rhino.head.ast.WithStatement;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.Set;
import java.util.regex.Pattern;

class IRFactory {
    static final String GETTER_ERROR_MESSAGE = "getters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String SETTER_ERROR_MESSAGE = "setters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String SUSPICIOUS_COMMENT_WARNING = "Non-JSDoc comment has annotations. Did you mean to start it with '/**'?";
    static final String MISPLACED_TYPE_ANNOTATION = "Type annotations are not allowed here. Are you missing parentheses?";
    static final String INVALID_ES3_PROP_NAME = "Keywords and reserved words are not allowed as unquoted property names in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    private final String sourceString;
    private final StaticSourceFile sourceFile;
    private final String sourceName;
    private final Config config;
    private final ErrorReporter errorReporter;
    private final TransformDispatcher transformDispatcher;
    private static final ImmutableSet<String> ALLOWED_DIRECTIVES = ImmutableSet.of((Object)"use strict");
    private static final ImmutableSet<String> ES5_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super"});
    private static final ImmutableSet<String> ES5_STRICT_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
    private final Set<String> reservedKeywords;
    private final Set<Comment> parsedComments = Sets.newHashSet();
    com.google.javascript.rhino.Node rootNodeJsDocHolder = new com.google.javascript.rhino.Node(132);
    Node.FileLevelJsDocBuilder fileLevelJsDocBuilder = this.rootNodeJsDocHolder.getJsDocBuilderForNode();
    JSDocInfo fileOverviewInfo = null;
    private final com.google.javascript.rhino.Node templateNode;

    private IRFactory(String sourceString, StaticSourceFile sourceFile, Config config, ErrorReporter errorReporter) {
        this.sourceString = sourceString;
        this.sourceFile = sourceFile;
        this.sourceName = sourceFile == null ? null : sourceFile.getName();
        this.config = config;
        this.errorReporter = errorReporter;
        this.transformDispatcher = new TransformDispatcher();
        this.templateNode = this.createTemplateNode();
        switch (config.languageMode) {
            case ECMASCRIPT3: {
                this.reservedKeywords = null;
                break;
            }
            case ECMASCRIPT5: {
                this.reservedKeywords = ES5_RESERVED_KEYWORDS;
                break;
            }
            case ECMASCRIPT5_STRICT: {
                this.reservedKeywords = ES5_STRICT_RESERVED_KEYWORDS;
                break;
            }
            default: {
                throw new IllegalStateException("unknown language mode");
            }
        }
    }

    private com.google.javascript.rhino.Node createTemplateNode() {
        com.google.javascript.rhino.Node templateNode = new com.google.javascript.rhino.Node(132);
        templateNode.setStaticSourceFile(this.sourceFile);
        return templateNode;
    }

    public static com.google.javascript.rhino.Node transformTree(AstRoot node, StaticSourceFile sourceFile, String sourceString, Config config, ErrorReporter errorReporter) {
        IRFactory irFactory = new IRFactory(sourceString, sourceFile, config, errorReporter);
        com.google.javascript.rhino.Node irNode = irFactory.transform(node);
        if (node.getComments() != null) {
            for (Comment comment : node.getComments()) {
                if (comment.getCommentType() == Token.CommentType.JSDOC && !irFactory.parsedComments.contains(comment)) {
                    irFactory.handlePossibleFileOverviewJsDoc(comment, irNode);
                    continue;
                }
                if (comment.getCommentType() != Token.CommentType.BLOCK_COMMENT) continue;
                irFactory.handleBlockComment(comment);
            }
        }
        irFactory.setFileOverviewJsDoc(irNode);
        return irNode;
    }

    private void setFileOverviewJsDoc(com.google.javascript.rhino.Node irNode) {
        JSDocInfo rootNodeJsDoc = this.rootNodeJsDocHolder.getJSDocInfo();
        if (rootNodeJsDoc != null) {
            irNode.setJSDocInfo(rootNodeJsDoc);
            rootNodeJsDoc.setAssociatedNode(irNode);
        }
        if (this.fileOverviewInfo != null) {
            if (irNode.getJSDocInfo() != null && irNode.getJSDocInfo().getLicense() != null) {
                this.fileOverviewInfo.setLicense(irNode.getJSDocInfo().getLicense());
            }
            irNode.setJSDocInfo(this.fileOverviewInfo);
            this.fileOverviewInfo.setAssociatedNode(irNode);
        }
    }

    private com.google.javascript.rhino.Node transformBlock(AstNode node) {
        com.google.javascript.rhino.Node irNode = this.transform(node);
        if (!irNode.isBlock()) {
            if (irNode.isEmpty()) {
                irNode.setType(125);
                irNode.setWasEmptyNode(true);
            } else {
                com.google.javascript.rhino.Node newBlock = this.newNode(125, irNode);
                newBlock.setLineno(irNode.getLineno());
                newBlock.setCharno(irNode.getCharno());
                this.maybeSetLengthFrom(newBlock, node);
                irNode = newBlock;
            }
        }
        return irNode;
    }

    private void handleBlockComment(Comment comment) {
        Pattern p = Pattern.compile("(/|(\n[ \t]*))\\*[ \t]*@[a-zA-Z]+[ \t\n{]");
        if (p.matcher(comment.getValue()).find()) {
            this.errorReporter.warning(SUSPICIOUS_COMMENT_WARNING, this.sourceName, comment.getLineno(), "", 0);
        }
    }

    private boolean handlePossibleFileOverviewJsDoc(JsDocInfoParser jsDocParser) {
        if (jsDocParser.getFileOverviewJSDocInfo() != this.fileOverviewInfo) {
            this.fileOverviewInfo = jsDocParser.getFileOverviewJSDocInfo();
            return true;
        }
        return false;
    }

    private void handlePossibleFileOverviewJsDoc(Comment comment, com.google.javascript.rhino.Node irNode) {
        JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment, irNode);
        this.parsedComments.add(comment);
        this.handlePossibleFileOverviewJsDoc(jsDocParser);
    }

    private JSDocInfo handleJsDoc(AstNode node, com.google.javascript.rhino.Node irNode) {
        Comment comment = node.getJsDocNode();
        if (comment != null) {
            JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment, irNode);
            this.parsedComments.add(comment);
            if (!this.handlePossibleFileOverviewJsDoc(jsDocParser)) {
                JSDocInfo info = jsDocParser.retrieveAndResetParsedJSDocInfo();
                if (info != null) {
                    this.validateTypeAnnotations(info, node);
                }
                return info;
            }
        }
        return null;
    }

    private void validateTypeAnnotations(JSDocInfo info, AstNode node) {
        if (info.hasType()) {
            boolean valid = false;
            switch (node.getType()) {
                case 87: {
                    valid = node instanceof ParenthesizedExpression;
                    break;
                }
                case 122: {
                    valid = true;
                    break;
                }
                case 109: {
                    FunctionNode fnNode = (FunctionNode)node;
                    valid = fnNode.getFunctionType() == 1;
                    break;
                }
                case 39: {
                    AstNode parent = node.getParent();
                    valid = parent instanceof ObjectProperty || parent instanceof CatchClause || parent instanceof FunctionNode || parent instanceof VariableInitializer && node == ((VariableInitializer)parent).getTarget();
                    break;
                }
                case 40: 
                case 41: 
                case 151: 
                case 152: {
                    valid = node.getParent() instanceof ObjectProperty;
                    break;
                }
                case 90: {
                    if (!(node instanceof Assignment)) break;
                    valid = IRFactory.isExprStmt(node.getParent()) && IRFactory.isPropAccess(((Assignment)node).getLeft());
                    break;
                }
                case 33: 
                case 36: {
                    valid = IRFactory.isExprStmt(node.getParent());
                    break;
                }
                case 38: {
                    valid = info.isDefine();
                }
            }
            if (!valid) {
                this.errorReporter.warning(MISPLACED_TYPE_ANNOTATION, this.sourceName, node.getLineno(), "", 0);
            }
        }
    }

    private static boolean isPropAccess(AstNode node) {
        return node.getType() == 33 || node.getType() == 36;
    }

    private static boolean isExprStmt(AstNode node) {
        return node.getType() == 134 || node.getType() == 133;
    }

    private com.google.javascript.rhino.Node transform(AstNode node) {
        com.google.javascript.rhino.Node irNode = this.justTransform(node);
        JSDocInfo jsDocInfo = this.handleJsDoc(node, irNode);
        if (jsDocInfo != null) {
            irNode = this.maybeInjectCastNode(node, jsDocInfo, irNode);
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, node);
        return irNode;
    }

    private com.google.javascript.rhino.Node maybeInjectCastNode(AstNode node, JSDocInfo info, com.google.javascript.rhino.Node irNode) {
        if (node.getType() == 87 && node instanceof ParenthesizedExpression && info.hasType()) {
            irNode = this.newNode(155, irNode);
        }
        return irNode;
    }

    private com.google.javascript.rhino.Node transformNodeWithInlineJsDoc(AstNode node) {
        JSDocInfo info;
        com.google.javascript.rhino.Node irNode = this.justTransform(node);
        Comment comment = node.getJsDocNode();
        if (comment != null && (info = this.parseInlineTypeDoc(comment, irNode)) != null) {
            irNode.setJSDocInfo(info);
        }
        this.setSourceInfo(irNode, node);
        return irNode;
    }

    private com.google.javascript.rhino.Node transformNameAsString(Name node) {
        com.google.javascript.rhino.Node irNode = this.transformDispatcher.processName(node, true);
        JSDocInfo jsDocInfo = this.handleJsDoc(node, irNode);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, node);
        return irNode;
    }

    private com.google.javascript.rhino.Node transformNumberAsString(NumberLiteral literalNode) {
        com.google.javascript.rhino.Node irNode = this.newStringNode(IRFactory.getStringValue(literalNode.getNumber()));
        JSDocInfo jsDocInfo = this.handleJsDoc(literalNode, irNode);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, literalNode);
        return irNode;
    }

    private static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    private void setSourceInfo(com.google.javascript.rhino.Node irNode, AstNode node) {
        if (irNode.getLineno() == -1) {
            int lineno = node.getLineno();
            irNode.setLineno(lineno);
            int charno = this.position2charno(node.getAbsolutePosition());
            irNode.setCharno(charno);
            this.maybeSetLengthFrom(irNode, node);
        }
    }

    private JsDocInfoParser createJsDocInfoParser(Comment node, com.google.javascript.rhino.Node irNode) {
        String comment = node.getValue();
        int lineno = node.getLineno();
        int position = node.getAbsolutePosition();
        int numOpeningChars = 3;
        JsDocInfoParser jsdocParser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, this.position2charno(position) + numOpeningChars), node, irNode, this.config, this.errorReporter);
        jsdocParser.setFileLevelJsDocBuilder(this.fileLevelJsDocBuilder);
        jsdocParser.setFileOverviewJSDocInfo(this.fileOverviewInfo);
        jsdocParser.parse();
        return jsdocParser;
    }

    private JSDocInfo parseInlineTypeDoc(Comment node, com.google.javascript.rhino.Node irNode) {
        String comment = node.getValue();
        int lineno = node.getLineno();
        int position = node.getAbsolutePosition();
        int numOpeningChars = 3;
        JsDocInfoParser parser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, this.position2charno(position) + numOpeningChars), node, irNode, this.config, this.errorReporter);
        return parser.parseInlineTypeDoc();
    }

    private void maybeSetLengthFrom(com.google.javascript.rhino.Node node, AstNode source) {
        if (this.config.isIdeMode) {
            node.setLength(source.getLength());
        }
    }

    private int position2charno(int position) {
        int lineIndex = this.sourceString.lastIndexOf(10, position);
        if (lineIndex == -1) {
            return position;
        }
        return position - lineIndex - 1;
    }

    private com.google.javascript.rhino.Node justTransform(AstNode node) {
        return (com.google.javascript.rhino.Node)this.transformDispatcher.process(node);
    }

    private static int transformTokenType(int token) {
        switch (token) {
            case 4: {
                return 4;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 27: {
                return 27;
            }
            case 28: {
                return 28;
            }
            case 29: {
                return 29;
            }
            case 30: {
                return 30;
            }
            case 31: {
                return 31;
            }
            case 32: {
                return 32;
            }
            case 33: {
                return 33;
            }
            case 36: {
                return 35;
            }
            case 38: {
                return 37;
            }
            case 39: {
                return 38;
            }
            case 40: {
                return 39;
            }
            case 41: {
                return 40;
            }
            case 42: {
                return 41;
            }
            case 43: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 45: {
                return 44;
            }
            case 46: {
                return 45;
            }
            case 47: {
                return 46;
            }
            case 48: {
                return 47;
            }
            case 50: {
                return 49;
            }
            case 52: {
                return 51;
            }
            case 53: {
                return 52;
            }
            case 65: {
                return 63;
            }
            case 66: {
                return 64;
            }
            case 81: {
                return 77;
            }
            case 87: {
                return 83;
            }
            case 89: {
                return 85;
            }
            case 90: {
                return 86;
            }
            case 91: {
                return 87;
            }
            case 92: {
                return 88;
            }
            case 93: {
                return 89;
            }
            case 94: {
                return 90;
            }
            case 95: {
                return 91;
            }
            case 96: {
                return 92;
            }
            case 97: {
                return 93;
            }
            case 98: {
                return 94;
            }
            case 99: {
                return 95;
            }
            case 100: {
                return 96;
            }
            case 101: {
                return 97;
            }
            case 102: {
                return 98;
            }
            case 104: {
                return 100;
            }
            case 105: {
                return 101;
            }
            case 106: {
                return 102;
            }
            case 107: {
                return 103;
            }
            case 109: {
                return 105;
            }
            case 112: {
                return 108;
            }
            case 114: {
                return 110;
            }
            case 115: {
                return 111;
            }
            case 116: {
                return 112;
            }
            case 117: {
                return 113;
            }
            case 118: {
                return 114;
            }
            case 119: {
                return 115;
            }
            case 120: {
                return 116;
            }
            case 121: {
                return 117;
            }
            case 122: {
                return 118;
            }
            case 123: {
                return 119;
            }
            case 124: {
                return 120;
            }
            case 126: {
                return 122;
            }
            case 128: {
                return 124;
            }
            case 129: {
                return 125;
            }
            case 130: {
                return 126;
            }
            case 133: 
            case 134: {
                return 130;
            }
            case 136: {
                return 132;
            }
            case 151: {
                return 147;
            }
            case 152: {
                return 148;
            }
            case 154: {
                return 149;
            }
            case 160: {
                return 152;
            }
        }
        throw new IllegalStateException(String.valueOf(token));
    }

    private com.google.javascript.rhino.Node newNode(int type) {
        return new com.google.javascript.rhino.Node(type).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNode(int type, com.google.javascript.rhino.Node child1) {
        return new com.google.javascript.rhino.Node(type, child1).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNode(int type, com.google.javascript.rhino.Node child1, com.google.javascript.rhino.Node child2) {
        return new com.google.javascript.rhino.Node(type, child1, child2).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNode(int type, com.google.javascript.rhino.Node child1, com.google.javascript.rhino.Node child2, com.google.javascript.rhino.Node child3) {
        return new com.google.javascript.rhino.Node(type, child1, child2, child3).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newStringNode(String value) {
        return IR.string(value).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newStringNode(int type, String value) {
        return com.google.javascript.rhino.Node.newString(type, value).clonePropsFrom(this.templateNode);
    }

    private com.google.javascript.rhino.Node newNumberNode(Double value) {
        return IR.number(value).clonePropsFrom(this.templateNode);
    }

    private class TransformDispatcher
    extends TypeSafeDispatcher<com.google.javascript.rhino.Node> {
        private TransformDispatcher() {
        }

        private com.google.javascript.rhino.Node processGeneric(Node n) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(IRFactory.transformTokenType(n.getType()));
            for (Node child : n) {
                node.addChildToBack(IRFactory.this.transform((AstNode)child));
            }
            return node;
        }

        private com.google.javascript.rhino.Node transformAsString(AstNode n) {
            com.google.javascript.rhino.Node ret;
            if (n instanceof Name) {
                ret = IRFactory.this.transformNameAsString((Name)n);
            } else if (n instanceof NumberLiteral) {
                ret = IRFactory.this.transformNumberAsString((NumberLiteral)n);
                ret.putBooleanProp(36, true);
            } else {
                ret = IRFactory.this.transform(n);
                ret.putBooleanProp(36, true);
            }
            Preconditions.checkState((boolean)ret.isString());
            return ret;
        }

        @Override
        com.google.javascript.rhino.Node processArrayLiteral(ArrayLiteral literalNode) {
            if (literalNode.isDestructuring()) {
                this.reportDestructuringAssign(literalNode);
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(63);
            for (AstNode child : literalNode.getElements()) {
                com.google.javascript.rhino.Node c = IRFactory.this.transform(child);
                node.addChildToBack(c);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processAssignment(Assignment assignmentNode) {
            com.google.javascript.rhino.Node assign = this.processInfixExpression(assignmentNode);
            com.google.javascript.rhino.Node target = assign.getFirstChild();
            if (!this.validAssignmentTarget(target)) {
                IRFactory.this.errorReporter.error("invalid assignment target", IRFactory.this.sourceName, target.getLineno(), "", 0);
            }
            return assign;
        }

        @Override
        com.google.javascript.rhino.Node processAstRoot(AstRoot rootNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(132);
            for (Node child : rootNode) {
                node.addChildToBack(IRFactory.this.transform((AstNode)child));
            }
            this.parseDirectives(node);
            return node;
        }

        private void parseDirectives(com.google.javascript.rhino.Node node) {
            Set directives = null;
            while (this.isDirective(node.getFirstChild())) {
                String directive = node.removeFirstChild().getFirstChild().getString();
                if (directives == null) {
                    directives = Sets.newHashSet((Object[])new String[]{directive});
                    continue;
                }
                directives.add(directive);
            }
            if (directives != null) {
                node.setDirectives(directives);
            }
        }

        private boolean isDirective(com.google.javascript.rhino.Node n) {
            if (n == null) {
                return false;
            }
            int nType = n.getType();
            return nType == 130 && n.getFirstChild().isString() && ALLOWED_DIRECTIVES.contains((Object)n.getFirstChild().getString());
        }

        @Override
        com.google.javascript.rhino.Node processBlock(Block blockNode) {
            return this.processGeneric(blockNode);
        }

        @Override
        com.google.javascript.rhino.Node processBreakStatement(BreakStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(116);
            if (statementNode.getBreakLabel() != null) {
                com.google.javascript.rhino.Node labelName = IRFactory.this.transform(statementNode.getBreakLabel());
                labelName.setType(153);
                node.addChildToBack(labelName);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processCatchClause(CatchClause clauseNode) {
            Name catchVar = clauseNode.getVarName();
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(120, IRFactory.this.transform(catchVar));
            if (clauseNode.getCatchCondition() != null) {
                IRFactory.this.errorReporter.error("Catch clauses are not supported", IRFactory.this.sourceName, clauseNode.getCatchCondition().getLineno(), "", 0);
            }
            node.addChildToBack(IRFactory.this.transformBlock(clauseNode.getBody()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processConditionalExpression(ConditionalExpression exprNode) {
            return IRFactory.this.newNode(98, IRFactory.this.transform(exprNode.getTestExpression()), IRFactory.this.transform(exprNode.getTrueExpression()), IRFactory.this.transform(exprNode.getFalseExpression()));
        }

        @Override
        com.google.javascript.rhino.Node processContinueStatement(ContinueStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(117);
            if (statementNode.getLabel() != null) {
                com.google.javascript.rhino.Node labelName = IRFactory.this.transform(statementNode.getLabel());
                labelName.setType(153);
                node.addChildToBack(labelName);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processDoLoop(DoLoop loopNode) {
            return IRFactory.this.newNode(114, IRFactory.this.transformBlock(loopNode.getBody()), IRFactory.this.transform(loopNode.getCondition()));
        }

        @Override
        com.google.javascript.rhino.Node processElementGet(ElementGet getNode) {
            return IRFactory.this.newNode(35, IRFactory.this.transform(getNode.getTarget()), IRFactory.this.transform(getNode.getElement()));
        }

        @Override
        com.google.javascript.rhino.Node processEmptyExpression(EmptyExpression exprNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(124);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processEmptyStatement(EmptyStatement exprNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(124);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processExpressionStatement(ExpressionStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(IRFactory.transformTokenType(statementNode.getType()));
            node.addChildToBack(IRFactory.this.transform(statementNode.getExpression()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processForInLoop(ForInLoop loopNode) {
            if (loopNode.isForEach()) {
                IRFactory.this.errorReporter.error("unsupported language extension: for each", IRFactory.this.sourceName, loopNode.getLineno(), "", 0);
                return IRFactory.this.newNode(130, com.google.javascript.rhino.Node.newNumber(0.0));
            }
            return IRFactory.this.newNode(115, IRFactory.this.transform(loopNode.getIterator()), IRFactory.this.transform(loopNode.getIteratedObject()), IRFactory.this.transformBlock(loopNode.getBody()));
        }

        @Override
        com.google.javascript.rhino.Node processForLoop(ForLoop loopNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(115, IRFactory.this.transform(loopNode.getInitializer()), IRFactory.this.transform(loopNode.getCondition()), IRFactory.this.transform(loopNode.getIncrement()));
            node.addChildToBack(IRFactory.this.transformBlock(loopNode.getBody()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processFunctionCall(FunctionCall callNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(IRFactory.transformTokenType(callNode.getType()), IRFactory.this.transform(callNode.getTarget()));
            for (AstNode child : callNode.getArguments()) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            node.setLineno(node.getFirstChild().getLineno());
            node.setCharno(node.getFirstChild().getCharno());
            IRFactory.this.maybeSetLengthFrom(node, callNode);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processFunctionNode(FunctionNode functionNode) {
            Name name = functionNode.getFunctionName();
            Boolean isUnnamedFunction = false;
            if (name == null) {
                int functionType = functionNode.getFunctionType();
                if (functionType != 2) {
                    IRFactory.this.errorReporter.error("unnamed function statement", IRFactory.this.sourceName, functionNode.getLineno(), "", 0);
                    return IRFactory.this.newNode(130, com.google.javascript.rhino.Node.newNumber(0.0));
                }
                name = new Name();
                name.setIdentifier("");
                isUnnamedFunction = true;
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(105);
            com.google.javascript.rhino.Node newName = IRFactory.this.transformNodeWithInlineJsDoc(name);
            if (isUnnamedFunction.booleanValue()) {
                newName.setLineno(functionNode.getLineno());
                int lpColumn = functionNode.getAbsolutePosition() + functionNode.getLp();
                newName.setCharno(IRFactory.this.position2charno(lpColumn));
                IRFactory.this.maybeSetLengthFrom(newName, name);
            }
            node.addChildToBack(newName);
            com.google.javascript.rhino.Node lp = IRFactory.this.newNode(83);
            Name fnName = functionNode.getFunctionName();
            if (fnName != null) {
                lp.setLineno(fnName.getLineno());
            } else {
                lp.setLineno(functionNode.getLineno());
            }
            int lparenCharno = functionNode.getLp() + functionNode.getAbsolutePosition();
            lp.setCharno(IRFactory.this.position2charno(lparenCharno));
            for (AstNode param : functionNode.getParams()) {
                com.google.javascript.rhino.Node paramNode = IRFactory.this.transformNodeWithInlineJsDoc(param);
                if (paramNode.isName()) {
                    lp.addChildToBack(paramNode);
                    continue;
                }
                Preconditions.checkState((((IRFactory)IRFactory.this).config.isIdeMode || paramNode.isObjectLit() || paramNode.isArrayLit() ? 1 : 0) != 0);
            }
            node.addChildToBack(lp);
            com.google.javascript.rhino.Node bodyNode = IRFactory.this.transform(functionNode.getBody());
            if (!bodyNode.isBlock()) {
                Preconditions.checkState((boolean)((IRFactory)IRFactory.this).config.isIdeMode);
                bodyNode = IR.block();
            }
            this.parseDirectives(bodyNode);
            node.addChildToBack(bodyNode);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processIfStatement(IfStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(108);
            node.addChildToBack(IRFactory.this.transform(statementNode.getCondition()));
            node.addChildToBack(IRFactory.this.transformBlock(statementNode.getThenPart()));
            if (statementNode.getElsePart() != null) {
                node.addChildToBack(IRFactory.this.transformBlock(statementNode.getElsePart()));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processInfixExpression(InfixExpression exprNode) {
            com.google.javascript.rhino.Node n = IRFactory.this.newNode(IRFactory.transformTokenType(exprNode.getType()), IRFactory.this.transform(exprNode.getLeft()), IRFactory.this.transform(exprNode.getRight()));
            n.setLineno(exprNode.getLineno());
            n.setCharno(IRFactory.this.position2charno(exprNode.getAbsolutePosition()));
            IRFactory.this.maybeSetLengthFrom(n, exprNode);
            return n;
        }

        @Override
        com.google.javascript.rhino.Node processKeywordLiteral(KeywordLiteral literalNode) {
            return IRFactory.this.newNode(IRFactory.transformTokenType(literalNode.getType()));
        }

        @Override
        com.google.javascript.rhino.Node processLabel(Label labelNode) {
            return IRFactory.this.newStringNode(153, labelNode.getName());
        }

        @Override
        com.google.javascript.rhino.Node processLabeledStatement(LabeledStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(126);
            com.google.javascript.rhino.Node prev = null;
            com.google.javascript.rhino.Node cur = node;
            for (Label label : statementNode.getLabels()) {
                if (prev != null) {
                    prev.addChildToBack(cur);
                }
                cur.addChildToBack(IRFactory.this.transform(label));
                cur.setLineno(label.getLineno());
                IRFactory.this.maybeSetLengthFrom(cur, label);
                int clauseAbsolutePosition = IRFactory.this.position2charno(label.getAbsolutePosition());
                cur.setCharno(clauseAbsolutePosition);
                prev = cur;
                cur = IRFactory.this.newNode(126);
            }
            prev.addChildToBack(IRFactory.this.transform(statementNode.getStatement()));
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processName(Name nameNode) {
            return this.processName(nameNode, false);
        }

        com.google.javascript.rhino.Node processName(Name nameNode, boolean asString) {
            if (asString) {
                return IRFactory.this.newStringNode(40, nameNode.getIdentifier());
            }
            if (this.isReservedKeyword(nameNode.getIdentifier())) {
                IRFactory.this.errorReporter.error("identifier is a reserved word", IRFactory.this.sourceName, nameNode.getLineno(), "", 0);
            }
            return IRFactory.this.newStringNode(38, nameNode.getIdentifier());
        }

        private boolean isAllowedProp(String identifier) {
            if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                return !TokenStream.isKeyword(identifier);
            }
            return true;
        }

        private boolean isReservedKeyword(String identifier) {
            if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                return TokenStream.isKeyword(identifier);
            }
            return IRFactory.this.reservedKeywords != null && IRFactory.this.reservedKeywords.contains(identifier);
        }

        @Override
        com.google.javascript.rhino.Node processNewExpression(NewExpression exprNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(IRFactory.transformTokenType(exprNode.getType()), IRFactory.this.transform(exprNode.getTarget()));
            for (AstNode child : exprNode.getArguments()) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            node.setLineno(exprNode.getLineno());
            node.setCharno(IRFactory.this.position2charno(exprNode.getAbsolutePosition()));
            IRFactory.this.maybeSetLengthFrom(node, exprNode);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processNumberLiteral(NumberLiteral literalNode) {
            return IRFactory.this.newNumberNode(literalNode.getNumber());
        }

        @Override
        com.google.javascript.rhino.Node processObjectLiteral(ObjectLiteral literalNode) {
            if (literalNode.isDestructuring()) {
                this.reportDestructuringAssign(literalNode);
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(64);
            for (ObjectProperty el : literalNode.getElements()) {
                if (((IRFactory)IRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                    if (el.isGetter()) {
                        this.reportGetter(el);
                        continue;
                    }
                    if (el.isSetter()) {
                        this.reportSetter(el);
                        continue;
                    }
                }
                AstNode rawKey = el.getLeft();
                com.google.javascript.rhino.Node key = this.transformAsString(rawKey);
                key.setType(154);
                if (rawKey instanceof Name && !this.isAllowedProp(key.getString())) {
                    IRFactory.this.errorReporter.warning(IRFactory.INVALID_ES3_PROP_NAME, IRFactory.this.sourceName, key.getLineno(), "", key.getCharno());
                }
                com.google.javascript.rhino.Node value = IRFactory.this.transform(el.getRight());
                if (el.isGetter()) {
                    key.setType(147);
                    Preconditions.checkState((boolean)value.isFunction());
                    if (this.getFnParamNode(value).hasChildren()) {
                        this.reportGetterParam(el.getLeft());
                    }
                } else if (el.isSetter()) {
                    key.setType(148);
                    Preconditions.checkState((boolean)value.isFunction());
                    if (!this.getFnParamNode(value).hasOneChild()) {
                        this.reportSetterParam(el.getLeft());
                    }
                }
                key.addChildToFront(value);
                node.addChildToBack(key);
            }
            return node;
        }

        com.google.javascript.rhino.Node getFnParamNode(com.google.javascript.rhino.Node fnNode) {
            Preconditions.checkArgument((boolean)fnNode.isFunction());
            return fnNode.getFirstChild().getNext();
        }

        @Override
        com.google.javascript.rhino.Node processObjectProperty(ObjectProperty propertyNode) {
            return this.processInfixExpression(propertyNode);
        }

        @Override
        com.google.javascript.rhino.Node processParenthesizedExpression(ParenthesizedExpression exprNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.transform(exprNode.getExpression());
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processPropertyGet(PropertyGet getNode) {
            com.google.javascript.rhino.Node leftChild = IRFactory.this.transform(getNode.getTarget());
            Name nodeProp = getNode.getProperty();
            com.google.javascript.rhino.Node rightChild = this.transformAsString(nodeProp);
            if (nodeProp instanceof Name && !this.isAllowedProp(nodeProp.getIdentifier())) {
                IRFactory.this.errorReporter.warning(IRFactory.INVALID_ES3_PROP_NAME, IRFactory.this.sourceName, rightChild.getLineno(), "", rightChild.getCharno());
            }
            com.google.javascript.rhino.Node newNode = IRFactory.this.newNode(33, leftChild, rightChild);
            newNode.setLineno(leftChild.getLineno());
            newNode.setCharno(leftChild.getCharno());
            IRFactory.this.maybeSetLengthFrom(newNode, getNode);
            return newNode;
        }

        @Override
        com.google.javascript.rhino.Node processRegExpLiteral(RegExpLiteral literalNode) {
            com.google.javascript.rhino.Node literalStringNode = IRFactory.this.newStringNode(literalNode.getValue());
            literalStringNode.setLineno(literalNode.getLineno());
            IRFactory.this.maybeSetLengthFrom(literalStringNode, literalNode);
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(47, literalStringNode);
            String flags = literalNode.getFlags();
            if (flags != null && !flags.isEmpty()) {
                com.google.javascript.rhino.Node flagsNode = IRFactory.this.newStringNode(flags);
                flagsNode.setLineno(literalNode.getLineno());
                IRFactory.this.maybeSetLengthFrom(flagsNode, literalNode);
                node.addChildToBack(flagsNode);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processReturnStatement(ReturnStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(4);
            if (statementNode.getReturnValue() != null) {
                node.addChildToBack(IRFactory.this.transform(statementNode.getReturnValue()));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processScope(Scope scopeNode) {
            return this.processGeneric(scopeNode);
        }

        @Override
        com.google.javascript.rhino.Node processStringLiteral(StringLiteral literalNode) {
            String value = literalNode.getValue();
            com.google.javascript.rhino.Node n = IRFactory.this.newStringNode(value);
            if (value.indexOf(11) != -1) {
                int start = literalNode.getAbsolutePosition();
                int end = start + literalNode.getLength();
                if (start < IRFactory.this.sourceString.length() && IRFactory.this.sourceString.substring(start, Math.min(IRFactory.this.sourceString.length(), end)).indexOf("\\v") != -1) {
                    n.putBooleanProp(54, true);
                }
            }
            return n;
        }

        @Override
        com.google.javascript.rhino.Node processSwitchCase(SwitchCase caseNode) {
            com.google.javascript.rhino.Node node;
            if (caseNode.isDefault()) {
                node = IRFactory.this.newNode(112);
            } else {
                AstNode expr = caseNode.getExpression();
                node = IRFactory.this.newNode(111, IRFactory.this.transform(expr));
            }
            com.google.javascript.rhino.Node block = IRFactory.this.newNode(125);
            block.putBooleanProp(38, true);
            block.setLineno(caseNode.getLineno());
            block.setCharno(IRFactory.this.position2charno(caseNode.getAbsolutePosition()));
            IRFactory.this.maybeSetLengthFrom(block, caseNode);
            if (caseNode.getStatements() != null) {
                for (AstNode child : caseNode.getStatements()) {
                    block.addChildToBack(IRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processSwitchStatement(SwitchStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(110, IRFactory.this.transform(statementNode.getExpression()));
            for (SwitchCase child : statementNode.getCases()) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processThrowStatement(ThrowStatement statementNode) {
            return IRFactory.this.newNode(49, IRFactory.this.transform(statementNode.getExpression()));
        }

        @Override
        com.google.javascript.rhino.Node processTryStatement(TryStatement statementNode) {
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(77, IRFactory.this.transformBlock(statementNode.getTryBlock()));
            com.google.javascript.rhino.Node block = IRFactory.this.newNode(125);
            boolean lineSet = false;
            for (CatchClause cc : statementNode.getCatchClauses()) {
                if (!lineSet) {
                    block.setLineno(cc.getLineno());
                    IRFactory.this.maybeSetLengthFrom(block, cc);
                    lineSet = true;
                }
                block.addChildToBack(IRFactory.this.transform(cc));
            }
            node.addChildToBack(block);
            AstNode finallyBlock = statementNode.getFinallyBlock();
            if (finallyBlock != null) {
                node.addChildToBack(IRFactory.this.transformBlock(finallyBlock));
            }
            if (!lineSet && finallyBlock != null) {
                block.setLineno(finallyBlock.getLineno());
                IRFactory.this.maybeSetLengthFrom(block, finallyBlock);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processUnaryExpression(UnaryExpression exprNode) {
            String msg;
            int type = IRFactory.transformTokenType(exprNode.getType());
            com.google.javascript.rhino.Node operand = IRFactory.this.transform(exprNode.getOperand());
            if (type == 29 && operand.isNumber()) {
                operand.setDouble(-operand.getDouble());
                return operand;
            }
            if (!(type != 31 || operand.isGetProp() || operand.isGetElem() || operand.isName())) {
                msg = "Invalid delete operand. Only properties can be deleted.";
                IRFactory.this.errorReporter.error(msg, IRFactory.this.sourceName, operand.getLineno(), "", 0);
            } else if (!(type != 102 && type != 103 || this.validAssignmentTarget(operand))) {
                msg = type == 102 ? "invalid increment target" : "invalid decrement target";
                IRFactory.this.errorReporter.error(msg, IRFactory.this.sourceName, operand.getLineno(), "", 0);
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(type, operand);
            if (exprNode.isPostfix()) {
                node.putBooleanProp(32, true);
            }
            return node;
        }

        private boolean validAssignmentTarget(com.google.javascript.rhino.Node target) {
            switch (target.getType()) {
                case 33: 
                case 35: 
                case 38: 
                case 155: {
                    return true;
                }
            }
            return false;
        }

        @Override
        com.google.javascript.rhino.Node processVariableDeclaration(VariableDeclaration declarationNode) {
            if (!((IRFactory)IRFactory.this).config.acceptConstKeyword && declarationNode.getType() == 154) {
                this.processIllegalToken(declarationNode);
            }
            com.google.javascript.rhino.Node node = IRFactory.this.newNode(118);
            for (VariableInitializer child : declarationNode.getVariables()) {
                node.addChildToBack(IRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processVariableInitializer(VariableInitializer initializerNode) {
            Comment comment = initializerNode.getTarget().getJsDocNode();
            com.google.javascript.rhino.Node node = comment != null && !comment.getValue().contains("@") ? IRFactory.this.transformNodeWithInlineJsDoc(initializerNode.getTarget()) : IRFactory.this.transform(initializerNode.getTarget());
            if (initializerNode.getInitializer() != null) {
                com.google.javascript.rhino.Node initalizer = IRFactory.this.transform(initializerNode.getInitializer());
                node.addChildToBack(initalizer);
            }
            return node;
        }

        @Override
        com.google.javascript.rhino.Node processWhileLoop(WhileLoop loopNode) {
            return IRFactory.this.newNode(113, IRFactory.this.transform(loopNode.getCondition()), IRFactory.this.transformBlock(loopNode.getBody()));
        }

        @Override
        com.google.javascript.rhino.Node processWithStatement(WithStatement statementNode) {
            return IRFactory.this.newNode(119, IRFactory.this.transform(statementNode.getExpression()), IRFactory.this.transformBlock(statementNode.getStatement()));
        }

        @Override
        com.google.javascript.rhino.Node processIllegalToken(AstNode node) {
            IRFactory.this.errorReporter.error("Unsupported syntax: " + Token.typeToName(node.getType()), IRFactory.this.sourceName, node.getLineno(), "", 0);
            return IRFactory.this.newNode(124);
        }

        void reportDestructuringAssign(AstNode node) {
            IRFactory.this.errorReporter.error("destructuring assignment forbidden", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportGetter(AstNode node) {
            IRFactory.this.errorReporter.error(IRFactory.GETTER_ERROR_MESSAGE, IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportSetter(AstNode node) {
            IRFactory.this.errorReporter.error(IRFactory.SETTER_ERROR_MESSAGE, IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportGetterParam(AstNode node) {
            IRFactory.this.errorReporter.error("getters may not have parameters", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }

        void reportSetterParam(AstNode node) {
            IRFactory.this.errorReporter.error("setters must have exactly one parameter", IRFactory.this.sourceName, node.getLineno(), "", 0);
        }
    }
}

