/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import java.io.Serializable;
import java.util.Arrays;

public class TemplateTypeMap
implements Serializable {
    private final ImmutableList<TemplateType> templateKeys;
    private final ImmutableList<JSType> templateValues;
    private final ImmutableList<JSType> resolvedTemplateValues;
    final JSTypeRegistry registry;

    TemplateTypeMap(JSTypeRegistry registry, ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        Preconditions.checkNotNull(templateKeys);
        Preconditions.checkNotNull((Object)templateValues);
        this.registry = registry;
        this.templateKeys = templateKeys;
        int nKeys = templateKeys.size();
        this.templateValues = templateValues.size() > nKeys ? templateValues.subList(0, nKeys) : templateValues;
        TemplateTypeMapReplacer replacer = new TemplateTypeMapReplacer(registry, this);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSType templateValue : this.templateValues) {
            builder.add((Object)templateValue.visit(replacer));
        }
        this.resolvedTemplateValues = builder.build();
    }

    public boolean isEmpty() {
        return this.templateKeys.isEmpty();
    }

    public ImmutableList<TemplateType> getTemplateKeys() {
        return this.templateKeys;
    }

    public boolean hasTemplateKey(TemplateType templateKey) {
        for (TemplateType entry : this.templateKeys) {
            if (entry != templateKey) continue;
            return true;
        }
        return false;
    }

    int numUnfilledTemplateKeys() {
        return this.templateKeys.size() - this.templateValues.size();
    }

    ImmutableList<TemplateType> getUnfilledTemplateKeys() {
        return this.templateKeys.subList(this.templateValues.size(), this.templateKeys.size());
    }

    public boolean hasTemplateType(TemplateType key) {
        return this.getTemplateTypeIndex(key) != -1;
    }

    public JSType getTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (JSType)this.templateValues.get(index);
    }

    public TemplateType getTemplateTypeKeyByName(String keyName) {
        for (TemplateType key : this.templateKeys) {
            if (!key.getReferenceName().equals(keyName)) continue;
            return key;
        }
        return null;
    }

    private int getTemplateTypeIndex(TemplateType key) {
        int maxIndex = Math.min(this.templateKeys.size(), this.templateValues.size());
        for (int i = maxIndex - 1; i >= 0; --i) {
            if (this.templateKeys.get(i) != key) continue;
            return i;
        }
        return -1;
    }

    private JSType getResolvedTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (JSType)this.resolvedTemplateValues.get(index);
    }

    public boolean checkEquivalenceHelper(TemplateTypeMap that, EquivalenceMethod eqMethod) {
        int i;
        ImmutableList<TemplateType> thisKeys = this.getTemplateKeys();
        ImmutableList<TemplateType> thatKeys = that.getTemplateKeys();
        EquivalenceMatch[] thatMatches = new EquivalenceMatch[thatKeys.size()];
        Arrays.fill((Object[])thatMatches, (Object)EquivalenceMatch.NO_KEY_MATCH);
        for (i = 0; i < thisKeys.size(); ++i) {
            TemplateType thisKey = (TemplateType)thisKeys.get(i);
            JSType thisType = this.getResolvedTemplateType(thisKey);
            EquivalenceMatch thisMatch = EquivalenceMatch.NO_KEY_MATCH;
            for (int j = 0; j < thatKeys.size(); ++j) {
                TemplateType thatKey = (TemplateType)thatKeys.get(j);
                JSType thatType = that.getResolvedTemplateType(thatKey);
                if (thisKey != thatKey) continue;
                EquivalenceMatch newMatchType = EquivalenceMatch.VALUE_MISMATCH;
                if (thisType.checkEquivalenceHelper(thatType, eqMethod)) {
                    newMatchType = EquivalenceMatch.VALUE_MATCH;
                }
                if (thisMatch != EquivalenceMatch.VALUE_MATCH) {
                    thisMatch = newMatchType;
                }
                if (thatMatches[j] == EquivalenceMatch.VALUE_MATCH) continue;
                thatMatches[j] = newMatchType;
            }
            if (!this.failedEquivalenceCheck(thisMatch, eqMethod)) continue;
            return false;
        }
        for (i = 0; i < thatMatches.length; ++i) {
            if (!this.failedEquivalenceCheck(thatMatches[i], eqMethod)) continue;
            return false;
        }
        return true;
    }

    private boolean failedEquivalenceCheck(EquivalenceMatch eqMatch, EquivalenceMethod eqMethod) {
        return eqMatch == EquivalenceMatch.VALUE_MISMATCH || eqMatch == EquivalenceMatch.NO_KEY_MATCH && eqMethod != EquivalenceMethod.INVARIANT;
    }

    TemplateTypeMap extend(TemplateTypeMap thatMap) {
        thatMap = thatMap.addUnknownValues();
        return this.registry.createTemplateTypeMap(this.concatImmutableLists(thatMap.templateKeys, this.templateKeys), this.concatImmutableLists(thatMap.templateValues, this.templateValues));
    }

    TemplateTypeMap addValues(ImmutableList<JSType> newValues) {
        int numUnfilledKeys = this.numUnfilledTemplateKeys();
        if (numUnfilledKeys < newValues.size()) {
            newValues = newValues.subList(0, numUnfilledKeys);
        }
        return this.registry.createTemplateTypeMap(this.templateKeys, this.concatImmutableLists(this.templateValues, newValues));
    }

    private TemplateTypeMap addUnknownValues() {
        int numUnfilledTemplateKeys = this.numUnfilledTemplateKeys();
        if (numUnfilledTemplateKeys == 0) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < numUnfilledTemplateKeys; ++i) {
            builder.add((Object)this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }
        return this.addValues((ImmutableList<JSType>)builder.build());
    }

    private <T> ImmutableList<T> concatImmutableLists(ImmutableList<T> first, ImmutableList<T> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(first);
        builder.addAll(second);
        return builder.build();
    }

    boolean hasAnyTemplateTypesInternal() {
        for (JSType templateValue : this.templateValues) {
            if (!templateValue.hasAnyTemplateTypes()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "";
        int len = Math.max(Math.max(this.templateKeys.size(), this.templateValues.size()), this.resolvedTemplateValues.size());
        s = s + "{ ";
        for (int i = 0; i < len; ++i) {
            s = s + "(";
            s = s + (i < this.templateKeys.size() ? (Serializable)this.templateKeys.get(i) : "");
            s = s + ",";
            s = s + (i < this.templateValues.size() ? (Serializable)this.templateValues.get(i) : "");
            s = s + ",";
            s = s + (i < this.resolvedTemplateValues.size() ? (Serializable)this.resolvedTemplateValues.get(i) : "");
            s = s + ") ";
        }
        s = s + "}";
        return s;
    }

    private static enum EquivalenceMatch {
        NO_KEY_MATCH,
        VALUE_MISMATCH,
        VALUE_MATCH;

    }
}

