/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.xwiki.chart.ChartGenerator;
import org.xwiki.chart.ChartGeneratorException;
import org.xwiki.chart.internal.DrawingSupplierFactory;
import org.xwiki.chart.internal.plot.PlotGenerator;
import org.xwiki.chart.model.ChartModel;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

@Component
@Singleton
public class DefaultChartGenerator
implements ChartGenerator {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManager;

    @Override
    public byte[] generate(ChartModel model, Map<String, String> parameters) throws ChartGeneratorException {
        PlotGenerator generator;
        this.setDefaultParams(parameters);
        String type = parameters.get("type");
        String title = parameters.get("title");
        try {
            generator = (PlotGenerator)((ComponentManager)this.contextComponentManager.get()).getInstance(PlotGenerator.class, type);
        }
        catch (ComponentLookupException e) {
            throw new ChartGeneratorException(String.format("No such chart type : [%s].", type), e);
        }
        Plot plot = generator.generate(model, parameters);
        DrawingSupplierFactory drawingSupplierFactory = new DrawingSupplierFactory();
        plot.setDrawingSupplier(drawingSupplierFactory.createDrawingSupplier(parameters));
        JFreeChart jfchart = new JFreeChart(title, plot);
        int width = Integer.parseInt(parameters.get("width"));
        int height = Integer.parseInt(parameters.get("height"));
        try {
            return ChartUtilities.encodeAsPNG((BufferedImage)jfchart.createBufferedImage(width, height));
        }
        catch (IOException ex) {
            throw new ChartGeneratorException("Error while png encoding the chart image.");
        }
    }

    public void setDefaultParams(Map<String, String> parameters) {
        DefaultChartGenerator.setParam("series", "rows", parameters);
        DefaultChartGenerator.setParam("width", "400", parameters);
        DefaultChartGenerator.setParam("height", "300", parameters);
    }

    private static void setParam(String key, String value, Map<String, String> map) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

