/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.util.ResourceLoader;

public class PropertiesModule
extends AbstractModule {
    private static final String DEFAULT_PROPERTIES = "shindig.properties";
    private final Properties properties;

    public PropertiesModule() {
        this.properties = this.readPropertyFile(PropertiesModule.getDefaultPropertiesPath());
    }

    public PropertiesModule(String propertyFile) {
        this.properties = this.readPropertyFile(propertyFile);
    }

    public PropertiesModule(Properties properties) {
        this.properties = properties;
    }

    protected void configure() {
        this.binder().bindConstant().annotatedWith((Annotation)Names.named((String)"shindig.contextroot")).to(this.getContextRoot());
        Names.bindProperties((Binder)this.binder(), (Properties)this.getProperties());
        this.binder().bindConstant().annotatedWith((Annotation)Names.named((String)"shindig.port")).to(this.getServerPort());
        this.binder().bindConstant().annotatedWith((Annotation)Names.named((String)"shindig.host")).to(this.getServerHostname());
    }

    protected String getContextRoot() {
        return System.getProperty("shindig.contextroot") != null ? System.getProperty("shindig.contextroot") : "";
    }

    protected String getServerPort() {
        return System.getProperty("shindig.port") != null ? System.getProperty("shindig.port") : "";
    }

    protected String getServerHostname() {
        return System.getProperty("shindig.host") != null ? System.getProperty("shindig.host") : "";
    }

    protected static String getDefaultPropertiesPath() {
        return DEFAULT_PROPERTIES;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected Properties readPropertyFile(String propertyFile) {
        Properties properties = new Properties();
        InputStream is = null;
        String contextRoot = this.getContextRoot();
        try {
            is = ResourceLoader.openResource(propertyFile);
            properties.load(is);
            for (Object key : properties.keySet()) {
                String value = (String)properties.get((String)key);
                if (value == null || !value.contains("%contextRoot%")) continue;
                properties.put(key, value.replace("%contextRoot%", contextRoot));
            }
        }
        catch (IOException e) {
            throw new CreationException(Arrays.asList(new Message("Unable to load properties: " + propertyFile)));
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return properties;
    }
}

