/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shindig.common.util.DigestType;

public class GenericDigestUtils
extends DigestUtils {
    private static final String CLASSNAME = GenericDigestUtils.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASSNAME, "org.apache.shindig.common.logging.i18n.resource");
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private static String type = DigestType.SHA.getName();

    private static byte[] digest(MessageDigest digest, InputStream data) throws IOException {
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return digest.digest();
    }

    private static byte[] getBytesUtf8(String data) {
        return StringUtils.getBytesUtf8((String)data);
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] digest(byte[] data) {
        return GenericDigestUtils.getDigest(type).digest(data);
    }

    public static byte[] digest(InputStream data) throws IOException {
        return GenericDigestUtils.digest(GenericDigestUtils.getDigest(type), data);
    }

    public static String digestHex(String data) {
        return Hex.encodeHexString((byte[])GenericDigestUtils.digest(GenericDigestUtils.getBytesUtf8(data)));
    }

    public static String digestHex(byte[] data) {
        return Hex.encodeHexString((byte[])GenericDigestUtils.getDigest(type).digest(data));
    }

    public static String digestHex(InputStream data) throws IOException {
        return Hex.encodeHexString((byte[])GenericDigestUtils.digest(GenericDigestUtils.getDigest(type), data));
    }

    public static byte[] digest(String data) {
        return GenericDigestUtils.digest(GenericDigestUtils.getBytesUtf8(data));
    }

    @Inject(optional=true)
    public static void setType(@Named(value="shindig.crypto.preferredHashAlgorithm") String type) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "shindig.crypto.preferredHashAlgorithm: " + type);
        }
        if (type != null) {
            GenericDigestUtils.type = type;
        }
    }
}

