/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xwiki.xwiki20.javacc;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import org.xwiki.rendering.wikimodel.IWikiReferenceParser;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.impl.IWikiScannerContext;
import org.xwiki.rendering.wikimodel.impl.WikiScannerUtil;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiReferenceParser;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiScannerUtil;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.XWikiWikiParameters;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.javacc.ParseException;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.javacc.SimpleCharStream;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.javacc.Token;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.javacc.XWikiScannerConstants;
import org.xwiki.rendering.wikimodel.xwiki.xwiki20.javacc.XWikiScannerTokenManager;

public class XWikiScanner
implements XWikiScannerConstants {
    private IWikiScannerContext fContext;
    private IWikiReferenceParser fReferenceParser = new XWikiReferenceParser();
    private WikiParameters wikiParameters = WikiParameters.EMPTY;
    private int emptyLinesCount = 0;
    public XWikiScannerTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;

    public void parse(IWikiScannerContext context) throws ParseException {
        this.fContext = context;
        this.doParse();
    }

    protected WikiParameters newWikiParameters(String str) {
        str = WikiScannerUtil.extractSubstring(str, "(%", "%)", '~', false);
        return new XWikiWikiParameters(str);
    }

    protected void setWikiParameters(String str) {
        this.wikiParameters = this.newWikiParameters(str);
    }

    protected WikiParameters consumeWikiParameters() {
        WikiParameters params = this.wikiParameters;
        this.wikiParameters = WikiParameters.EMPTY;
        return params;
    }

    protected void consumeRemainingParameters() {
        if (this.wikiParameters != WikiParameters.EMPTY) {
            this.fContext.beginParagraph(this.wikiParameters);
            this.fContext.endParagraph();
            this.wikiParameters = WikiParameters.EMPTY;
        }
    }

    private void endBlock() {
        this.emptyLinesCount = 0;
    }

    private void startBlock() {
        if (this.emptyLinesCount > 1) {
            this.fContext.onEmptyLines(this.emptyLinesCount - 1);
        }
        this.emptyLinesCount = 0;
    }

    private void endDocument() {
        this.consumeRemainingParameters();
        if (this.emptyLinesCount > 1) {
            this.fContext.onEmptyLines(this.emptyLinesCount);
        }
    }

    private void processMacro(String start, String content, boolean inline) {
        Matcher nameMatcher = XWikiScannerTokenManager.MACRO_NAME_PATTERN.matcher(start);
        if (!nameMatcher.find()) {
            throw new RuntimeException(String.format("Macro name pattern did not match [%s].", start));
        }
        String name = nameMatcher.group(1);
        int beginIndex = nameMatcher.end();
        int endIndex = start.length() - "}}".length();
        if (start.charAt(endIndex - 1) == '/') {
            --endIndex;
        }
        String paramStr = beginIndex < endIndex ? start.substring(beginIndex, endIndex) : "";
        XWikiWikiParameters params = new XWikiWikiParameters(paramStr);
        if (inline) {
            this.fContext.onMacro(name, params, content, inline);
        } else {
            WikiParameters wikiParams = this.consumeWikiParameters();
            if (wikiParams != WikiParameters.EMPTY) {
                this.fContext.beginParagraph(wikiParams);
                this.fContext.onMacro(name, params, content, true);
            } else {
                this.fContext.onMacro(name, params, content);
            }
        }
    }

    protected String normalizeMacroContent(StringBuilder content) {
        if (content == null) {
            return null;
        }
        if (content.length() == 0) {
            return "";
        }
        int startIndex = 0;
        if (content.charAt(0) == '\n') {
            ++startIndex;
        } else if (content.length() >= 2 && content.charAt(0) == '\r') {
            ++startIndex;
            if (content.charAt(1) == '\n') {
                ++startIndex;
            }
        }
        int endIndex = content.length();
        if (content.length() - startIndex >= 1) {
            if (content.charAt(content.length() - 1) == '\n') {
                --endIndex;
                if (content.length() - startIndex >= 2 && content.charAt(content.length() - 2) == '\r') {
                    --endIndex;
                }
            } else if (content.charAt(content.length() - 1) == '\r') {
                --endIndex;
            }
        }
        return content.substring(startIndex, endIndex);
    }

    public final void doParse() throws ParseException {
        this.fContext.beginDocument();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 93: {
                this.emptyLine();
                --this.emptyLinesCount;
                break;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 88: 
                case 89: 
                case 90: 
                case 93: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            this.docElements();
        }
        this.jj_consume_token(0);
        this.endDocument();
        this.fContext.endDocument();
    }

    public final void inlineParameters() throws ParseException {
        this.jj_consume_token(69);
        this.fContext.onFormat(this.newWikiParameters(this.token.image));
    }

    public final void blockParameters() throws ParseException {
        this.jj_consume_token(6);
        this.setWikiParameters(this.token.image);
    }

    public final void docElements() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: {
                this.blockStart();
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.header();
                        break;
                    }
                    case 6: {
                        this.blockParameters();
                        break;
                    }
                    case 3: {
                        this.list();
                        break;
                    }
                    case 8: {
                        this.quot();
                        break;
                    }
                    case 4: {
                        this.horline();
                        break;
                    }
                    case 5: {
                        this.table();
                        break;
                    }
                    case 73: 
                    case 74: {
                        this.macro(false);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 88: {
                                this.jj_consume_token(88);
                                break block4;
                            }
                        }
                        break;
                    }
                    case 72: {
                        this.verbatimBlock(false);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 88: {
                                this.jj_consume_token(88);
                                break block4;
                            }
                        }
                        break;
                    }
                    case 68: 
                    case 70: {
                        this.embeddedDocument();
                        break;
                    }
                    case 69: 
                    case 71: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 89: 
                    case 90: {
                        this.paragraph();
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.blockEnd();
                break;
            }
            case 88: 
            case 93: {
                this.emptyLine();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void header() throws ParseException {
        this.jj_consume_token(2);
        int level = this.token.image.trim().length();
        this.fContext.beginHeader(level, this.consumeWikiParameters());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.newLine();
                break;
            }
        }
        this.block();
        this.fContext.endHeader();
    }

    public final void macro(boolean inline) throws ParseException {
        Token start = null;
        StringBuilder content = new StringBuilder();
        boolean empty = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                start = this.jj_consume_token(73);
                empty = true;
                break;
            }
            case 74: {
                start = this.jj_consume_token(74);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 20: {
                            break;
                        }
                        default: {
                            break block10;
                        }
                    }
                    this.jj_consume_token(20);
                    content.append(this.token.image);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String c = null;
        if (!empty) {
            c = this.normalizeMacroContent(content);
        }
        this.processMacro(start.image, c, inline);
        this.linesMaybeEmpty();
        this.fContext.endParagraph();
    }

    public final void list() throws ParseException {
        String str = "";
        this.fContext.beginList(this.consumeWikiParameters());
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: {
                    this.listItem();
                    break;
                }
                case 6: {
                    this.blockParameters();
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 3: 
                case 6: {
                    continue block10;
                }
            }
            break;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 93: {
                this.jj_consume_token(93);
                ++this.emptyLinesCount;
                break;
            }
        }
        this.fContext.endList();
    }

    public final void listItem() throws ParseException {
        block14: {
            WikiParameters params = this.consumeWikiParameters();
            this.jj_consume_token(3);
            String str = this.token.image.trim();
            str = str.replace(".", "");
            str = str.replace('1', '#');
            this.fContext.beginListItem(str, params);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: {
                    this.newLine();
                    break;
                }
            }
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 89: 
                    case 90: {
                        break;
                    }
                    default: {
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: 
                    case 70: {
                        this.embeddedDocument();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 88: {
                                this.jj_consume_token(88);
                                continue block13;
                            }
                        }
                        continue block13;
                    }
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 89: 
                    case 90: {
                        this.lines();
                        continue block13;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.fContext.endListItem();
    }

    public final void table() throws ParseException {
        String str = "";
        this.fContext.beginTable(this.consumeWikiParameters());
        block6: while (true) {
            this.tableRow();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    continue block6;
                }
            }
            break;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                this.tableEnd();
                break;
            }
        }
        this.fContext.endTable();
    }

    public final void tableRow() throws ParseException {
        WikiParameters rowParams = WikiParameters.EMPTY;
        WikiParameters cellParams = WikiParameters.EMPTY;
        this.jj_consume_token(5);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                rowParams = this.newWikiParameters(this.token.image);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 86: {
                            break;
                        }
                        default: {
                            break block0;
                        }
                    }
                    this.jj_consume_token(86);
                }
            }
        }
        this.tableFirstCell(rowParams);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    break block10;
                }
            }
            this.tableCell();
        }
        this.fContext.endTableRow();
    }

    public final void tableCell() throws ParseException {
        boolean head = false;
        WikiParameters cellParams = WikiParameters.EMPTY;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                head = true;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: 
            case 69: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    case 68: {
                        this.jj_consume_token(68);
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                cellParams = this.newWikiParameters(this.token.image);
                break;
            }
        }
        this.fContext.onTableCell(head, cellParams);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.newLine();
                break;
            }
        }
        this.block();
    }

    public final void tableFirstCell(WikiParameters rowParams) throws ParseException {
        boolean head = false;
        WikiParameters cellParams = WikiParameters.EMPTY;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                head = true;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: 
            case 69: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    case 68: {
                        this.jj_consume_token(68);
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                cellParams = this.newWikiParameters(this.token.image);
                break;
            }
        }
        this.fContext.beginTableRow(head, rowParams, cellParams);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.newLine();
                break;
            }
        }
        this.block();
    }

    public final void verbatimBlock(boolean inline) throws ParseException {
        StringBuilder buf = new StringBuilder();
        this.jj_consume_token(72);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            this.jj_consume_token(17);
            buf.append(this.token.image);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                break;
            }
        }
        String content = XWikiScannerUtil.unescapeVerbatim(buf.toString());
        if (inline) {
            this.fContext.onVerbatim(content, inline, this.consumeWikiParameters());
        } else {
            this.fContext.onVerbatim(content, this.consumeWikiParameters());
        }
        this.linesMaybeEmpty();
        this.fContext.endParagraph();
    }

    public final void horline() throws ParseException {
        this.jj_consume_token(4);
        this.fContext.onHorizontalLine(this.consumeWikiParameters());
    }

    public final void quot() throws ParseException {
        this.fContext.beginQuot(this.consumeWikiParameters());
        block3: while (true) {
            this.quotLine();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    continue block3;
                }
            }
            break;
        }
        this.fContext.endQuot();
    }

    public final void quotLine() throws ParseException {
        this.jj_consume_token(8);
        String str = this.token.image.trim();
        int depth = str.length();
        this.fContext.beginQuotLine(depth);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: {
                this.line();
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
        }
        this.fContext.endQuotLine();
    }

    public final void headerEnd() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                ++this.emptyLinesCount;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void tableEnd() throws ParseException {
        this.jj_consume_token(91);
        ++this.emptyLinesCount;
    }

    public final void blockStart() throws ParseException {
        this.startBlock();
    }

    public final void block() throws ParseException {
        block16: {
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 90: {
                        break;
                    }
                    default: {
                        break block16;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 68: 
                    case 70: {
                        this.embeddedDocument();
                        continue block15;
                    }
                    case 69: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 89: 
                    case 90: {
                        this.lines();
                        continue block15;
                    }
                    case 88: {
                        this.jj_consume_token(88);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 92: 
            case 93: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 93: {
                        this.jj_consume_token(93);
                        ++this.emptyLinesCount;
                        break block8;
                    }
                    case 12: 
                    case 92: {
                        this.headerEnd();
                        break block8;
                    }
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void blockEnd() throws ParseException {
        this.endBlock();
    }

    public final void paragraph() throws ParseException {
        this.fContext.beginParagraph(this.consumeWikiParameters());
        this.lines();
        this.fContext.endParagraph();
    }

    public final void lines() throws ParseException {
        this.line();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 89: 
                case 90: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            this.fContext.onNewLine();
            this.line();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: {
                    this.jj_consume_token(88);
                    continue block9;
                }
            }
        }
    }

    public final void linesMaybeEmpty() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 90: {
                this.line();
                break;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 89: 
                case 90: {
                    break;
                }
                default: {
                    break block12;
                }
            }
            this.fContext.onNewLine();
            this.line();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: {
                    this.jj_consume_token(88);
                    continue block12;
                }
            }
        }
    }

    public final void emptyLine() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                this.endBlock();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ++this.emptyLinesCount;
        WikiParameters params = this.consumeWikiParameters();
        if (!params.equals(WikiParameters.EMPTY)) {
            this.fContext.beginParagraph(params);
            this.fContext.endParagraph();
        }
    }

    public final void newLine() throws ParseException {
        this.jj_consume_token(88);
        this.fContext.onNewLine();
    }

    public final void newLineSkip() throws ParseException {
        this.jj_consume_token(88);
    }

    public final void line() throws ParseException {
        block3: while (true) {
            this.inline();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 69: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 89: 
                case 90: {
                    continue block3;
                }
            }
            break;
        }
    }

    public final void inline() throws ParseException {
        String str = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 89: {
                this.jj_consume_token(89);
                this.fContext.onWord(this.token.image.replaceAll("~", ""));
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                this.fContext.onSpace(this.token.image.replaceAll("~", ""));
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                if (this.token.image.length() == 2) {
                    this.fContext.onSpecialSymbol("" + this.token.image.charAt(1));
                    break;
                }
                if (this.token.image.charAt(0) == '~') break;
                this.fContext.onSpecialSymbol(this.token.image);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                this.fContext.onFormat(IWikiScannerContext.STRONG);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                this.fContext.onFormat(IWikiScannerContext.EM);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                this.fContext.onFormat(IWikiScannerContext.STRIKE);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                this.fContext.onFormat(IWikiScannerContext.INS);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                this.fContext.onFormat(IWikiScannerContext.SUP);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                this.fContext.onFormat(IWikiScannerContext.SUB);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                this.fContext.onFormat(IWikiScannerContext.MONO);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                this.fContext.onLineBreak();
                break;
            }
            case 73: 
            case 74: {
                this.macro(true);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                this.fContext.onReference(this.token.image);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                this.fContext.onImage(this.token.image.substring("image:".length()));
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                this.fContext.onReference(this.token.image);
                break;
            }
            case 69: {
                this.inlineParameters();
                break;
            }
            case 71: {
                WikiReference ref;
                this.jj_consume_token(71);
                str = this.token.image;
                if (str.startsWith("[[")) {
                    str = str.substring(2, str.length() - 2);
                }
                if ((ref = this.fReferenceParser.parse(str)).getLink().startsWith("image:")) {
                    this.fContext.onImage(new WikiReference(ref.getLink().substring("image:".length()), ref.getLabel(), ref.getParameters()));
                    break;
                }
                this.fContext.onReference(ref);
                break;
            }
            case 72: {
                this.verbatimBlock(true);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void embeddedDocument() throws ParseException {
        WikiParameters params = WikiParameters.EMPTY;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                params = this.newWikiParameters(this.token.image);
                break;
            }
        }
        this.jj_consume_token(70);
        this.fContext.beginDocument(params);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: 
            case 93: {
                this.emptyLine();
                --this.emptyLinesCount;
                break;
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 88: 
                case 89: 
                case 90: 
                case 93: {
                    break;
                }
                default: {
                    break block13;
                }
            }
            this.docElements();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.endDocument();
        this.fContext.endDocument();
    }

    public XWikiScanner(InputStream stream) {
        this(stream, null);
    }

    public XWikiScanner(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new XWikiScannerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public XWikiScanner(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new XWikiScannerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public XWikiScanner(XWikiScannerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(XWikiScannerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

