/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.spi.gadget.Gadget;
import org.exoplatform.portal.webui.application.UIStandaloneGadget;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.login.LoginServlet;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/application/UIStandaloneAppContainer.gtmpl", events={@EventConfig(listeners={LogoutActionListener.class}, csrfCheck=false)})
public class UIStandaloneAppContainer
extends UIContainer {
    private boolean lossData;
    private UIStandaloneGadget currApp;

    public String getCurrStorageId() {
        if (this.currApp != null) {
            return this.currApp.getStorageId();
        }
        return null;
    }

    public String getCurrAppName() {
        if (this.currApp != null) {
            return this.currApp.getApplicationName();
        }
        return null;
    }

    public void setCurrStorageId(String storageId) throws Exception {
        String[] siteInfo;
        this.lossData = false;
        this.currApp = this.getChildByStorageId(storageId);
        if (this.currApp != null) {
            return;
        }
        DataStorage ds = (DataStorage)this.getApplicationComponent(DataStorage.class);
        try {
            siteInfo = ds.getSiteInfo(storageId);
        }
        catch (Exception ex) {
            this.lossData = true;
            return;
        }
        String siteType = null;
        String siteOwner = null;
        if (siteInfo != null) {
            siteType = siteInfo[0];
            siteOwner = siteInfo[1];
        }
        ConversationState currentState = ConversationState.getCurrent();
        if (PortalConfig.USER_TYPE.equals(siteType) && currentState.getIdentity().getUserId().equals(siteOwner)) {
            Application gadgetModel = ds.getApplicationModel(storageId);
            UIStandaloneGadget staGadget = (UIStandaloneGadget)this.createUIComponent(UIStandaloneGadget.class, null, null);
            staGadget.setStorageId(storageId);
            PortalDataMapper.toUIGadget(staGadget, (Application<Gadget>)gadgetModel);
            this.addChild(staGadget);
            this.currApp = staGadget;
        }
    }

    private UIStandaloneGadget getChildByStorageId(String storageId) {
        for (UIComponent child : this.getChildren()) {
            UIStandaloneGadget gadget;
            if (!(child instanceof UIStandaloneGadget) || !(gadget = (UIStandaloneGadget)child).getStorageId().equals(storageId)) continue;
            return gadget;
        }
        return null;
    }

    public boolean isLossData() {
        return this.lossData;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (!this.lossData && this.currApp != null && this.currApp.isLossData()) {
            this.removeChildById(this.currApp.getId());
            this.currApp = null;
            this.lossData = true;
        }
        super.processRender(context);
    }

    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            AbstractTokenService tokenService;
            StandaloneAppRequestContext context = (StandaloneAppRequestContext)event.getRequestContext();
            HttpServletRequest req = context.getRequest();
            String token = this.getTokenCookie(req);
            if (token != null) {
                tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            if ((token = LoginServlet.getOauthRememberMeTokenCookie((HttpServletRequest)req)) != null) {
                tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            LogoutControl.wantLogout();
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(0);
            context.getResponse().addCookie(cookie);
            Cookie oauthCookie = new Cookie("oauth_rememberme", "");
            oauthCookie.setPath(req.getContextPath());
            oauthCookie.setMaxAge(0);
            context.getResponse().addCookie(oauthCookie);
            context.sendRedirect(req.getRequestURI());
        }

        private String getTokenCookie(HttpServletRequest req) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"rememberme".equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

