/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentAutoVersionForm;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotNtFileFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsPasteableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeNodePageIterator;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={PasteActionListener.class})})
public class PasteManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsPasteableFilter(), new IsNotNtFileFilter(), new IsNotTrashHomeNodeFilter()});
    private static final String RELATION_PROP = "exo:relation";
    private static final Log LOG = ExoLogger.getLogger((String)PasteManageComponent.class.getName());
    private static boolean isRefresh = true;
    private static Map<String, Boolean> versionedRemember;
    private static Map<String, Boolean> nonVersionedRemember;

    public static boolean isIsRefresh() {
        return isRefresh;
    }

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void pasteManage(Event<PasteManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        Node destNode;
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((PasteManageComponent)((Object)event.getSource())).getParent();
        String destPath = event.getRequestContext().getRequestParameter("objectId");
        String nodePath = null;
        Session session = null;
        if (destPath != null) {
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath);
            String wsName = null;
            if (matcher.find()) {
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                session = uiExplorer.getSessionByWorkspace(wsName);
            } else {
                throw new IllegalArgumentException("The ObjectId is invalid '" + destPath + "'");
            }
        }
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        if (clipboardService.getClipboardList(userId, false).size() < 1) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.no-node", null, 1));
            return;
        }
        try {
            destNode = destPath == null ? uiExplorer.getCurrentNode() : uiExplorer.getNodeByPath(nodePath, session);
            session = destNode.getSession();
            if (destPath == null) {
                destPath = session.getWorkspace().getName() + ":" + destNode.getPath();
            }
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        if (!PermissionUtil.canAddNode((Node)destNode)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-paste-node", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        if (uiExplorer.nodeIsLocked(destNode)) {
            Object[] arg = new Object[]{destPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            return;
        }
        if (!destNode.isCheckedOut()) {
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null));
            return;
        }
        String currentPath = uiExplorer.getCurrentNode().getPath();
        ClipboardCommand clipboardCommand = clipboardService.getLastClipboard(userId);
        try {
            if (clipboardCommand != null && clipboardService.getClipboardList(userId, true).isEmpty()) {
                PasteManageComponent.processPaste(clipboardCommand, destNode, event, uiExplorer);
            } else if (autoVersionService.isVersionSupport(destNode.getPath(), destNode.getSession().getWorkspace().getName())) {
                PasteManageComponent.processPasteMultiple(destNode, event, uiExplorer);
            } else {
                PasteManageComponent.processPasteMultiple(destPath, event, uiExplorer);
            }
        }
        catch (PathNotFoundException pe) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-readsource", null));
            return;
        }
        UITreeNodePageIterator extendedPageIterator = null;
        UITreeExplorer uiTreeExplorer = (UITreeExplorer)uiExplorer.findFirstComponentOfType(UITreeExplorer.class);
        if (uiTreeExplorer != null) {
            extendedPageIterator = uiTreeExplorer.getUIPageIterator(currentPath);
        }
        UIPageIterator contentPageIterator = (UIPageIterator)uiExplorer.findComponentById("ContentPageIterator");
        int currentPage = 1;
        if (contentPageIterator != null) {
            currentPage = contentPageIterator.getCurrentPage();
        }
        if (isRefresh) {
            versionedRemember = null;
            nonVersionedRemember = null;
            uiExplorer.updateAjax(event);
        }
        if (contentPageIterator != null) {
            contentPageIterator.setCurrentPage(currentPage);
        }
        if (extendedPageIterator != null) {
            extendedPageIterator.setCurrentPage(currentPage);
        }
    }

    public static void processPaste(ClipboardCommand clipboardCommand, Node destNode, Event<?> event, UIJCRExplorer uiExplorer) throws Exception {
        AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
        Node sourceNode = (Node)uiExplorer.getSessionByWorkspace(clipboardCommand.getWorkspace()).getItem(clipboardCommand.getSrcPath());
        if (destNode.hasNode(sourceNode.getName()) && sourceNode.isNodeType("nt:file") && autoVersionService.isVersionSupport(destNode.getPath(), destNode.getSession().getWorkspace().getName())) {
            HashSet<ClipboardCommand> clipboardCommands = new HashSet<ClipboardCommand>();
            clipboardCommands.add(clipboardCommand);
            PasteManageComponent.showConfirmDialog(destNode, sourceNode, uiExplorer, clipboardCommand, clipboardCommands, event);
        } else {
            PasteManageComponent.processPaste(clipboardCommand, destNode.getPath(), uiExplorer, event, false, true);
        }
    }

    private static void processPasteMultiple(String destPath, Event<?> event, UIJCRExplorer uiExplorer) throws Exception {
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        int pasteNum = 0;
        Set virtualClipboards = clipboardService.getClipboardList(userId, true);
        for (ClipboardCommand clipboard : virtualClipboards) {
            if (++pasteNum == virtualClipboards.size()) {
                PasteManageComponent.processPaste(clipboard, destPath, uiExplorer, event, true, true);
                break;
            }
            PasteManageComponent.processPaste(clipboard, destPath, uiExplorer, event, true, false);
        }
    }

    private static void processPasteMultiple(Node destNode, Event<?> event, UIJCRExplorer uiExplorer) throws Exception {
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        Set virtualClipboards = clipboardService.getClipboardList(userId, true);
        PasteManageComponent.processPasteMultiple(destNode, event, uiExplorer, virtualClipboards, null);
    }

    public static void processPasteMultiple(Node destNode, Event<?> event, UIJCRExplorer uiExplorer, Set<ClipboardCommand> virtualClipboards, String action) throws Exception {
        int pasteNum = 0;
        HashSet<ClipboardCommand> _virtualClipboards = new HashSet<ClipboardCommand>(virtualClipboards);
        HashSet<ClipboardCommand> processList = new HashSet<ClipboardCommand>(virtualClipboards);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        ActionServiceContainer actionContainer = (ActionServiceContainer)uiExplorer.getApplicationComponent(ActionServiceContainer.class);
        for (ClipboardCommand clipboard : virtualClipboards) {
            ++pasteNum;
            Node srcNode = null;
            try {
                srcNode = (Node)uiExplorer.getSessionByWorkspace(clipboard.getWorkspace()).getItem(clipboard.getSrcPath());
                String destPath = destNode.getPath();
                if (destNode.hasNode(srcNode.getName())) {
                    Node _destNode = destNode.getNode(srcNode.getName());
                    if (_destNode.isNodeType("mix:versionable") && versionedRemember != null) {
                        if (BooleanUtils.isTrue((Boolean)versionedRemember.get("keepboth"))) {
                            if ("copy".equals(clipboard.getType())) {
                                PasteManageComponent.pasteByCopy(destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), _destNode.getPath());
                            } else {
                                PasteManageComponent.pasteByCut(clipboard, uiExplorer, _destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), _destNode.getPath(), actionContainer, false, false, false);
                            }
                        }
                        if (BooleanUtils.isTrue((Boolean)versionedRemember.get("createVersion"))) {
                            PasteManageComponent.makeVersion(destNode, _destNode, srcNode, clipboard, action, destPath, uiExplorer, event);
                        }
                        processList.remove(clipboard);
                        continue;
                    }
                    if (!_destNode.isNodeType("mix:versionable") && nonVersionedRemember != null) {
                        String _destPath;
                        if (BooleanUtils.isTrue((Boolean)nonVersionedRemember.get("replace")) && !StringUtils.equals((String)(_destPath = _destNode.getPath()), (String)clipboard.getSrcPath()) && StringUtils.equals((String)clipboard.getWorkspace(), (String)_destNode.getSession().getWorkspace().getName())) {
                            TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
                            String trashID = trashService.moveToTrash(_destNode, WCMCoreUtils.getUserSessionProvider());
                            if (StringUtils.equals((String)"cut", (String)clipboard.getType())) {
                                PasteManageComponent.pasteByCut(clipboard, uiExplorer, _destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), _destPath, actionContainer, false, false, false);
                            } else {
                                UIDocumentAutoVersionForm.copyNode(destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), _destPath, uiApp, uiExplorer, event, "copy");
                            }
                            Node deletedNode = trashService.getNodeByTrashId(trashID);
                            deletedNode.remove();
                            deletedNode.getSession().save();
                        }
                        if (BooleanUtils.isTrue((Boolean)nonVersionedRemember.get("keepboth"))) {
                            if ("copy".equals(clipboard.getType())) {
                                PasteManageComponent.pasteByCopy(destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), _destNode.getPath());
                            } else {
                                PasteManageComponent.pasteByCut(clipboard, uiExplorer, _destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), _destNode.getPath(), actionContainer, false, false, false);
                            }
                        }
                        processList.remove(clipboard);
                        continue;
                    }
                    PasteManageComponent.showConfirmDialog(destNode, srcNode, uiExplorer, clipboard, _virtualClipboards, event);
                    break;
                }
                _virtualClipboards.remove(clipboard);
                if (pasteNum == virtualClipboards.size()) {
                    PasteManageComponent.processPaste(clipboard, destPath, uiExplorer, event, true, true);
                    processList.remove(clipboard);
                    break;
                }
                PasteManageComponent.processPaste(clipboard, destPath, uiExplorer, event, true, false);
                processList.remove(clipboard);
            }
            catch (ConstraintViolationException ce) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.current-node-not-allow-paste", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (VersionException ve) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.copied-node-in-versioning", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (ItemExistsException iee) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-node-same-name", null, 1));
                uiExplorer.updateAjax(event);
                processList.remove(clipboard);
            }
            catch (LoginException e) {
                if ("cut".equals(action)) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-login-node", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-paste-nodetype", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                uiExplorer.updateAjax(event);
                return;
            }
        }
        if (processList.isEmpty()) {
            UIPopupWindow popupAction = (UIPopupWindow)uiExplorer.findFirstComponentOfType(UIPopupWindow.class);
            popupAction.setShow(false);
            uiExplorer.updateAjax(event);
            versionedRemember = null;
            nonVersionedRemember = null;
        }
    }

    private static void makeVersion(Node destNode, Node _destNode, Node srcNode, ClipboardCommand clipboard, String action, String destPath, UIJCRExplorer uiExplorer, Event<?> event) throws Exception {
        AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
        ActionServiceContainer actionContainer = (ActionServiceContainer)uiExplorer.getApplicationComponent(ActionServiceContainer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        if (destNode.hasNode(srcNode.getName()) && "copy".equals(clipboard.getType()) && "CreateNewVersion".equals(action)) {
            autoVersionService.autoVersion(destNode.getNode(srcNode.getName()), srcNode);
        } else if (destNode.hasNode(srcNode.getName()) && "copy".equals(clipboard.getType()) && "KeepBoth".equals(action)) {
            UIDocumentAutoVersionForm.copyNode(destNode.getSession(), destNode.getSession().getWorkspace().getName(), srcNode.getPath(), destNode.getNode(srcNode.getName()).getPath(), uiApp, uiExplorer, event, "copy");
        } else if (destNode.hasNode(srcNode.getName()) && "copy".equals(clipboard.getType()) && "Replace".equals(action)) {
            autoVersionService.autoVersion(destNode.getNode(srcNode.getName()), srcNode);
        } else if ("KeepBoth".equals(action)) {
            if (destNode.hasNode(srcNode.getName())) {
                PasteManageComponent.pasteByCut(clipboard, uiExplorer, _destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), _destNode.getPath(), actionContainer, false, false, false);
            }
        } else {
            PasteManageComponent.pasteByCut(clipboard, uiExplorer, destNode.getSession(), clipboard.getWorkspace(), clipboard.getSrcPath(), destNode.getPath(), actionContainer, false, false, true);
        }
        isRefresh = true;
    }

    private static void showConfirmDialog(Node destNode, Node srcNode, UIJCRExplorer uiExplorer, ClipboardCommand clipboard, Set<ClipboardCommand> virtualClipboards, Event<?> event) throws Exception {
        Node destExitedNode = destNode.getNode(srcNode.getName());
        UIPopupContainer objUIPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
        UIDocumentAutoVersionForm uiDocumentAutoVersionForm = (UIDocumentAutoVersionForm)uiExplorer.createUIComponent(UIDocumentAutoVersionForm.class, null, null);
        uiDocumentAutoVersionForm.setDestPath(destNode.getPath());
        uiDocumentAutoVersionForm.setDestWorkspace(destNode.getSession().getWorkspace().getName());
        uiDocumentAutoVersionForm.setSourcePath(srcNode.getPath());
        uiDocumentAutoVersionForm.setSourceWorkspace(srcNode.getSession().getWorkspace().getName());
        uiDocumentAutoVersionForm.setCurrentClipboard(clipboard);
        uiDocumentAutoVersionForm.setMessage("UIDocumentAutoVersionForm.msg");
        uiDocumentAutoVersionForm.setArguments(new String[]{srcNode.getName()});
        uiDocumentAutoVersionForm.setClipboardCommands(virtualClipboards);
        if (virtualClipboards != null && virtualClipboards.size() == 1) {
            uiDocumentAutoVersionForm.setSingleProcess(true);
        }
        uiDocumentAutoVersionForm.init(destExitedNode);
        objUIPopupContainer.activate((UIComponent)uiDocumentAutoVersionForm, 450, 0);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)objUIPopupContainer);
        isRefresh = false;
    }

    private static void updateClipboard(Set<ClipboardCommand> clipboardCommands, Map<ClipboardCommand, Node> mapClipboard) throws Exception {
        for (ClipboardCommand clipboard : clipboardCommands) {
            Node srcNode;
            if (!"cut".equals(clipboard.getType()) || (srcNode = mapClipboard.get(clipboard)) == null) continue;
            srcNode.refresh(true);
            clipboard.setSrcPath(srcNode.getPath());
        }
    }

    private static Map<ClipboardCommand, Node> parseToMap(Set<ClipboardCommand> clipboardCommands, UIJCRExplorer uiExplorer) throws Exception {
        HashMap<ClipboardCommand, Node> mapClipboard = new HashMap<ClipboardCommand, Node>();
        for (ClipboardCommand clipboard : clipboardCommands) {
            String srcPath = clipboard.getSrcPath();
            String type = clipboard.getType();
            String srcWorkspace = clipboard.getWorkspace();
            if (!"cut".equals(type)) continue;
            Session srcSession = uiExplorer.getSessionByWorkspace(srcWorkspace);
            Node srcNode = uiExplorer.getNodeByPath(srcPath, srcSession, false);
            clipboard.setSrcPath(srcNode.getPath());
            mapClipboard.put(clipboard, srcNode);
        }
        return mapClipboard;
    }

    private static void processPaste(ClipboardCommand currentClipboard, String destPath, UIJCRExplorer uiExplorer, Event<?> event, boolean isMultiSelect, boolean isLastPaste) throws Exception {
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        String srcPath = currentClipboard.getSrcPath();
        String type = currentClipboard.getType();
        String srcWorkspace = currentClipboard.getWorkspace();
        Session srcSession = uiExplorer.getSessionByWorkspace(srcWorkspace);
        Node srcNode = uiExplorer.getNodeByPath(srcPath, srcSession, false);
        srcPath = srcNode.getPath();
        srcSession = srcNode.getSession();
        ThumbnailService thumbnailService = (ThumbnailService)WCMCoreUtils.getService(ThumbnailService.class);
        Node srcThumbnailNode = thumbnailService.getThumbnailNode(srcNode);
        srcWorkspace = srcSession.getWorkspace().getName();
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath);
        String destWorkspace = null;
        if (matcher.find()) {
            destWorkspace = matcher.group(1);
            destPath = matcher.group(2);
        }
        Session destSession = uiExplorer.getSessionByWorkspace(destWorkspace);
        if (destWorkspace == null) {
            destWorkspace = destSession.getWorkspace().getName();
        }
        Node destNode = uiExplorer.getNodeByPath(destPath, destSession);
        destPath = destNode.getPath();
        destSession = destNode.getSession();
        if ("cut".equals(type) && srcPath.equals(destPath)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-cutting", null, 1));
            return;
        }
        if (!"/".equals(destPath)) {
            destPath = destPath.concat("/");
        }
        destPath = destPath.concat(srcNode.getName());
        ActionServiceContainer actionContainer = (ActionServiceContainer)uiExplorer.getApplicationComponent(ActionServiceContainer.class);
        try {
            if ("copy".equals(type)) {
                String name;
                int i = 1;
                String originalPath = destPath;
                String originalName = name = srcNode.getName();
                String title = null;
                while (destNode.hasNode(name)) {
                    destPath = originalPath;
                    destPath = destPath + i;
                    name = originalName + i;
                    title = originalName + "(" + i + ")";
                    ++i;
                }
                PasteManageComponent.pasteByCopy(destSession, srcWorkspace, srcPath, destPath);
                destNode = (Node)destSession.getItem(destPath);
                actionContainer.initiateObservation(destNode);
                if (title != null) {
                    destNode.setProperty("exo:title", title);
                }
                destNode.save();
            } else {
                PasteManageComponent.pasteByCut(currentClipboard, uiExplorer, destSession, srcWorkspace, srcPath, destPath, actionContainer, isMultiSelect, isLastPaste, false);
                destNode = (Node)destSession.getItem(destPath);
            }
            if (!srcWorkspace.equals(destWorkspace) || !srcPath.equals(destPath)) {
                thumbnailService.copyThumbnailNode(srcThumbnailNode, destNode);
            }
        }
        catch (ConstraintViolationException ce) {
            LOG.debug("Error pasting document from {} to {}", new Object[]{srcPath, destPath, ce});
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.current-node-not-allow-paste", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (VersionException ve) {
            LOG.debug("Error pasting document from {} to {}", new Object[]{srcPath, destPath, ve});
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.copied-node-in-versioning", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ItemExistsException iee) {
            LOG.debug("Error pasting document from {} to {}", new Object[]{srcPath, destPath, iee});
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-node-same-name", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LoginException e) {
            LOG.debug("Error pasting document from {} to {}", new Object[]{srcPath, destPath, e});
            if ("cut".equals(type)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-login-node", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-paste-nodetype", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (AccessDeniedException ace) {
            LOG.debug("Error pasting document from {} to {}", new Object[]{srcPath, destPath, ace});
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LockException locke) {
            LOG.debug("Error pasting document from {} to {}", new Object[]{srcPath, destPath, locke});
            Object[] arg = new Object[]{srcPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-lock-exception", arg, 1));
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            uiExplorer.updateAjax(event);
            return;
        }
    }

    private static void changeCopiedNodeOwner(Node destNode) throws RepositoryException {
        Node destNodeSystem = WCMCoreUtils.getNodeBySystemSession((Node)destNode);
        String userID = destNode.getSession().getUserID();
        if (destNodeSystem.isNodeType("exo:owneable")) {
            destNodeSystem.removeMixin("exo:owneable");
            destNodeSystem.save();
            destNode.refresh(true);
        }
        if (destNodeSystem.isNodeType("exo:privilegeable")) {
            ((NodeImpl)destNodeSystem).setPermission(userID, PermissionType.ALL);
            destNodeSystem.save();
            destNode.refresh(true);
        }
        if (destNode.canAddMixin("exo:owneable")) {
            destNode.addMixin("exo:owneable");
        }
    }

    private static void removeReferences(Node destNode) throws Exception {
        NodeType[] mixinTypes = destNode.getMixinNodeTypes();
        Session session = destNode.getSession();
        for (int i = 0; i < mixinTypes.length; ++i) {
            if (!mixinTypes[i].getName().equals("exo:categorized") || !destNode.hasProperty("exo:categorized")) continue;
            Node valueNode = null;
            Value valueAdd = session.getValueFactory().createValue(valueNode);
            destNode.setProperty("exo:categorized", new Value[]{valueAdd});
        }
        destNode.save();
    }

    private static void pasteByCopy(Session session, String srcWorkspaceName, String srcPath, String destPath) throws Exception {
        block9: {
            Workspace workspace = session.getWorkspace();
            if (workspace.getName().equals(srcWorkspaceName)) {
                workspace.copy(srcPath, destPath);
                Node destNode = (Node)session.getItem(destPath);
                PasteManageComponent.changeCopiedNodeOwner(destNode);
                PasteManageComponent.removeReferences(destNode);
            } else {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Copy to another workspace");
                    }
                    workspace.copy(srcWorkspaceName, srcPath, destPath);
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"an unexpected error occurs while pasting the node", (Throwable)e);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Copy to other workspace by clone");
                    }
                    try {
                        workspace.clone(srcWorkspaceName, srcPath, destPath, false);
                    }
                    catch (Exception f) {
                        if (!LOG.isErrorEnabled()) break block9;
                        LOG.error((Object)"an unexpected error occurs while pasting the node", (Throwable)f);
                    }
                }
            }
        }
    }

    public static void pasteByCut(ClipboardCommand currentClipboard, UIJCRExplorer uiExplorer, Session session, String srcWorkspace, String srcPath, String destPath, ActionServiceContainer actionContainer, boolean isMultiSelect, boolean isLastPaste, boolean isCreateVersion) throws Exception {
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        Workspace workspace = session.getWorkspace();
        if (workspace.getName().equals(srcWorkspace) && srcPath.equals(destPath)) {
            return;
        }
        Set allClipboard = clipboardService.getClipboardList(userId, false);
        Set virtualClipboard = clipboardService.getClipboardList(userId, true);
        Map<ClipboardCommand, Node> mapAllClipboardNode = PasteManageComponent.parseToMap(allClipboard, uiExplorer);
        Map<ClipboardCommand, Node> mapVirtualClipboardNode = PasteManageComponent.parseToMap(virtualClipboard, uiExplorer);
        RelationsService relationsService = (RelationsService)uiExplorer.getApplicationComponent(RelationsService.class);
        ArrayList<Node> refList = new ArrayList<Node>();
        boolean isReference = false;
        PropertyIterator references = null;
        Node srcNode = (Node)uiExplorer.getSessionByWorkspace(srcWorkspace).getItem(srcPath);
        try {
            references = srcNode.getReferences();
            isReference = true;
        }
        catch (Exception e) {
            isReference = false;
        }
        if (isReference && references != null && references.getSize() > 0L) {
            while (references.hasNext()) {
                Property pro = references.nextProperty();
                Node refNode = pro.getParent();
                if (!refNode.hasProperty(RELATION_PROP)) continue;
                relationsService.removeRelation(refNode, srcPath);
                refNode.save();
                refList.add(refNode);
            }
        }
        ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
        ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
        uiExplorer.addLockToken(srcNode);
        if (workspace.getName().equals(srcWorkspace)) {
            try {
                if (isCreateVersion) {
                    Node _destNode = ((Node)session.getItem(destPath)).getNode(srcNode.getName());
                    AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
                    autoVersionService.autoVersion(_destNode, srcNode);
                    if (!srcNode.getPath().equals(_destNode.getPath())) {
                        srcNode.remove();
                    }
                } else {
                    workspace.move(srcPath, destPath);
                }
                LockUtil.changeLockToken((String)srcPath, (Node)((Node)session.getItem(destPath)));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new MessageException(new ApplicationMessage("UIPopupMenu.msg.node-cutting", null, 1));
            }
            if (!isMultiSelect || isMultiSelect && isLastPaste) {
                Node desNode = null;
                try {
                    desNode = (Node)session.getItem(destPath);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                    desNode = uiExplorer.getCurrentNode();
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                    desNode = uiExplorer.getCurrentNode();
                }
                if (!session.itemExists(uiExplorer.getCurrentPath())) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                }
                if (activityService.isAcceptedNode(desNode) || desNode.getPrimaryNodeType().getName().equals("nt:file")) {
                    listenerService.broadcast(ActivityCommonService.NODE_MOVED_ACTIVITY, (Object)desNode, (Object)desNode.getPath());
                }
                if (!desNode.getPath().equals(uiExplorer.getCurrentPath())) {
                    actionContainer.initiateObservation(desNode);
                }
                for (int i = 0; i < refList.size(); ++i) {
                    Node addRef = (Node)refList.get(i);
                    relationsService.addRelation(addRef, destPath, session.getWorkspace().getName());
                    addRef.save();
                }
                clipboardService.clearClipboardList(userId, true);
                Node currentNode = uiExplorer.getCurrentNode();
                String realCurrentPath = currentNode.getPath();
                if (srcWorkspace.equals(currentNode.getSession().getWorkspace().getName()) && (srcPath.equals(realCurrentPath) || realCurrentPath.startsWith(srcPath))) {
                    uiExplorer.setCurrentPath(LinkUtils.getParentPath((String)uiExplorer.getCurrentPath()));
                }
            }
        } else {
            workspace.clone(srcWorkspace, srcPath, destPath, false);
            Node desNode = (Node)workspace.getSession().getItem(destPath);
            if (activityService.isAcceptedNode(desNode) || desNode.getPrimaryNodeType().getName().equals("nt:file")) {
                listenerService.broadcast(ActivityCommonService.NODE_MOVED_ACTIVITY, (Object)desNode, (Object)destPath);
            }
            if (!isMultiSelect || isMultiSelect && isLastPaste) {
                clipboardService.clearClipboardList(userId, true);
            }
        }
        clipboardService.getClipboardList(userId, false).remove(currentClipboard);
        PasteManageComponent.updateClipboard(clipboardService.getClipboardList(userId, true), mapVirtualClipboardNode);
        PasteManageComponent.updateClipboard(clipboardService.getClipboardList(userId, false), mapAllClipboardNode);
        clipboardService.clearClipboardList(userId, true);
        clipboardService.clearClipboardList(userId, false);
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static void setVersionedRemember(Map<String, Boolean> versionedRemember) {
        PasteManageComponent.versionedRemember = versionedRemember;
    }

    public static void setNonVersionedRemember(Map<String, Boolean> nonVersionedRemember) {
        PasteManageComponent.nonVersionedRemember = nonVersionedRemember;
    }

    public static Map<String, Boolean> getVersionedRemember() {
        return versionedRemember;
    }

    public static class PasteActionListener
    extends UIWorkingAreaActionListener<PasteManageComponent> {
        public void processEvent(Event<PasteManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((PasteManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            PasteManageComponent.pasteManage(event, uiExplorer);
        }
    }
}

