/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core.supplier;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import liquibase.sdk.supplier.database.ConnectionSupplier;

public class MySQLConnSupplier
extends ConnectionSupplier {
    @Override
    public String getDatabaseShortName() {
        return "mysql";
    }

    public int getPort() {
        return 3306;
    }

    @Override
    public String getAdminUsername() {
        return "root";
    }

    @Override
    public String getJdbcUrl() {
        return "jdbc:mysql://" + this.getIpAddress() + "/" + this.getPrimaryCatalog();
    }

    @Override
    public Set<String> getPuppetModules() {
        Set<String> modules = super.getPuppetModules();
        modules.add("puppetlabs/mysql");
        return modules;
    }

    @Override
    public Set<ConnectionSupplier.ConfigTemplate> generateConfigFiles(Map<String, Object> context) throws IOException {
        Set<ConnectionSupplier.ConfigTemplate> configTemplates = super.generateConfigFiles(context);
        configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/mysql/mysql.init.sql.vm", context));
        if (this.isWindows()) {
            configTemplates.add(new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/mysql/mysql.ini.vm", context));
        }
        return configTemplates;
    }

    @Override
    public ConnectionSupplier.ConfigTemplate getPuppetTemplate(Map<String, Object> context) {
        if (this.isWindows()) {
            return new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/mysql/mysql-windows.puppet.vm", context);
        }
        return new ConnectionSupplier.ConfigTemplate("liquibase/sdk/vagrant/supplier/mysql/mysql-linux.puppet.vm", context);
    }

    public String getSourceUrl() {
        return "http://dev.mysql.com/get/Downloads/MySQL-" + this.getShortVersion() + "/mysql-" + this.getVersion() + "-winx64.msi";
    }

    public String getInstallDir() {
        return "C:\\mysql-" + this.getShortVersion();
    }

    @Override
    public String getDescription() {
        if (this.getOs().equals("windows")) {
            return super.getDescription() + "\n" + "Install Dir: " + this.getInstallDir() + "\n" + "Port: " + this.getPort() + "\n" + "Root Password: " + this.getAdminPassword();
        }
        return super.getDescription();
    }
}

