/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.form.UIFormInputSetWithNoLabel;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/template/UITemplateForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIViewTemplate.SelectTabActionListener.class})})
public class UITemplateForm
extends UIFormTabPane
implements UISelectable {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_ISTEMPLATE = "isDocumentTemplate";
    public static final String FIELD_DIALOG = "dialog";
    public static final String FIELD_VIEW = "view";
    public static final String FIELD_SKIN = "skin";
    public static final String FIELD_TAB_TEMPLATE = "UITemplateForm";
    public static final String FIELD_TAB_DIALOG = "UIDialogTab";
    public static final String FIELD_TAB_VIEW = "UIViewTab";
    public static final String FIELD_TAB_SKIN = "UISkinTab";
    public static final String FIELD_PERMISSION = "permission";
    public static final String POPUP_PERMISSION = "PopupViewPermission";
    public static final String DOCUMENTS_TEMPLATE_TYPE = "templates";
    public static final String ACTIONS_TEMPLATE_TYPE = "actions";
    public static final String OTHERS_TEMPLATE_TYPE = "others";
    private String selectedTabId = "";
    private String filter = "";

    public String getSelectedTabId() {
        return this.selectedTabId;
    }

    public void setSelectedTab(String renderTabId) {
        this.selectedTabId = renderTabId;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setSelectedTab(int index) {
        this.selectedTabId = this.getChild(index - 1).getId();
    }

    public UITemplateForm() throws Exception {
        super(FIELD_TAB_TEMPLATE);
        UIFormInputSetWithAction templateTab = new UIFormInputSetWithAction(FIELD_TAB_TEMPLATE);
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_NAME, FIELD_NAME, this.getOption());
        uiSelectBox.setOnChange("OnChange");
        templateTab.addUIFormInput((UIFormInput)uiSelectBox);
        templateTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL, FIELD_LABEL, null).addValidator(MandatoryValidator.class, new Object[0]));
        templateTab.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_ISTEMPLATE, FIELD_ISTEMPLATE, null).setChecked(true));
        templateTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null).setDisabled(true).addValidator(MandatoryValidator.class, new Object[0]));
        templateTab.setActionInfo(FIELD_PERMISSION, new String[]{"AddPermission"});
        this.addUIComponentInput((UIComponent)templateTab);
        this.setSelectedTab(templateTab.getId());
        UIFormInputSetWithNoLabel defaultDialogTab = new UIFormInputSetWithNoLabel(FIELD_TAB_DIALOG);
        defaultDialogTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DIALOG, FIELD_DIALOG, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInputSet)defaultDialogTab);
        UIFormInputSetWithNoLabel defaultViewTab = new UIFormInputSetWithNoLabel(FIELD_TAB_VIEW);
        defaultViewTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_VIEW, FIELD_VIEW, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInputSet)defaultViewTab);
        UIFormInputSetWithNoLabel defaultSkinTab = new UIFormInputSetWithNoLabel(FIELD_TAB_SKIN);
        defaultSkinTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_SKIN, FIELD_SKIN, null));
        this.addUIFormInput((UIFormInputSet)defaultSkinTab);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
        this.setSelectedTab(FIELD_TAB_TEMPLATE);
    }

    public void refresh() throws Exception {
        this.getUIFormSelectBox(FIELD_NAME).setOptions(this.getOption());
        String nodeType = (String)this.getUIFormSelectBox(FIELD_NAME).getValue();
        this.getUIStringInput(FIELD_LABEL).setValue((Object)"");
        if (this.filter.equals(DOCUMENTS_TEMPLATE_TYPE)) {
            this.getUICheckBoxInput(FIELD_ISTEMPLATE).setChecked(true);
        } else {
            this.getUICheckBoxInput(FIELD_ISTEMPLATE).setChecked(false);
        }
        this.getUICheckBoxInput(FIELD_ISTEMPLATE).setDisabled(true);
        this.initTemplate(nodeType);
        this.getUIStringInput(FIELD_PERMISSION).setValue((Object)"");
    }

    private void initTemplate(String nodeType) throws Exception {
        this.getUIFormTextAreaInput(FIELD_VIEW).setValue((Object)this.getDefaultView(nodeType));
        this.getUIFormTextAreaInput(FIELD_DIALOG).setValue((Object)this.getDefaultDialog(nodeType));
        this.getUIFormTextAreaInput(FIELD_SKIN).setValue((Object)this.getDefaultStyleSheet(nodeType));
    }

    private String getDefaultStyleSheet(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.buildStyleSheet(nodeType);
    }

    private String getDefaultView(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.buildViewForm(nodeType);
    }

    private String getDefaultDialog(String nodeType) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.buildDialogForm(nodeType);
    }

    public List<SelectItemOption<String>> getOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ExtendedNodeTypeManager nodeTypeManager = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getNodeTypeManager();
        Node templatesHome = ((TemplateService)this.getApplicationComponent(TemplateService.class)).getTemplatesHome(WCMCoreUtils.getSystemSessionProvider());
        if (templatesHome != null) {
            NodeIterator templateIter = templatesHome.getNodes();
            ArrayList<String> templates = new ArrayList<String>();
            while (templateIter.hasNext()) {
                templates.add(templateIter.nextNode().getName());
            }
            NodeTypeIterator iter = nodeTypeManager.getAllNodeTypes();
            while (iter.hasNext()) {
                String nodeTypeName;
                NodeType nodeType = iter.nextNodeType();
                if (nodeType.isMixin() || templates.contains(nodeTypeName = nodeType.getName())) continue;
                if (this.filter.equals(ACTIONS_TEMPLATE_TYPE) && nodeTypeManager.getNodeType(nodeTypeName).isNodeType("exo:action")) {
                    options.add((SelectItemOption<String>)new SelectItemOption(nodeTypeName, (Object)nodeTypeName));
                    continue;
                }
                options.add((SelectItemOption<String>)new SelectItemOption(nodeTypeName, (Object)nodeTypeName));
            }
            Collections.sort(options, new TemplateNameComparator());
        }
        return options;
    }

    public void doSelect(String selectField, Object value) {
        UIFormInputSetWithAction uiFormAction = (UIFormInputSetWithAction)this.getChildById(FIELD_TAB_TEMPLATE);
        uiFormAction.getUIStringInput(FIELD_PERMISSION).setValue((Object)value.toString());
    }

    public static class AddPermissionActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiTemplateForm = (UITemplateForm)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiTemplateForm.getAncestorOfType(UITemplatesManager.class);
            String membership = (String)uiTemplateForm.getUIStringInput(UITemplateForm.FIELD_PERMISSION).getValue();
            uiManager.initPopupPermission("AddNew", membership);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChildById("TemplatePermission");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    public static class OnChangeActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiFormTabPane = (UITemplateForm)((Object)event.getSource());
            String nodeType = (String)uiFormTabPane.getUIFormSelectBox(UITemplateForm.FIELD_NAME).getValue();
            uiFormTabPane.getUIStringInput(UITemplateForm.FIELD_LABEL).setValue((Object)"");
            uiFormTabPane.initTemplate(nodeType);
            uiFormTabPane.getUIStringInput(UITemplateForm.FIELD_PERMISSION).setValue((Object)"");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormTabPane.getParent());
        }
    }

    public static class RefreshActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplatesManager uiManager = (UITemplatesManager)((UITemplateForm)((Object)event.getSource())).getAncestorOfType(UITemplatesManager.class);
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiManager.getChildById("TemplateContainerPopup");
            uiPopupWindow.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class SaveActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)((UITemplateForm)((Object)event.getSource())).getAncestorOfType(UITemplatesManager.class);
            String name = ((String)uiForm.getUIFormSelectBox(UITemplateForm.FIELD_NAME).getValue()).trim();
            String label = ((String)uiForm.getUIStringInput(UITemplateForm.FIELD_LABEL).getValue()).trim();
            String dialog = (String)uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_DIALOG).getValue();
            String view = (String)uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_VIEW).getValue();
            String skin = (String)uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_SKIN).getValue();
            if (skin == null) {
                skin = "";
            }
            boolean isDocumentTemplate = uiForm.getUICheckBoxInput(UITemplateForm.FIELD_ISTEMPLATE).isChecked();
            UIFormInputSetWithAction permField = (UIFormInputSetWithAction)uiForm.getChildById(UITemplateForm.FIELD_TAB_TEMPLATE);
            String role = (String)permField.getUIStringInput(UITemplateForm.FIELD_PERMISSION).getValue();
            if (role == null || role.trim().length() == 0) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UITemplateForm.msg.role-require", null, 1));
                return;
            }
            String[] roles = new String[]{role};
            if (dialog == null) {
                dialog = "";
            }
            if (view == null) {
                view = "";
            }
            TemplateService templateService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            templateService.addTemplate("dialogs", name, label, isDocumentTemplate, "dialog1", roles, (InputStream)new ByteArrayInputStream(dialog.getBytes()));
            templateService.addTemplate("views", name, label, isDocumentTemplate, "view1", roles, (InputStream)new ByteArrayInputStream(view.getBytes()));
            templateService.addTemplate("skins", name, label, isDocumentTemplate, "Stylesheet-lt", roles, (InputStream)new ByteArrayInputStream(skin.getBytes()));
            WCMComposer composer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
            composer.updateTemplatesSQLFilter();
            uiManager.refresh();
            UIPopupWindow uiPopupWindow = (UIPopupWindow)uiManager.getChildById("TemplateContainerPopup");
            uiPopupWindow.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class TemplateNameComparator
    implements Comparator<SelectItemOption<String>> {
        @Override
        public int compare(SelectItemOption<String> o1, SelectItemOption<String> o2) throws ClassCastException {
            try {
                String name1 = ((String)o1.getValue()).toString();
                String name2 = ((String)o2.getValue()).toString();
                return name1.compareToIgnoreCase(name2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

