/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates.clv;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.ecm.webui.component.admin.templates.clv.UICLVTemplatesManager;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICLVTemplateForm
extends UIForm {
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_TEMPLATE_NAME = "template";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_CONTENT_TYPE = "type";
    private boolean isAddNew;
    private String selectedCategory;

    public UICLVTemplateForm() throws Exception {
        UIFormTextAreaInput contentInput = new UIFormTextAreaInput(FIELD_CONTENT, FIELD_CONTENT, null);
        this.addUIFormInput((UIFormInput)contentInput);
        UIFormStringInput nameInput = new UIFormStringInput(FIELD_TITLE, FIELD_TITLE, null);
        nameInput.addValidator(ECMNameValidator.class, new Object[0]);
        this.addUIFormInput((UIFormInput)nameInput);
        UIFormStringInput tempateNameInput = new UIFormStringInput(FIELD_TEMPLATE_NAME, FIELD_TEMPLATE_NAME, null);
        tempateNameInput.addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]);
        this.addUIFormInput((UIFormInput)tempateNameInput);
        ArrayList<SelectItemOption> templateOptions = new ArrayList<SelectItemOption>();
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        templateOptions.add(new SelectItemOption(res.getString("UICLVTemplateForm.label.list"), (Object)"list"));
        templateOptions.add(new SelectItemOption(res.getString("UICLVTemplateForm.label.navigation"), (Object)"navigation"));
        templateOptions.add(new SelectItemOption(res.getString("UICLVTemplateForm.label.paginators"), (Object)"paginators"));
        UIFormSelectBox templateType = new UIFormSelectBox(FIELD_CONTENT_TYPE, FIELD_CONTENT_TYPE, templateOptions);
        this.addUIFormInput((UIFormInput)templateType);
    }

    public void refresh(String category) throws Exception {
        this.isAddNew = true;
        this.selectedCategory = category;
        this.setActions(new String[]{"Save", "Reset", "Cancel"});
        this.getUIStringInput(FIELD_TITLE).setValue((Object)"");
        this.getUIStringInput(FIELD_TEMPLATE_NAME).setValue((Object)"");
        this.getUIStringInput(FIELD_TEMPLATE_NAME).setDisabled(false);
        this.getUIFormTextAreaInput(FIELD_CONTENT).setValue((Object)"");
        this.getUIFormSelectBox(FIELD_CONTENT_TYPE).setValue(this.selectedCategory);
    }

    public void update(String category, String name) throws Exception {
        this.isAddNew = false;
        this.selectedCategory = category;
        this.setActions(new String[]{"Save", "Cancel"});
        ApplicationTemplateManagerService templateManager = (ApplicationTemplateManagerService)WCMCoreUtils.getService(ApplicationTemplateManagerService.class);
        Node templateNode = templateManager.getTemplateByName("content-list-viewer", category, name, WCMCoreUtils.getSystemSessionProvider());
        Node content = templateNode.getNode("jcr:content");
        try {
            this.getUIStringInput(FIELD_TITLE).setValue((Object)content.getProperty("dc:title").getValues()[0].getString());
        }
        catch (PathNotFoundException pne) {
            this.getUIStringInput(FIELD_TITLE).setValue((Object)templateNode.getName());
        }
        catch (ArrayIndexOutOfBoundsException aoe) {
            this.getUIStringInput(FIELD_TITLE).setValue((Object)templateNode.getName());
        }
        this.getUIStringInput(FIELD_TEMPLATE_NAME).setValue((Object)templateNode.getName());
        this.getUIStringInput(FIELD_TEMPLATE_NAME).setDisabled(true);
        this.getUIFormTextAreaInput(FIELD_CONTENT).setValue((Object)content.getProperty("jcr:data").getString());
        this.getUIFormSelectBox(FIELD_CONTENT_TYPE).setValue(category);
    }

    private void addTemplate(String category, String title, String template, String content) throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        ApplicationTemplateManagerService appTemplateManager = (ApplicationTemplateManagerService)WCMCoreUtils.getService(ApplicationTemplateManagerService.class);
        if (content == null) {
            content = "";
        }
        if (this.isAddNew) {
            if (!template.contains(".gtmpl")) {
                template = template + ".gtmpl";
            }
            if (title == null || title.length() == 0) {
                title = template;
            }
            templateService.createTemplate(this.getCategoryByName(category), title, template, (InputStream)new ByteArrayInputStream(content.getBytes()), new String[]{"*"});
        } else if (this.hasTemplate(category, template)) {
            if (!this.selectedCategory.equals(category)) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UICLVTemplateForm.msg.template-existing", null, 1));
                return;
            }
            Node templateNode = this.getCategoryByName(category).getNode(template);
            Node contentNode = templateNode.getNode("jcr:content");
            contentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(content.getBytes()));
            if (title == null || title.length() == 0) {
                title = templateNode.getName();
            }
            contentNode.setProperty("dc:title", new String[]{title});
            templateNode.save();
        } else {
            templateService.createTemplate(this.getCategoryByName(category), title, template, (InputStream)new ByteArrayInputStream(content.getBytes()), new String[]{"*"});
            appTemplateManager.removeTemplate("content-list-viewer", this.selectedCategory, template, WCMCoreUtils.getSystemSessionProvider());
        }
    }

    private boolean hasTemplate(String category, String template) throws Exception {
        if (!template.contains(".gtmpl")) {
            template = template + ".gtmpl";
        }
        return this.getCategoryByName(category).hasNode(template);
    }

    private Node getCategoryByName(String category) throws Exception {
        ApplicationTemplateManagerService templateManager = (ApplicationTemplateManagerService)WCMCoreUtils.getService(ApplicationTemplateManagerService.class);
        Node templateHome = templateManager.getApplicationTemplateHome("content-list-viewer", WCMCoreUtils.getSystemSessionProvider());
        return templateHome.getNode(category);
    }

    public static class CancelActionListener
    extends EventListener<UICLVTemplateForm> {
        public void execute(Event<UICLVTemplateForm> event) throws Exception {
            UICLVTemplateForm uiForm = (UICLVTemplateForm)((Object)event.getSource());
            UICLVTemplatesManager uiManager = (UICLVTemplatesManager)uiForm.getAncestorOfType(UICLVTemplatesManager.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class ResetActionListener
    extends EventListener<UICLVTemplateForm> {
        public void execute(Event<UICLVTemplateForm> event) throws Exception {
            UICLVTemplateForm uiForm = (UICLVTemplateForm)((Object)event.getSource());
            uiForm.refresh(uiForm.selectedCategory);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class SaveActionListener
    extends EventListener<UICLVTemplateForm> {
        public void execute(Event<UICLVTemplateForm> event) throws Exception {
            String template;
            UICLVTemplateForm uiForm = (UICLVTemplateForm)((Object)event.getSource());
            UICLVTemplatesManager uiManager = (UICLVTemplatesManager)uiForm.getAncestorOfType(UICLVTemplatesManager.class);
            String title = (String)uiForm.getUIStringInput(UICLVTemplateForm.FIELD_TITLE).getValue();
            if (title != null) {
                title = title.trim();
            }
            if ((template = (String)uiForm.getUIStringInput(UICLVTemplateForm.FIELD_TEMPLATE_NAME).getValue()) != null) {
                template = template.trim();
            }
            String category = (String)uiForm.getUIFormSelectBox(UICLVTemplateForm.FIELD_CONTENT_TYPE).getValue();
            String content = (String)uiForm.getUIFormTextAreaInput(UICLVTemplateForm.FIELD_CONTENT).getValue();
            if (content != null) {
                content = content.trim();
            }
            if (uiForm.isAddNew & uiForm.hasTemplate(category, template)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UICLVTemplateForm.msg.template-existing", null, 1));
                return;
            }
            uiForm.addTemplate(category, title, template, content);
            uiManager.refresh();
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

