/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.diff.DiffResult;
import org.exoplatform.commons.diff.DiffService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.VersionNameComparatorDesc;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.CompareRevisionActionListener;
import org.exoplatform.wiki.webui.control.action.ShowHistoryActionListener;
import org.exoplatform.wiki.webui.control.action.ViewRevisionActionListener;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageVersionsCompare.gtmpl", events={@EventConfig(listeners={ShowHistoryActionListener.class}), @EventConfig(listeners={ViewRevisionActionListener.class}), @EventConfig(listeners={CompareActionListener.class})})
public class UIWikiPageVersionsCompare
extends UIWikiContainer {
    private String differencesAsHTML;
    private String currentVersionIndex;
    private List<PageVersion> versions;
    private PageVersion fromVersion;
    private PageVersion toVersion;
    private int changes;
    public static final String SHOW_HISTORY = "ShowHistory";
    public static final String VIEW_REVISION = "ViewRevision";
    public static final String COMPARE_ACTION = "Compare";
    public static final String FROM_PARAM = "from";
    public static final String TO_PARAM = "to";
    private String fromVersionName;
    private String fromVersionAuthor;
    private String fromVersionUpdateDate;
    private String toVersionName;
    private String toVersionAuthor;
    private String toVersionUpdateDate;
    private static WikiService wikiService;

    public UIWikiPageVersionsCompare() {
        wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        this.accept_Modes = Arrays.asList(WikiMode.COMPAREREVISION);
    }

    public List<PageVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<PageVersion> versions) {
        this.versions = versions;
    }

    public String getDifferencesAsHTML() {
        return this.differencesAsHTML;
    }

    public void setDifferencesAsHTML(String differencesAsHTML) {
        this.differencesAsHTML = differencesAsHTML;
    }

    public String getCurrentVersionIndex() {
        return this.currentVersionIndex;
    }

    public void setCurrentVersionIndex(String currentVersionIndex) {
        this.currentVersionIndex = currentVersionIndex;
    }

    public PageVersion getFromVersion() {
        return this.fromVersion;
    }

    public void setFromVersion(PageVersion fromVersion) throws Exception {
        this.fromVersionName = fromVersion.getName();
        this.fromVersionAuthor = Utils.getFullName(fromVersion.getAuthor());
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 3, currentLocale);
        this.fromVersionUpdateDate = df.format(fromVersion.getUpdatedDate());
        this.fromVersion = fromVersion;
    }

    public String getFromVersionName() {
        return this.fromVersionName;
    }

    public String getFromVersionAuthor() {
        return this.fromVersionAuthor;
    }

    public String getFromVersionUpdateDate() {
        return this.fromVersionUpdateDate;
    }

    public PageVersion getToVersion() {
        return this.toVersion;
    }

    public void setToVersion(PageVersion toVersion) throws Exception {
        this.toVersionName = toVersion.getName();
        this.toVersionAuthor = Utils.getFullName(toVersion.getAuthor());
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 3, currentLocale);
        this.toVersionUpdateDate = df.format(toVersion.getUpdatedDate());
        this.toVersion = toVersion;
    }

    public String getToVersionName() {
        return this.toVersionName;
    }

    public String getToVersionAuthor() {
        return this.toVersionAuthor;
    }

    public String getToVersionUpdateDate() {
        return this.toVersionUpdateDate;
    }

    public int getChanges() {
        return this.changes;
    }

    public void setChanges(int changes) {
        this.changes = changes;
    }

    public void renderVersionsDifference(List<PageVersion> versions, int from, int to) throws Exception {
        if (versions == null) {
            throw new IllegalArgumentException("Versions cannot be null");
        }
        Collections.sort(versions, new VersionNameComparatorDesc());
        if (from < to) {
            int temp = to;
            to = from;
            from = temp;
        }
        if (from >= versions.size()) {
            throw new Exception("Cannot compare versions " + to + " and " + from + ", the page only has " + versions.size() + " versions");
        }
        this.versions = versions;
        PageVersion toVersion = versions.get(to);
        String toVersionContent = toVersion.getContent();
        PageVersion fromVersion = versions.get(from);
        String fromVersionContent = fromVersion.getContent();
        DiffService diffService = (DiffService)this.getApplicationComponent(DiffService.class);
        this.setRendered(true);
        this.setFromVersion(fromVersion);
        this.setToVersion(toVersion);
        this.setCurrentVersionIndex(String.valueOf(versions.size()));
        DiffResult diffResult = diffService.getDifferencesAsHTML(fromVersionContent, toVersionContent, true);
        this.setDifferencesAsHTML(diffResult.getDiffHTML());
        this.setChanges(diffResult.getChanges());
    }

    public static class CompareActionListener
    extends CompareRevisionActionListener {
        @Override
        public void execute(Event<UIComponent> event) throws Exception {
            UIWikiPageVersionsCompare component = (UIWikiPageVersionsCompare)((Object)event.getSource());
            String fromVersionName = event.getRequestContext().getRequestParameter(UIWikiPageVersionsCompare.FROM_PARAM);
            String toVersionName = event.getRequestContext().getRequestParameter(UIWikiPageVersionsCompare.TO_PARAM);
            List versions = wikiService.getVersionsOfPage(Utils.getCurrentWikiPage());
            this.setVersionToCompare(new ArrayList<PageVersion>(versions));
            for (int i = 0; i < versions.size(); ++i) {
                PageVersion version = (PageVersion)versions.get(i);
                if (version.getName().equals(fromVersionName)) {
                    this.setFrom(i);
                }
                if (!version.getName().equals(toVersionName)) continue;
                this.setTo(i);
            }
            super.execute(event);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)component);
        }
    }
}

