/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.updater;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.updater.IdentityMigrationService;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;

public class MigrationIdentityStorage
implements IdentityStorage {
    private final IdentityStorageImpl jcrStorage;
    private final RDBMSIdentityStorageImpl jpaStorage;
    private final IdentityMigrationService migrationService;

    public MigrationIdentityStorage(IdentityStorageImpl jcrStorage, RDBMSIdentityStorageImpl jpaStorage, IdentityMigrationService migrationService) {
        this.jcrStorage = jcrStorage;
        this.jpaStorage = jpaStorage;
        this.migrationService = migrationService;
    }

    public void saveIdentity(Identity identity) throws IdentityStorageException {
        this.jpaStorage.saveIdentity(identity);
    }

    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        return this.jpaStorage.updateIdentity(identity);
    }

    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
        this.jpaStorage.updateIdentityMembership(remoteId);
    }

    public Identity findIdentityById(String nodeId) throws IdentityStorageException {
        Identity identity = this.jpaStorage.findIdentityById(nodeId);
        if (identity == null && this.jcrStorage.findIdentityById(nodeId) != null) {
            identity = this.migrationService.migrateIdentity(nodeId);
        }
        return identity;
    }

    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        this.jpaStorage.deleteIdentity(identity);
    }

    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        this.jpaStorage.hardDeleteIdentity(identity);
    }

    public Profile loadProfile(Profile profile) throws IdentityStorageException {
        return this.jpaStorage.loadProfile(profile);
    }

    public Identity findIdentity(String providerId, String remoteId) throws IdentityStorageException {
        Identity identity = this.jpaStorage.findIdentity(providerId, remoteId);
        if (identity == null && (identity = this.jcrStorage.findIdentity(providerId, remoteId)) != null) {
            identity = this.migrationService.migrateIdentity(identity.getId());
        }
        return identity;
    }

    public void saveProfile(Profile profile) throws IdentityStorageException {
        this.jpaStorage.saveProfile(profile);
    }

    public void updateProfile(Profile profile) throws IdentityStorageException {
        this.jpaStorage.updateProfile(profile);
    }

    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesCount(providerId);
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesByProfileFilter(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
    }

    public List<Identity> getIdentitiesForMentions(String providerId, ProfileFilter profileFilter, Relationship.Type type, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesForMentions(providerId, profileFilter, type, offset, limit, forceLoadOrReloadProfile);
    }

    public List<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter, long offset, long limit) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesForUnifiedSearch(providerId, profileFilter, offset, limit);
    }

    public int getIdentitiesByProfileFilterCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesByProfileFilterCount(providerId, profileFilter);
    }

    public int getIdentitiesByFirstCharacterOfNameCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesByFirstCharacterOfNameCount(providerId, profileFilter);
    }

    public List<Identity> getIdentitiesByFirstCharacterOfName(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesByFirstCharacterOfName(providerId, profileFilter, offset, limit, forceLoadOrReloadProfile);
    }

    public String getType(String nodetype, String property) {
        return this.jpaStorage.getType(nodetype, property);
    }

    public void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        this.jpaStorage.addOrModifyProfileProperties(profile);
    }

    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit) throws IdentityStorageException {
        return this.jpaStorage.getSpaceMemberIdentitiesByProfileFilter(space, profileFilter, type, offset, limit);
    }

    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
        this.jpaStorage.updateProfileActivityId(identity, activityId, type);
    }

    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        return this.jpaStorage.getProfileActivityId(profile, type);
    }

    public Set<String> getActiveUsers(ActiveIdentityFilter filter) {
        return this.jpaStorage.getActiveUsers(filter);
    }

    public void processEnabledIdentity(Identity identity, boolean isEnable) {
        this.jpaStorage.processEnabledIdentity(identity, isEnable);
    }

    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, int offset, int limit) {
        return this.jpaStorage.getIdentitiesWithRelationships(identityId, offset, limit);
    }

    public int countIdentitiesWithRelationships(String identityId) throws Exception {
        return this.jpaStorage.countIdentitiesWithRelationships(identityId);
    }

    public InputStream getAvatarInputStreamById(Identity identity) throws IOException {
        return this.jpaStorage.getAvatarInputStreamById(identity);
    }

    public InputStream getBannerInputStreamById(Identity identity) throws IOException {
        return this.jpaStorage.getBannerInputStreamById(identity);
    }

    public int getIdentitiesForMentionsCount(String providerId, ProfileFilter profileFilter, Relationship.Type type) throws IdentityStorageException {
        return this.jpaStorage.getIdentitiesForMentionsCount(providerId, profileFilter, type);
    }

    public int countSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type) {
        return this.jpaStorage.countSpaceMemberIdentitiesByProfileFilter(space, profileFilter, type);
    }

    public List<Identity> getIdentities(String providerId, long offset, long limit) {
        return this.jpaStorage.getIdentities(providerId, offset, limit);
    }

    public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        return this.jpaStorage.sortIdentities(identityRemoteIds, firstCharacterFieldName, firstCharacter, sortField, sortDirection);
    }
}

