/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.RolesExtractor;

public class DefaultRolesExtractorImpl
implements RolesExtractor {
    protected String userRoleParentGroup = null;

    public DefaultRolesExtractorImpl(InitParams params) {
        ValueParam param;
        if (params != null && (param = params.getValueParam("user.role.parent.group")) != null && param.getValue().length() > 0) {
            this.userRoleParentGroup = param.getValue();
        }
    }

    public DefaultRolesExtractorImpl() {
    }

    public void setUserRoleParentGroup(String userRoleParentGroup) {
        this.userRoleParentGroup = userRoleParentGroup;
    }

    @Override
    public Set<String> extractRoles(String userId, Set<MembershipEntry> memberships) {
        HashSet<String> roles = new HashSet<String>();
        for (MembershipEntry membership : memberships) {
            String[] splittedGroupName = StringUtils.split((String)membership.getGroup(), (String)"/");
            if (this.userRoleParentGroup != null && splittedGroupName[0].equals(this.userRoleParentGroup) && splittedGroupName.length > 1) {
                roles.add(splittedGroupName[splittedGroupName.length - 1]);
                continue;
            }
            roles.add(splittedGroupName[0]);
        }
        return roles;
    }
}

