/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source.table;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.internal.macro.chart.source.table.AbstractTableBlockDataSource;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="inline")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class MacroContentTableBlockDataSource
extends AbstractTableBlockDataSource {
    @Inject
    private MacroContentParser macroContentParser;

    @Override
    protected TableBlock getTableBlock(String macroContent, MacroTransformationContext context) throws MacroExecutionException {
        if (StringUtils.isEmpty((CharSequence)macroContent)) {
            throw new MacroExecutionException("A Chart Macro using an inline source must have a data table defined in its content.");
        }
        XDOM xdom = this.macroContentParser.parse(macroContent, context, true, false);
        List tableBlocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(TableBlock.class), Block.Axes.DESCENDANT);
        if (tableBlocks.size() == 0) {
            throw new MacroExecutionException("Unable to locate a suitable data table.");
        }
        return (TableBlock)tableBlocks.get(0);
    }
}

