/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.wcm.ext.component.activity.SharedContentUIActivity;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class UISharedContentBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(UISharedContentBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, ExoSocialActivity activity) {
        Node contentNode;
        SharedContentUIActivity contentActivity;
        block7: {
            contentActivity = (SharedContentUIActivity)uiActivity;
            String nodeUUID = "";
            String workspaceName = "";
            if (activity.getTemplateParams() != null) {
                contentActivity.setUIActivityData(activity.getTemplateParams());
                nodeUUID = (String)activity.getTemplateParams().get("nodeUUID");
                workspaceName = (String)activity.getTemplateParams().get("workspace");
            }
            RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            ManageableRepository manageRepo = null;
            contentNode = null;
            try {
                manageRepo = repositoryService.getCurrentRepository();
                if (StringUtils.isEmpty((String)workspaceName)) {
                    workspaceName = manageRepo.getConfiguration().getDefaultWorkspaceName();
                }
                SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
                LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                Node currentNode = sessionProvider.getSession(workspaceName, manageRepo).getNodeByUUID(nodeUUID);
                TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
                if (!trashService.isInTrash(currentNode)) {
                    contentNode = linkManager.getTarget(currentNode);
                    contentActivity.docPath = contentNode.getPath();
                    contentActivity.workspace = workspaceName;
                    contentActivity.repository = manageRepo.toString();
                } else {
                    Utils.deleteFileActivity(currentNode);
                }
            }
            catch (ItemNotFoundException infe) {
                LOG.error((Object)"Item not found. Activity will be deleted ", (Throwable)infe);
                ActivityManager activityManager = (ActivityManager)WCMCoreUtils.getService(ActivityManager.class);
                activityManager.deleteActivity(activity);
            }
            catch (RepositoryException re) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)"Can not get the repository. ", (Throwable)re);
            }
        }
        contentActivity.setActivityTitle(activity.getTitle().replace("</br></br>", ""));
        contentActivity.setContentNode(contentNode);
    }
}

