/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import org.apache.commons.chain.Context;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.AuditPropertyImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class FileUpdateActivityListener
extends Listener<Context, String> {
    private static final Log LOG = ExoLogger.getLogger(FileUpdateActivityListener.class);
    private String[] editedField = new String[]{"exo:title", "exo:summary", "exo:language", "dc:title", "dc:description", "dc:creator", "dc:source", "jcr:data"};
    private String[] bundleMessage = new String[]{"SocialIntegration.messages.editName", "SocialIntegration.messages.editSummary", "SocialIntegration.messages.editLanguage", "SocialIntegration.messages.editTitle", "SocialIntegration.messages.editDescription", "SocialIntegration.messages.singleCreator", "SocialIntegration.messages.addSource", "SocialIntegration.messages.editFile"};
    private String[] bundleRemoveMessage = new String[]{"SocialIntegration.messages.removeName", "SocialIntegration.messages.removeSummary", "SocialIntegration.messages.removeLanguage", "SocialIntegration.messages.removeTitle", "SocialIntegration.messages.removeDescription", "SocialIntegration.messages.removeCreator", "SocialIntegration.messages.addSource", "SocialIntegration.messages.editFile"};
    private boolean[] needUpdate = new boolean[]{true, true, false, true, true, false, false, true};
    private int consideredFieldCount = this.editedField.length;

    public void onEvent(Event<Context, String> event) throws Exception {
        Context context = (Context)event.getSource();
        Property currentProperty = (Property)context.get((Object)InvocationContext.CURRENT_ITEM);
        Property previousProperty = (Property)context.get((Object)InvocationContext.PREVIOUS_ITEM);
        String propertyName = (String)event.getData();
        StringBuilder oldValueBuilder = new StringBuilder();
        StringBuilder newValueBuilder = new StringBuilder();
        StringBuilder commentValueBuilder = new StringBuilder();
        Node currentNode = currentProperty.getParent();
        try {
            if (!propertyName.equals("jcr:data")) {
                if (currentProperty.getDefinition().isMultiple()) {
                    List valueList;
                    Value[] values = currentProperty.getValues();
                    if (values != null && values.length > 0) {
                        for (Value value : values) {
                            newValueBuilder.append(value.getString()).append(ActivityCommonService.METADATA_VALUE_SEPERATOR);
                            commentValueBuilder.append(value.getString()).append(", ");
                        }
                        if (newValueBuilder.length() >= ActivityCommonService.METADATA_VALUE_SEPERATOR.length()) {
                            newValueBuilder.delete(newValueBuilder.length() - ActivityCommonService.METADATA_VALUE_SEPERATOR.length(), newValueBuilder.length());
                        }
                        if (commentValueBuilder.length() >= 2) {
                            commentValueBuilder.delete(commentValueBuilder.length() - 2, commentValueBuilder.length());
                        }
                    }
                    if ((valueList = ((PersistedPropertyData)((AuditPropertyImpl)previousProperty).getData()).getValues()) != null) {
                        for (ValueData value : valueList) {
                            oldValueBuilder.append(value.toString()).append(ActivityCommonService.METADATA_VALUE_SEPERATOR);
                        }
                        if (oldValueBuilder.length() >= ActivityCommonService.METADATA_VALUE_SEPERATOR.length()) {
                            oldValueBuilder.delete(oldValueBuilder.length() - ActivityCommonService.METADATA_VALUE_SEPERATOR.length(), oldValueBuilder.length());
                        }
                    }
                } else {
                    commentValueBuilder = newValueBuilder = new StringBuilder(currentProperty.getString());
                    if (previousProperty != null && previousProperty.getValue() != null) {
                        oldValueBuilder = new StringBuilder(previousProperty.getValue().getString());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get old value");
        }
        Object newValue = newValueBuilder.toString().trim();
        String oldValue = oldValueBuilder.toString().trim();
        String commentValue = commentValueBuilder.toString().trim();
        if (currentNode.isNodeType("nt:resource")) {
            currentNode = currentNode.getParent();
        }
        String resourceBundle = "";
        boolean hit = false;
        for (int i = 0; i < this.consideredFieldCount; ++i) {
            if (!propertyName.equals(this.editedField[i])) continue;
            hit = true;
            if (((String)newValue).length() > 0) {
                Object itemsAdded;
                StringBuffer sb;
                int addedCount;
                int removedCount;
                String itemsRemoved;
                List<String> lstNew;
                List<String> lstOld;
                resourceBundle = this.bundleMessage[i];
                if (propertyName.equals("dc:creator")) {
                    lstOld = Arrays.asList(oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    lstNew = Arrays.asList(((String)newValue).split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    itemsRemoved = "";
                    removedCount = 0;
                    addedCount = 0;
                    sb = new StringBuffer();
                    for (String string : lstOld) {
                        if (lstNew.contains(string)) continue;
                        sb.append(string).append(", ");
                        ++removedCount;
                    }
                    if (sb.length() > 0) {
                        itemsRemoved = sb.toString();
                        itemsRemoved = itemsRemoved.substring(0, itemsRemoved.length() - 2);
                    }
                    sb.delete(0, sb.length());
                    itemsAdded = "";
                    for (String item : lstNew) {
                        if (lstOld.contains(item)) continue;
                        sb.append(item).append(", ");
                        ++addedCount;
                    }
                    if (sb.length() > 0) {
                        itemsAdded = sb.toString();
                        itemsAdded = ((String)itemsAdded).substring(0, ((String)itemsAdded).length() - 2);
                    }
                    if (itemsRemoved.length() > 0 && ((String)itemsAdded).length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiCreator" : "SocialIntegration.messages.removeCreator";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, itemsRemoved, "");
                        resourceBundle = lstNew.size() > 1 ? "SocialIntegration.messages.multiCreator" : "SocialIntegration.messages.singleCreator";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue, "");
                        break;
                    }
                    if (itemsRemoved.length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiCreator" : "SocialIntegration.messages.removeCreator";
                        newValue = itemsRemoved;
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, (String)newValue, "");
                        break;
                    }
                    if (((String)itemsAdded).length() > 0) {
                        resourceBundle = commentValue.split(",").length > 1 ? "SocialIntegration.messages.multiCreator" : "SocialIntegration.messages.singleCreator";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue, "");
                        break;
                    }
                }
                if (propertyName.equals("dc:source")) {
                    lstOld = Arrays.asList(oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    lstNew = Arrays.asList(((String)newValue).split(ActivityCommonService.METADATA_VALUE_SEPERATOR));
                    itemsRemoved = "";
                    removedCount = 0;
                    addedCount = 0;
                    sb = new StringBuffer();
                    for (String string : lstOld) {
                        if (lstNew.contains(string)) continue;
                        sb.append(string).append(", ");
                        ++removedCount;
                    }
                    if (sb.length() > 0) {
                        itemsRemoved = sb.toString();
                        itemsRemoved = itemsRemoved.substring(0, itemsRemoved.length() - 2);
                    }
                    sb.delete(0, sb.length());
                    itemsAdded = "";
                    for (String item : lstNew) {
                        if (lstOld.contains(item)) continue;
                        sb.append(item).append(", ");
                        ++addedCount;
                    }
                    if (sb.length() > 0) {
                        itemsAdded = sb.toString();
                        itemsAdded = ((String)itemsAdded).substring(0, ((String)itemsAdded).length() - 2);
                    }
                    if (itemsRemoved.length() > 0 && ((String)itemsAdded).length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiSource" : "SocialIntegration.messages.removeSource";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, itemsRemoved, "");
                        resourceBundle = addedCount > 1 ? "SocialIntegration.messages.addMultiSource" : "SocialIntegration.messages.addSource";
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, (String)itemsAdded, "");
                        break;
                    }
                    if (itemsRemoved.length() > 0) {
                        resourceBundle = removedCount > 1 ? "SocialIntegration.messages.removeMultiSource" : "SocialIntegration.messages.removeSource";
                        newValue = itemsRemoved;
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, (String)newValue, "");
                        break;
                    }
                    if (((String)itemsAdded).length() > 0) {
                        resourceBundle = addedCount > 1 ? "SocialIntegration.messages.addMultiSource" : "SocialIntegration.messages.addSource";
                        newValue = itemsAdded;
                        Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, (String)newValue, "");
                        break;
                    }
                }
                Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue, "");
                break;
            }
            if (propertyName.equals("exo:language")) break;
            resourceBundle = this.bundleRemoveMessage[i];
            if (propertyName.equals("dc:creator")) {
                resourceBundle = oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR).length > 1 ? "SocialIntegration.messages.removeMultiCreator" : "SocialIntegration.messages.removeCreator";
            } else if (propertyName.equals("dc:source")) {
                String string = resourceBundle = oldValue.split(ActivityCommonService.METADATA_VALUE_SEPERATOR).length > 1 ? "SocialIntegration.messages.removeMultiSource" : "SocialIntegration.messages.removeSource";
            }
            if (propertyName.equals("dc:source") || propertyName.equals("dc:creator")) {
                commentValue = oldValue.replaceAll(ActivityCommonService.METADATA_VALUE_SEPERATOR, ", ");
            }
            Utils.postFileActivity(currentNode, resourceBundle, this.needUpdate[i], true, commentValue, "");
            break;
        }
        if (!hit && propertyName.startsWith("dc:") && !propertyName.equals("dc:date")) {
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            String dcProperty = propertyName;
            try {
                dcProperty = portletRequestContext.getApplicationResourceBundle().getString("ElementSet.dialog.label." + propertyName.substring(propertyName.lastIndexOf(":") + 1, propertyName.length()));
            }
            catch (Exception ex) {
                LOG.info((Object)"Cannot get propertyName");
            }
            resourceBundle = ((String)newValue).length() > 0 ? "SocialIntegration.messages.updateMetadata" : "SocialIntegration.messages.removeMetadata";
            commentValue = dcProperty + ActivityCommonService.METADATA_VALUE_SEPERATOR + commentValue;
            Utils.postFileActivity(currentNode, resourceBundle, false, true, commentValue, "");
        }
    }
}

