/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.action;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CleanFavoriteActionUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)CleanFavoriteActionUpgradePlugin.class.getName());
    private static final String EXO_ACTIONS = "exo:actions";
    private static final String ACTION_STORAGE = "exo:actionStorage";
    private static final String ACTION_NODE_TYPE = "exo:addToFavoriteAction";
    private static final String FAVORITE_MIXIN = "exo:favoriteFolder";
    private ActionServiceContainer actionServiceContainer;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private RepositoryService repoService;

    public CleanFavoriteActionUpgradePlugin(RepositoryService repoService, ActionServiceContainer actionServiceContainer, NodeHierarchyCreator nodeHierarchyCreator, InitParams initParams) {
        super(initParams);
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.actionServiceContainer = actionServiceContainer;
        this.repoService = repoService;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        SessionProvider sessionProvider = null;
        try {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repoService.getCurrentRepository());
            String usersNodePath = this.nodeHierarchyCreator.getJcrPath("usersPath");
            if (!usersNodePath.endsWith("/")) {
                usersNodePath = usersNodePath + "/";
            }
            NodeIterator nodeIter = session.getWorkspace().getQueryManager().createQuery("SELECT * FROM exo:addToFavoriteAction WHERE jcr:path like '" + usersNodePath + "%'", "sql").execute().getNodes();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Clean unused addToFavorite count :  " + nodeIter.getSize()));
            }
            while (nodeIter.hasNext()) {
                Node favoriteActionNode = nodeIter.nextNode();
                Node actionStorageNode = favoriteActionNode.getParent();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Clean unused addToFavorite Path :  " + favoriteActionNode.getPath()));
                }
                if (actionStorageNode == null || favoriteActionNode == null) continue;
                Node favoriteNode = actionStorageNode.getParent();
                if (usersNodePath.concat(EXO_ACTIONS).equals(actionStorageNode.getPath()) || !favoriteNode.isNodeType(FAVORITE_MIXIN)) continue;
                try {
                    if (this.actionServiceContainer.getAction(favoriteNode, favoriteActionNode.getName()) != null) {
                        this.actionServiceContainer.removeAction(favoriteNode, favoriteActionNode.getName(), this.repoService.getCurrentRepository().getConfiguration().getName());
                    }
                    if (!actionStorageNode.isNodeType(ACTION_STORAGE) || actionStorageNode.getNodes().getSize() != 0L) continue;
                    actionStorageNode.remove();
                    session.save();
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to clean addToFavorite PATH= " + favoriteActionNode.getPath()), (Throwable)ex);
                }
            }
            LOG.info((Object)("End " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(((Object)((Object)this)).getClass().getName() + " Failed : "), (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }
}

