/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.pcj.map;

import com.uwyn.jhighlight.pcj.hash.DefaultCharHashFunction;
import com.uwyn.jhighlight.pcj.map.CharKeyMap;
import com.uwyn.jhighlight.pcj.map.CharKeyMapIterator;

public abstract class AbstractCharKeyMap
implements CharKeyMap {
    protected AbstractCharKeyMap() {
    }

    public void clear() {
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public Object remove(char key) {
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            Object value = i.getValue();
            i.remove();
            return value;
        }
        return null;
    }

    public void putAll(CharKeyMap map) {
        CharKeyMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(char key) {
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public Object get(char key) {
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return null;
    }

    public boolean containsValue(Object value) {
        CharKeyMapIterator i = this.entries();
        if (value == null) {
            while (i.hasNext()) {
                i.next();
                if (value != null) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                i.next();
                if (!value.equals(i.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CharKeyMap)) {
            return false;
        }
        CharKeyMap map = (CharKeyMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            char k = i.getKey();
            Object v = i.getValue();
            if (v == null) {
                if (map.get(k) != null) {
                    return false;
                }
                if (map.containsKey(k)) continue;
                return false;
            }
            if (v.equals(map.get(k))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultCharHashFunction.INSTANCE.hash(i.getKey()) ^ i.getValue().hashCode();
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }
}

