/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import javax.jcr.Node;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.UserWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.utils.JCRUtils;

@PrimaryType(name="wiki:userwikis")
public abstract class UserWikiContainer
extends WikiContainer<UserWiki> {
    @OneToOne
    @MappedBy(value="userwikis")
    public abstract WikiStoreImpl getMultiWiki();

    @Override
    public UserWiki addWiki(Wiki wiki) throws WikiException {
        UserWiki userWiki = this.getWikiObject(wiki.getOwner());
        if (userWiki == null) {
            userWiki = this.createWiki(wiki);
        }
        return userWiki;
    }

    @Override
    protected UserWiki getWikiObject(String wikiOwner) {
        Node wikiNode;
        NodeHierarchyCreator nodeHierachyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
            return null;
        }
        try {
            if (organizationService.getUserHandler().findUserByName(wikiOwner) == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        ChromatticSession session = this.mowService.getSession();
        try {
            Node tempNode = nodeHierachyCreator.getUserApplicationNode(JCRUtils.createSystemProvider(), wikiOwner);
            Node userDataNode = (Node)session.getJCRSession().getItem(tempNode.getPath());
            wikiNode = userDataNode.getNode("eXoWiki");
        }
        catch (Exception e) {
            return null;
        }
        UserWiki uwiki = (UserWiki)session.findByNode(UserWiki.class, wikiNode);
        uwiki.setUserWikis(this);
        return uwiki;
    }

    @Override
    public UserWiki createWiki(Wiki wiki) throws WikiException {
        ChromatticSession session = this.mowService.getSession();
        try {
            NodeHierarchyCreator nodeHierachyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
            Node tempNode = nodeHierachyCreator.getUserApplicationNode(JCRUtils.createSystemProvider(), wiki.getOwner());
            Node userDataNode = (Node)session.getJCRSession().getItem(tempNode.getPath());
            Node wikiNode = userDataNode.addNode("eXoWiki", "wiki:userwiki");
            userDataNode.save();
            UserWiki uwiki = (UserWiki)session.findByNode(UserWiki.class, wikiNode);
            uwiki.setUserWikis(this);
            uwiki.setOwner(wiki.getOwner());
            uwiki.getPreferences();
            if (wiki.getPermissions() != null) {
                uwiki.setWikiPermissions(JCRUtils.convertPermissionEntryListToWikiPermissions(wiki.getPermissions()));
                uwiki.setDefaultPermissionsInited(true);
            }
            session.save();
            return uwiki;
        }
        catch (Exception e) {
            throw new WikiException("Cannot create wiki " + wiki.getType() + ":" + wiki.getOwner(), e);
        }
    }
}

