/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.util.HashMap;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.util.Library;

public abstract class MarkupAnnotation
extends Annotation {
    public static final Name T_KEY = new Name("T");
    public static final Name CA_KEY = new Name("CA");
    public static final Name RC_KEY = new Name("RC");
    public static final Name CREATION_DATE_KEY = new Name("CreationDate");
    public static final Name IRT_KEY = new Name("IRT");
    public static final Name SUBJ_KEY = new Name("Subj");
    public static final Name POPUP_KEY = new Name("Popup");
    public static final Name RT_KEY = new Name("RT");
    public static final Name IT_KEY = new Name("IT");
    public static final Name EX_DATA_KEY = new Name("ExData");
    protected String titleText;
    protected PopupAnnotation popupAnnotation;
    protected float opacity = 1.0f;
    protected String richText;
    protected PDate creationDate;
    protected MarkupAnnotation inReplyToAnnotation;
    protected String subject;
    protected Name replyToRelation = new Name("R");
    protected Name intent;

    public MarkupAnnotation(Library l, HashMap h) {
        super(l, h);
    }

    public void init() {
        StringObject text;
        float ca;
        super.init();
        Object value = this.library.getObject(this.entries, T_KEY);
        if (value != null && value instanceof StringObject) {
            StringObject text2 = (StringObject)value;
            this.titleText = text2.getDecryptedLiteralString(this.securityManager);
        } else if (value instanceof String) {
            this.titleText = (String)value;
        }
        value = this.library.getObject(this.entries, POPUP_KEY);
        if (value != null && value instanceof PopupAnnotation) {
            this.popupAnnotation = (PopupAnnotation)value;
        }
        if ((ca = this.library.getFloat(this.entries, CA_KEY)) != 0.0f) {
            this.opacity = ca;
        }
        if ((value = this.library.getObject(this.entries, RC_KEY)) != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.richText = text.getDecryptedLiteralString(this.securityManager);
        } else if (value instanceof String) {
            this.richText = (String)value;
        }
        value = this.library.getObject(this.entries, CREATION_DATE_KEY);
        if (value != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.creationDate = new PDate(this.securityManager, text.getDecryptedLiteralString(this.securityManager));
        }
        if ((value = this.library.getObject(this.entries, IRT_KEY)) != null && value instanceof MarkupAnnotation) {
            this.inReplyToAnnotation = (MarkupAnnotation)value;
        }
        if ((value = this.library.getObject(this.entries, SUBJ_KEY)) != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.subject = text.getDecryptedLiteralString(this.securityManager);
        } else if (value instanceof String) {
            this.subject = (String)value;
        }
        value = this.library.getName(this.entries, RT_KEY);
        if (value != null) {
            this.replyToRelation = (Name)value;
        }
        if ((value = this.library.getName(this.entries, IT_KEY)) != null) {
            this.intent = (Name)value;
        }
    }

    public String getTitleText() {
        return this.titleText;
    }

    public PopupAnnotation getPopupAnnotation() {
        return this.popupAnnotation;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public String getRichText() {
        return this.richText;
    }

    public PDate getCreationDate() {
        return this.creationDate;
    }

    public MarkupAnnotation getInReplyToAnnotation() {
        return this.inReplyToAnnotation;
    }

    public String getSubject() {
        return this.subject;
    }

    public Name getReplyToRelation() {
        return this.replyToRelation;
    }

    public Name getIntent() {
        return this.intent;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
        this.entries.put(T_KEY, new LiteralStringObject(titleText));
    }

    public void setPopupAnnotation(PopupAnnotation popupAnnotation) {
        this.popupAnnotation = popupAnnotation;
        this.entries.put(POPUP_KEY, popupAnnotation.getPObjectReference());
    }

    public void setRichText(String richText) {
        this.richText = richText;
        this.entries.put(RC_KEY, new LiteralStringObject(richText));
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = new PDate(this.securityManager, creationDate);
        this.entries.put(CREATION_DATE_KEY, new LiteralStringObject(creationDate));
    }

    public void setInReplyToAnnotation(MarkupAnnotation inReplyToAnnotation) {
        this.inReplyToAnnotation = inReplyToAnnotation;
        this.entries.put(IRT_KEY, inReplyToAnnotation.getPObjectReference());
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.entries.put(SUBTYPE_KEY, new LiteralStringObject(subject));
    }

    public String toString() {
        return this.getTitleText();
    }
}

