/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.demos.playground.server;

import com.google.caja.demos.playground.server.AppEngineJobCacheKey;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheManager;

final class AppEngineJobCache
extends JobCache {
    private Cache l1cache;

    AppEngineJobCache() {
        try {
            this.l1cache = CacheManager.getInstance().getCacheFactory().createCache(Collections.emptyMap());
        }
        catch (Exception e) {
            this.l1cache = null;
        }
    }

    @Override
    public AppEngineJobCacheKey forJob(ContentType type, ParseTreeNode node) {
        return new AppEngineJobCacheKey(type, node);
    }

    @Override
    public List<? extends Job> fetch(JobCache.Key k) {
        if (null == this.l1cache) {
            return null;
        }
        if (!(k instanceof AppEngineJobCacheKey)) {
            return null;
        }
        List cachedJobs = (List)this.l1cache.get((Object)k);
        if (cachedJobs == null) {
            return null;
        }
        if (cachedJobs.isEmpty()) {
            return cachedJobs;
        }
        return AppEngineJobCache.cloneJobs(cachedJobs);
    }

    @Override
    public void store(JobCache.Key k, List<? extends Job> derivatives) {
        if (!(k instanceof AppEngineJobCacheKey)) {
            throw new IllegalArgumentException(k.getClass().getName());
        }
        if (null != this.l1cache) {
            try {
                this.l1cache.put((Object)k, AppEngineJobCache.cloneJobs(derivatives));
            }
            catch (Exception ex) {
                System.err.println("AppEngineJobCache#store failed: key size " + AppEngineJobCache.serialSize(k) + ", value size " + AppEngineJobCache.serialSize(derivatives) + ", " + ex);
            }
        }
    }

    private static List<Job> cloneJobs(Iterable<? extends Job> jobs) {
        List<Job> clones = Lists.newArrayList();
        for (Job job : jobs) {
            clones.add(job.clone());
        }
        return clones;
    }

    private static int serialSize(Object o) {
        CountingStream cs = new CountingStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(cs);
            oos.writeObject(o);
            oos.close();
            return cs.getCount();
        }
        catch (IOException e) {
            return -1;
        }
    }

    private static class CountingStream
    extends OutputStream {
        private int count = 0;

        private CountingStream() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void write(int b) {
            ++this.count;
        }

        @Override
        public void write(byte[] b) {
            this.count += b.length;
        }

        @Override
        public void write(byte[] b, int offset, int len) {
            this.count += len;
        }
    }
}

