/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.html;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.util.Criterion;
import com.google.caja.util.Strings;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RegularCriterion
extends Criterion<String> {
    public String toRegularExpression();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory {
        static RegularCriterion fromPattern(String regex) {
            final Pattern p = Pattern.compile(regex, 2);
            return new RegularCriterion(){

                public String toRegularExpression() {
                    StringBuilder sb = new StringBuilder();
                    sb.append('/');
                    Escaping.normalizeRegex((CharSequence)p.pattern(), sb);
                    sb.append('/');
                    if ((p.flags() & 2) != 0) {
                        sb.append('i');
                    }
                    return sb.toString();
                }

                public boolean accept(String candidate) {
                    return p.matcher(candidate).find();
                }
            };
        }

        static RegularCriterion fromValueSet(Iterable<String> values) {
            final LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
            for (String value : values) {
                valueSet.add(Strings.lower(value));
            }
            return new RegularCriterion(){

                public String toRegularExpression() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("/^(?:");
                    boolean first = true;
                    for (String value : valueSet) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append('|');
                        }
                        Escaping.escapeRegex((CharSequence)value, true, false, sb);
                    }
                    sb.append(")$/i");
                    return sb.toString();
                }

                public boolean accept(String candidate) {
                    return valueSet.contains(Strings.lower(candidate));
                }
            };
        }

        static RegularCriterion and(final RegularCriterion a, final RegularCriterion b) {
            if ("".equals(a.toRegularExpression())) {
                return b;
            }
            if ("".equals(b.toRegularExpression())) {
                return a;
            }
            return new RegularCriterion(){

                public String toRegularExpression() {
                    String ra = this.stripDelims(a.toRegularExpression());
                    String rb = this.stripDelims(b.toRegularExpression());
                    return "/^(?=" + ra + "$)(?:" + rb + "$)/i";
                }

                public boolean accept(String candidate) {
                    return a.accept(candidate) && b.accept(candidate);
                }

                private String stripDelims(String regex) {
                    if (!regex.startsWith("/") || !regex.endsWith("/i")) {
                        throw new SomethingWidgyHappenedError("Incorrect regular expression format");
                    }
                    return regex.substring(1, regex.length() - 2);
                }
            };
        }

        static RegularCriterion or(final RegularCriterion a, final RegularCriterion b) {
            return new RegularCriterion(){

                public String toRegularExpression() {
                    return "(?:" + a.toRegularExpression() + "|" + b.toRegularExpression() + ")";
                }

                public boolean accept(String candidate) {
                    return a.accept(candidate) || b.accept(candidate);
                }
            };
        }

        static RegularCriterion optimist() {
            return new RegularCriterion(){

                public String toRegularExpression() {
                    return "";
                }

                public boolean accept(String candidate) {
                    return true;
                }
            };
        }
    }
}

