/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.util.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

public abstract class FetchedData {
    protected final String contentType;
    protected final String charSet;
    private static int MAX_RESPONSE_SIZE_BYTES = 0x100000;

    protected FetchedData(String contentType, String charSet) {
        this.contentType = contentType;
        this.charSet = charSet != null ? charSet : "";
    }

    public static FetchedData fromBytes(byte[] content, String contentType, String charSet, InputSource src) {
        return new BinaryFetchedData(content, contentType, charSet, src);
    }

    public static FetchedData fromStream(InputStream is, String contentType, String charSet, InputSource src) throws IOException {
        return FetchedData.fromBytes(FetchedData.readStream(is), contentType, charSet, src);
    }

    public static FetchedData fromConnection(URLConnection connection) throws IOException {
        URI uri;
        connection.connect();
        try {
            uri = connection.getURL().toURI();
        }
        catch (URISyntaxException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
        return FetchedData.fromBytes(FetchedData.readStream(connection.getInputStream()), connection.getContentType(), FetchedData.getCharSet(connection), new InputSource(uri));
    }

    public static FetchedData fromCharProducer(CharProducer cp, String contentType, String charSet) {
        return new TextualFetchedData(cp, contentType, charSet);
    }

    public static FetchedData fromReader(Reader in, InputSource is, String contentType, String charSet) throws IOException {
        return FetchedData.fromCharProducer(CharProducer.Factory.create(in, is), contentType, charSet);
    }

    public static FetchedData fromReader(Reader in, FilePosition pos, String contentType, String charSet) throws IOException {
        return FetchedData.fromCharProducer(CharProducer.Factory.create(in, pos), contentType, charSet);
    }

    public abstract CharProducer getTextualContent() throws UnsupportedEncodingException;

    public abstract InputStream getBinaryContent() throws UnsupportedEncodingException;

    public abstract byte[] getByteContent() throws UnsupportedEncodingException;

    public String getContentType() {
        return this.contentType;
    }

    public String getCharSet() {
        return this.charSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] readStream(InputStream is) throws IOException {
        try {
            int n;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] barr = new byte[4096];
            int totalLen = 0;
            while ((n = is.read(barr)) > 0) {
                if ((totalLen += n) > MAX_RESPONSE_SIZE_BYTES) {
                    throw new IOException("Response too large");
                }
                buffer.write(barr, 0, n);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    private static String getCharSet(URLConnection conn) {
        try {
            String contentType = conn.getContentType();
            if (contentType == null) {
                return "";
            }
            String charset = new ContentType(contentType).getParameter("charset");
            return charset == null ? "" : charset;
        }
        catch (ParseException e) {
            return "";
        }
    }

    private static class TextualFetchedData
    extends FetchedData {
        private final CharProducer cp;

        public TextualFetchedData(CharProducer cp, String contentType, String charSet) {
            super(contentType, charSet);
            this.cp = cp;
        }

        public CharProducer getTextualContent() {
            return this.cp.clone();
        }

        public InputStream getBinaryContent() throws UnsupportedEncodingException {
            return new ByteArrayInputStream(this.getByteContent());
        }

        public byte[] getByteContent() throws UnsupportedEncodingException {
            return this.cp.toString().getBytes(this.charSet);
        }
    }

    private static class BinaryFetchedData
    extends FetchedData {
        private final byte[] content;
        private final InputSource src;

        BinaryFetchedData(byte[] content, String contentType, String charSet, InputSource src) {
            super(contentType, charSet);
            this.content = content;
            this.src = src;
        }

        public CharProducer getTextualContent() throws UnsupportedEncodingException {
            return CharProducer.Factory.fromString((CharSequence)new String(this.content, "".equals(this.charSet) ? Charsets.UTF_8.name() : this.charSet), this.src);
        }

        public InputStream getBinaryContent() {
            return new ByteArrayInputStream(this.content);
        }

        public byte[] getByteContent() {
            return (byte[])this.content.clone();
        }
    }
}

