/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.HtmlTextEscapingMode;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.html.BooleanAttrs;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.html.UncheckedUnrenderableException;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.SparseBitSet;
import com.google.caja.util.Strings;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

final class Renderer {
    final RenderContext rc;
    final StringBuilder out;
    final MarkupRenderMode mode;
    final boolean asXml;
    final int namespaceDepthAtStart;
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";
    private static final int COMMON_NS_DEPTH;
    private static final boolean[] CASE_SENS_NAME_CHARS;
    private static final boolean[] CASE_INSENS_NAME_CHARS;
    private static final SparseBitSet NAME_START_CHARS;
    private static final SparseBitSet NAME_CHARS;

    Renderer(RenderContext rc, StringBuilder out, MarkupRenderMode mode, Namespaces ns) {
        this.rc = rc;
        this.out = out;
        this.mode = mode;
        this.asXml = mode == MarkupRenderMode.XML;
        this.namespaceDepthAtStart = Renderer.depth(ns);
    }

    @Deprecated
    void renderUnsafe(Node node, Namespaces ns) {
        this.render(node, ns, true);
    }

    void render(Node node, Namespaces ns) {
        this.render(node, ns, false);
    }

    void renderSibs(Node sib, Namespaces ns, boolean renderUnsafe) {
        while (sib != null) {
            this.render(sib, ns, renderUnsafe);
            sib = sib.getNextSibling();
        }
    }

    void render(Node node, Namespaces ns, boolean renderUnsafe) {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                this.renderSibs(node.getFirstChild(), ns, renderUnsafe);
                break;
            }
            case 1: {
                boolean isHtml;
                String localName;
                Namespaces elNs;
                Element el = (Element)node;
                this.out.append('<');
                int tagNameStart = this.out.length();
                boolean addElNs = false;
                String nsUri = el.getNamespaceURI();
                if (nsUri == null) {
                    nsUri = HTML_NS;
                }
                if ((elNs = ns.forUri(nsUri)) == null) {
                    elNs = ns = this.addNamespace(ns, nsUri, el.getPrefix());
                    addElNs = true;
                }
                if (elNs.prefix.length() != 0) {
                    this.out.append(elNs.prefix).append(':');
                }
                if ((localName = el.getLocalName()) == null && (localName = el.getTagName()).indexOf(58) >= 0) {
                    throw new UncheckedUnrenderableException(localName);
                }
                boolean bl = isHtml = elNs.uri == HTML_NS;
                if (isHtml) {
                    localName = Strings.lower(localName);
                }
                this.out.append(localName);
                int tagNameEnd = this.out.length();
                if (addElNs) {
                    this.out.append(' ');
                    this.renderNamespace(elNs);
                } else if (elNs.prefix == "" && Nodes.hasXmlnsDeclaration(el)) {
                    this.out.append(" xmlns=\"");
                    Escaping.escapeXml((CharSequence)elNs.uri, true, this.out);
                    this.out.append('\"');
                }
                NamedNodeMap attrs = el.getAttributes();
                int n = attrs.getLength();
                for (int i = 0; i < n; ++i) {
                    Namespaces added;
                    String nsPrefix;
                    Attr a = (Attr)attrs.item(i);
                    String attrUri = a.getNamespaceURI();
                    String attrLocalName = a.getLocalName();
                    if ("http://www.w3.org/2000/xmlns/".equals(attrUri)) {
                        nsPrefix = attrLocalName;
                        added = this.addNamespaceFromAttribute(nsPrefix, a.getValue(), ns);
                        if (added == null) continue;
                        ns = added;
                    } else if (attrLocalName == null) {
                        attrLocalName = a.getName();
                        if (Renderer.isXmlnsDecl(attrLocalName)) {
                            nsPrefix = "";
                            if (attrLocalName.length() > 5) {
                                nsPrefix = attrLocalName.substring(6);
                            }
                            if ((added = this.addNamespaceFromAttribute(nsPrefix, a.getValue(), ns)) == null) continue;
                            ns = added;
                        } else if (attrLocalName.indexOf(58) >= 0) {
                            throw new UncheckedUnrenderableException(null);
                        }
                    }
                    this.out.append(' ');
                    if (attrUri != null && (attrUri = attrUri.intern()) != elNs.uri) {
                        Namespaces attrNs = ns.forUri(attrUri);
                        if (attrNs == null) {
                            attrNs = ns = this.addNamespace(ns, attrUri, a.getPrefix());
                            this.renderNamespace(attrNs);
                            this.out.append(' ');
                        }
                        this.out.append(attrNs.prefix).append(':');
                    }
                    attrLocalName = this.emitLocalName(attrLocalName, isHtml);
                    if (isHtml && this.mode == MarkupRenderMode.HTML4_BACKWARDS_COMPAT && BooleanAttrs.isBooleanAttr(attrLocalName)) continue;
                    this.out.append("=\"");
                    Escaping.escapeXml((CharSequence)a.getValue(), true, this.out);
                    this.out.append('\"');
                }
                HtmlTextEscapingMode m = HtmlTextEscapingMode.getModeForTag(localName);
                Node first = el.getFirstChild();
                if (first == null && m == HtmlTextEscapingMode.VOID) {
                    this.out.append(" />");
                    break;
                }
                this.out.append(">");
                if (m == HtmlTextEscapingMode.CDATA || m == HtmlTextEscapingMode.PLAIN_TEXT) {
                    this.renderCdata(localName, el, this.asXml);
                } else {
                    this.renderSibs(first, ns, renderUnsafe);
                }
                this.out.append("</").append(this.out, tagNameStart, tagNameEnd).append(">");
                break;
            }
            case 3: {
                Escaping.escapeXml((CharSequence)node.getNodeValue(), true, this.out);
                break;
            }
            case 4: {
                String value = node.getNodeValue();
                Escaping.escapeXml((CharSequence)value, true, this.out);
                break;
            }
            case 2: {
                Attr a = (Attr)node;
                String localName = a.getLocalName();
                if (localName == null) {
                    localName = a.getName();
                }
                this.emitLocalName(localName, HTML_NS.equals(a.getNamespaceURI()));
                this.out.append("=\"");
                Escaping.escapeXml((CharSequence)a.getValue(), true, this.out);
                this.out.append('\"');
                break;
            }
            case 7: {
                if (!this.asXml) {
                    throw new UncheckedUnrenderableException("XML not renderable as HTML due to processing instruction");
                }
                ProcessingInstruction pi = (ProcessingInstruction)node;
                String target = pi.getTarget();
                String data = pi.getData();
                if (data.contains("?>")) {
                    throw new UncheckedUnrenderableException("XML document not renderable due to \"?>\" inside processing instruction");
                }
                if (Strings.eqIgnoreCase(target.substring(0, 3), "xml") || !Renderer.isName(target)) {
                    throw new UncheckedUnrenderableException("Bad processing instruction target " + target);
                }
                this.out.append("<?").append(target).append(' ').append(data).append("?>");
                break;
            }
            case 8: {
                String commentType = node.getUserData("COMMENT_TYPE") != null ? node.getUserData("COMMENT_TYPE").toString() : HtmlTokenType.COMMENT.toString();
                String text = node.getNodeValue();
                boolean isStandardComment = HtmlTokenType.COMMENT.toString().equals(commentType);
                if (renderUnsafe && isStandardComment) {
                    String problem = null;
                    String string = problem = text.startsWith(">") ? "starts with '>'" : problem;
                    if (this.rc.markupRenderMode() != MarkupRenderMode.HTML) {
                        problem = text.startsWith("-") ? "starts with '-'" : problem;
                        problem = text.endsWith("-") ? "ends with '-'" : problem;
                    } else if (text.startsWith("-") || text.endsWith("-")) {
                        while (text.startsWith("-")) {
                            text = text.substring(1);
                        }
                        while (text.endsWith("-")) {
                            text = text.substring(0, text.length() - 1);
                        }
                    }
                    if (null != problem) {
                        throw new UncheckedUnrenderableException("XML comment unrenderable because it " + problem);
                    }
                    this.out.append("<!--");
                    this.out.append(text);
                    this.out.append("-->");
                    break;
                }
                if (isStandardComment) break;
                this.out.append(text);
            }
        }
    }

    private void renderCdata(String localName, Element el, boolean asXml) {
        StringBuilder cdata = new StringBuilder();
        block3: for (Node c = el.getFirstChild(); c != null; c = c.getNextSibling()) {
            switch (c.getNodeType()) {
                case 3: 
                case 4: {
                    String text = c.getNodeValue();
                    if (asXml) {
                        Escaping.escapeXml((CharSequence)text, true, cdata);
                        continue block3;
                    }
                    cdata.append(text);
                    continue block3;
                }
                default: {
                    cdata.append(Nodes.render(c));
                }
            }
        }
        int problemIndex = Renderer.checkHtmlCdataCloseable(localName, cdata);
        if (problemIndex != -1) {
            throw new UncheckedUnrenderableException("Document not renderable due to '" + cdata.subSequence(problemIndex, Math.min(cdata.length(), problemIndex + 10)) + "' in RAWTEXT element");
        }
        this.out.append((CharSequence)cdata);
    }

    private Namespaces addNamespace(Namespaces base, String uri, String suggestedPrefix) {
        if (this.isAlphaNumericId(suggestedPrefix) && base.forPrefix(suggestedPrefix) == null) {
            return new Namespaces(base, suggestedPrefix, uri);
        }
        return new Namespaces(base, "_ns" + (Renderer.depth(base) - COMMON_NS_DEPTH), uri);
    }

    private Namespaces addNamespaceFromAttribute(String nsPrefix, String nsUri, Namespaces ns) {
        Namespaces masked = ns.forPrefix(nsPrefix);
        if (masked != null && !masked.uri.equals(nsUri) && Renderer.depth(masked) <= this.namespaceDepthAtStart) {
            return null;
        }
        return new Namespaces(ns, nsPrefix, nsUri);
    }

    private static int depth(Namespaces ns) {
        int depth = 0;
        Namespaces p = ns;
        while (p != null) {
            ++depth;
            p = p.parent;
        }
        return depth;
    }

    private void renderNamespace(Namespaces ns) {
        this.out.append("xmlns:").append(ns.prefix).append("=\"");
        Escaping.escapeXml((CharSequence)ns.uri, true, this.out);
        this.out.append('\"');
    }

    private static boolean isXmlnsDecl(String attrName) {
        int length = attrName.length();
        if (length == 5) {
            return "xmlns".equals(attrName);
        }
        if (length > 6) {
            return attrName.startsWith("xmlns:");
        }
        return false;
    }

    private String emitLocalName(String name, boolean isHtml) {
        boolean[] simple = isHtml ? CASE_INSENS_NAME_CHARS : CASE_SENS_NAME_CHARS;
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char ch = name.charAt(i);
            if (ch <= 'z' && simple[ch]) continue;
            if (isHtml) {
                name = Strings.lower(name);
            }
            Escaping.escapeXml((CharSequence)name, true, this.out);
            return name;
        }
        this.out.append(name);
        return name;
    }

    private boolean isAlphaNumericId(String s) {
        if (s == null) {
            return false;
        }
        int n = s.length();
        if (n == 0) {
            return false;
        }
        char ch0 = s.charAt(0);
        if (!('A' <= ch0 && ch0 <= 'Z' || 'a' <= ch0 && ch0 <= 'z')) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch <= 'z' && CASE_SENS_NAME_CHARS[ch]) continue;
            return false;
        }
        return true;
    }

    private static int checkHtmlCdataCloseable(String localName, StringBuilder sb) {
        int escapingTextSpanStart = -1;
        int n = sb.length();
        block4: for (int i = 0; i < n; ++i) {
            char ch = sb.charAt(i);
            if (ch == '\u0000') {
                return i;
            }
            switch (ch) {
                case '<': {
                    if (i + 3 < n && '!' == sb.charAt(i + 1) && '-' == sb.charAt(i + 2) && '-' == sb.charAt(i + 3)) {
                        if (escapingTextSpanStart == -1) {
                            escapingTextSpanStart = i;
                            continue block4;
                        }
                        return escapingTextSpanStart;
                    }
                    if (i + 1 + localName.length() >= n || '/' != sb.charAt(i + 1) || !Strings.eqIgnoreCase(localName, sb.substring(i + 2, i + 2 + localName.length()))) continue block4;
                    if (escapingTextSpanStart < 0) {
                        return i;
                    }
                    if ("script".equals(localName)) continue block4;
                    return i;
                }
                case '>': {
                    if (i < 2 || '-' != sb.charAt(i - 1) || '-' != sb.charAt(i - 2)) continue block4;
                    if (escapingTextSpanStart < 0) {
                        return i - 2;
                    }
                    escapingTextSpanStart = -1;
                }
            }
        }
        if (escapingTextSpanStart >= 0) {
            return escapingTextSpanStart;
        }
        return -1;
    }

    private static boolean isName(String s) {
        int n = s.length();
        if (n == 0) {
            return false;
        }
        if (!NAME_START_CHARS.contains(s.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (NAME_CHARS.contains(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        int ch;
        COMMON_NS_DEPTH = Renderer.depth(Namespaces.COMMON);
        CASE_SENS_NAME_CHARS = new boolean[123];
        CASE_INSENS_NAME_CHARS = new boolean[123];
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            Renderer.CASE_INSENS_NAME_CHARS[ch] = true;
            Renderer.CASE_SENS_NAME_CHARS[ch] = true;
        }
        for (ch = 97; ch <= 122; ch = (int)((char)(ch + 1))) {
            Renderer.CASE_INSENS_NAME_CHARS[ch] = true;
            Renderer.CASE_SENS_NAME_CHARS[ch] = true;
        }
        for (ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            Renderer.CASE_SENS_NAME_CHARS[ch] = true;
        }
        NAME_START_CHARS = SparseBitSet.withRanges(58, 59, 65, 91, 95, 96, 97, 123, 192, 215, 216, 247, 767, 768, 880, 894, 895, 8192, 8204, 8206, 8304, 8592, 11264, 12272, 12289, 55296, 63744, 64976, 65008, 65534, 65536, 983040);
        NAME_CHARS = SparseBitSet.withRanges(45, 47, 48, 59, 65, 91, 95, 96, 97, 123, 183, 184, 192, 215, 216, 247, 767, 894, 895, 8192, 8204, 8206, 8255, 8257, 8304, 8592, 11264, 12272, 12289, 55296, 63744, 64976, 65008, 65534, 65536, 983040);
    }
}

