/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.NestedScope;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Block
extends AbstractStatement
implements NestedScope {
    private static final long serialVersionUID = 9160842282840140257L;

    @ParseTreeNode.ReflectiveCtor
    public Block(FilePosition pos, Void value, List<? extends Statement> children) {
        this(pos, children);
    }

    public Block(FilePosition pos, List<? extends Statement> elements) {
        super(pos, Statement.class);
        this.ctorAppendChildren(elements);
    }

    public Block(FilePosition pos) {
        super(pos, Statement.class);
    }

    public Block() {
        this(FilePosition.UNKNOWN);
    }

    public List<? extends Statement> children() {
        return this.childrenAs(Statement.class);
    }

    public void prepend(Statement statement) {
        this.insertBefore(statement, this.children().isEmpty() ? null : this.children().get(0));
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        boolean first = true;
        for (Statement statement : this.children()) {
            if (first) {
                first = false;
            } else if (statement instanceof DirectivePrologue) {
                throw new IllegalArgumentException("Misplaced directive prologoue " + statement.getFilePosition());
            }
            if (statement instanceof Statement) continue;
            throw new ClassCastException("Expected statement, not " + statement);
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void renderBlock(RenderContext rc, boolean terminate) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("{");
        this.renderBody(rc);
        out.consume("}");
    }

    public void renderBody(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        for (Statement statement : this.children()) {
            out.mark(statement.getFilePosition());
            statement.render(rc);
            if (statement.isTerminal()) continue;
            out.mark(FilePosition.endOfOrNull(statement.getFilePosition()));
            out.consume(";");
        }
        out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
    }

    @Override
    public void render(RenderContext rc) {
        this.renderBlock(rc, false);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.BlockStmt, this.getFilePosition()).addChildren(this.children()).build();
    }

    public JsonML toJsonMLAsProgram() {
        JsonMLCompatible.JsonMLBuilder builder = JsonMLCompatible.JsonMLBuilder.builder(TagType.Program, this.getFilePosition());
        for (Statement statement : this.children()) {
            if (statement instanceof DirectivePrologue && !builder.hasChildren()) {
                ((DirectivePrologue)statement).addJsonMLTo(builder);
                continue;
            }
            builder.addChild(statement);
        }
        return builder.build();
    }
}

