/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BreakStmt
extends AbstractStatement {
    private static final long serialVersionUID = -8486796747707954777L;
    private final String label;

    @ParseTreeNode.ReflectiveCtor
    public BreakStmt(FilePosition pos, String value, List<? extends ParseTreeNode> children) {
        this(pos, value);
    }

    public BreakStmt(FilePosition pos, String label) {
        super(pos, Statement.class);
        this.label = label;
    }

    @Override
    public void breaks(Map<String, List<BreakStmt>> breaksReaching) {
        List<BreakStmt> breaks = breaksReaching.get(this.label);
        if (null == breaks) {
            breaks = new ArrayList<BreakStmt>();
            breaksReaching.put(this.label, breaks);
        }
        breaks.add(this);
    }

    @Override
    public String getValue() {
        return this.label;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("break");
        if (null != this.label && !"".equals(this.label)) {
            out.consume(this.label);
        }
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.BreakStmt, this.getFilePosition()).setAttributeIfNotBlank(TagAttr.LABEL, this.label).build();
    }
}

