/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionDeclaration
extends Declaration {
    private static final long serialVersionUID = 4973243536242692075L;

    @ParseTreeNode.ReflectiveCtor
    public FunctionDeclaration(FilePosition pos, Void value, List<? extends ParseTreeNode> children) {
        super(pos, value, children);
    }

    public FunctionDeclaration(FunctionConstructor initializer) {
        super(initializer.getFilePosition(), (Identifier)initializer.getIdentifier().clone(), initializer);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        FunctionConstructor initializer = this.getInitializer();
        if (null == initializer) {
            throw new NullPointerException("Function declaration missing function");
        }
        if (!this.getIdentifierName().equals(initializer.getIdentifierName())) {
            throw new IllegalStateException("Name mismatch");
        }
    }

    @Override
    public FunctionConstructor getInitializer() {
        return (FunctionConstructor)super.getInitializer();
    }

    @Override
    public boolean isTerminal() {
        return this.getInitializer().getBody().isTerminal();
    }

    @Override
    public void render(RenderContext rc) {
        FunctionConstructor fc = this.getInitializer();
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("function");
        this.getIdentifier().render(rc);
        out.consume("(");
        boolean seen = false;
        for (FormalParam p : fc.getParams()) {
            if (seen) {
                out.consume(",");
            } else {
                seen = true;
            }
            p.render(rc);
        }
        out.consume(")");
        fc.getBody().renderBlock(rc, false);
    }

    @Override
    public JsonML toJsonML() {
        FunctionConstructor fc = this.getInitializer();
        JsonML exprJsonMl = fc.toJsonML();
        return new JsonML(TagType.FunctionDecl, exprJsonMl.getAttributes(), exprJsonMl.getChildren());
    }
}

