/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.AssignOperation;
import com.google.caja.parser.js.Associativity;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.ControlOperation;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.OperatorType;
import com.google.caja.parser.js.RealLiteral;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.SimpleOperation;
import com.google.caja.parser.js.SpecialOperation;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
extends AbstractExpression {
    private static final long serialVersionUID = -4339753364752801666L;
    private final Operator op;
    private static final Expression[] NO_EXPRESSIONS = new Expression[0];
    private static final Object UNDEFINED = new Object(){

        public String toString() {
            return "undefined";
        }
    };
    private static final long TWO_TO_THE_32 = 0x100000000L;

    protected Operation(FilePosition pos, Operator op, List<? extends Expression> params) {
        super(pos, Expression.class);
        this.op = op;
        if (null == op) {
            throw new NullPointerException();
        }
        this.ctorAppendChildren(params);
    }

    public static boolean is(ParseTreeNode n, Operator op) {
        return n instanceof Operation && op == ((Operation)n).getOperator();
    }

    public static boolean is(ParseTreeNode n, OperatorCategory cat) {
        return n instanceof Operation && cat == ((Operation)n).getOperator().getCategory();
    }

    public List<? extends Expression> children() {
        return this.childrenAs(Expression.class);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends Expression> children = this.children();
        int nChildren = children.size();
        if (nChildren < Operation.minArity(this.op)) {
            throw new IllegalArgumentException("Too few of children " + nChildren + " for operator " + (Object)((Object)this.op));
        }
        if (nChildren > Operation.maxArity(this.op)) {
            throw new IllegalArgumentException("Too many children " + nChildren + " for operator " + (Object)((Object)this.op));
        }
        if (Operator.MEMBER_ACCESS == this.op && !(children.get(1) instanceof Reference)) {
            throw new IllegalArgumentException("Bad child of . operator : " + this.children().get(1));
        }
        if (OperatorCategory.ASSIGNMENT == this.op.getCategory() && !children.get(0).isLeftHandSide()) {
            throw new IllegalArgumentException("Invalid assignment " + (Object)((Object)this.op) + " with left hand side " + children.get(0));
        }
    }

    public static Operation create(FilePosition pos, Operator op, Expression ... params) {
        switch (op.getCategory()) {
            case ASSIGNMENT: {
                return new AssignOperation(pos, op, Arrays.asList(params));
            }
            case CONTROL: {
                return new ControlOperation(pos, op, Arrays.asList(params));
            }
            case SPECIAL: {
                return new SpecialOperation(pos, op, Arrays.asList(params));
            }
            case SIMPLE: {
                return new SimpleOperation(pos, op, Arrays.asList(params));
            }
        }
        throw new SomethingWidgyHappenedError("unexpected: " + (Object)((Object)op));
    }

    public static Operation createInfix(Operator op, Expression left, Expression right) {
        assert (op.getType() == OperatorType.INFIX);
        return Operation.create(FilePosition.span(left.getFilePosition(), right.getFilePosition()), op, left, right);
    }

    public static Operation createTernary(Expression left, Expression middle, Expression right) {
        return Operation.create(FilePosition.span(left.getFilePosition(), right.getFilePosition()), Operator.TERNARY, left, middle, right);
    }

    public static Operation undefined(FilePosition pos) {
        return Operation.create(pos, Operator.VOID, new IntegerLiteral(pos, 0L));
    }

    @Override
    public Object getValue() {
        return this.op;
    }

    public Operator getOperator() {
        return this.op;
    }

    @Override
    public Expression simplifyForSideEffect() {
        switch (this.op) {
            case LOGICAL_OR: 
            case LOGICAL_AND: 
            case COMMA: {
                List<? extends Expression> operands = this.children();
                Expression sa = operands.get(0).simplifyForSideEffect();
                Expression sb = operands.get(1).simplifyForSideEffect();
                return sb == null ? sa : (sa == null ? sb : this);
            }
            case TERNARY: {
                List<? extends Expression> operands = this.children();
                if (operands.get(1).simplifyForSideEffect() == null && operands.get(2).simplifyForSideEffect() == null) {
                    return operands.get(0).simplifyForSideEffect();
                }
                return this;
            }
            case NOT: 
            case TYPEOF: {
                return this.children().get(0).simplifyForSideEffect();
            }
            case VOID: {
                return this.children().get(0).simplifyForSideEffect();
            }
            case POST_INCREMENT: {
                return Operation.create(this.getFilePosition(), Operator.PRE_INCREMENT, this.children().get(0));
            }
            case POST_DECREMENT: {
                return Operation.create(this.getFilePosition(), Operator.PRE_DECREMENT, this.children().get(0));
            }
        }
        return this;
    }

    @Override
    @Nullable
    public Boolean conditionResult() {
        List<? extends Expression> operands = this.children();
        switch (this.op) {
            case COMMA: {
                return operands.get(1).conditionResult();
            }
            case CONSTRUCTOR: {
                return true;
            }
            case FUNCTION_CALL: {
                return null;
            }
            case LOGICAL_AND: {
                Boolean opResult = operands.get(0).conditionResult();
                if (opResult != null) {
                    return opResult == false ? false : operands.get(1).conditionResult();
                }
                opResult = operands.get(1).conditionResult();
                if (opResult == null || opResult.booleanValue()) break;
                return false;
            }
            case LOGICAL_OR: {
                Boolean opResult = operands.get(0).conditionResult();
                if (opResult != null) {
                    return opResult != false ? true : operands.get(1).conditionResult();
                }
                opResult = operands.get(1).conditionResult();
                if (opResult == null || !opResult.booleanValue()) break;
                return true;
            }
            case TERNARY: {
                Boolean opResult = operands.get(0).conditionResult();
                if (opResult != null) {
                    return operands.get(opResult != false ? 1 : 2).conditionResult();
                }
                Boolean a = operands.get(1).conditionResult();
                Boolean b = operands.get(2).conditionResult();
                return a != null && a.equals(b) ? a : null;
            }
            case NOT: {
                Boolean opResult = operands.get(0).conditionResult();
                return opResult != null ? Boolean.valueOf(opResult == false) : null;
            }
            case VOID: {
                return false;
            }
        }
        return null;
    }

    @Override
    public boolean isLeftHandSide() {
        switch (this.op) {
            case MEMBER_ACCESS: 
            case SQUARE_BRACKET: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        block0 : switch (this.op.getType()) {
            case PREFIX: {
                int n;
                out.consume(this.op.getSymbol());
                this.renderParam(0, rc);
                if (this.op != Operator.CONSTRUCTOR || 1 >= (n = this.children().size())) break;
                out.consume("(");
                for (int k = 1; k < n; ++k) {
                    if (1 < k) {
                        out.consume(",");
                    }
                    this.renderParam(k, rc);
                }
                out.consume(")");
                break;
            }
            case POSTFIX: {
                this.renderParam(0, rc);
                out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
                out.consume(this.op.getSymbol());
                break;
            }
            case INFIX: {
                this.renderParam(0, rc);
                switch (this.getOperator()) {
                    default: {
                        out.consume(" ");
                        out.consume(this.op.getSymbol());
                        out.consume(" ");
                        this.renderParam(1, rc);
                        break block0;
                    }
                    case MEMBER_ACCESS: {
                        this.renderMemberAccess(rc);
                        break block0;
                    }
                    case COMMA: 
                }
                out.consume(this.op.getSymbol());
                this.renderParam(1, rc);
                break;
            }
            case BRACKET: {
                this.renderParam(0, rc);
                out.consume(this.op.getOpeningSymbol());
                boolean seen = false;
                for (Expression expression : this.children().subList(1, this.children().size())) {
                    if (seen) {
                        out.consume(",");
                    } else {
                        seen = true;
                    }
                    if (!Operation.parenthesize(Operator.COMMA, false, expression)) {
                        expression.render(rc);
                        continue;
                    }
                    out.consume("(");
                    expression.render(rc);
                    out.mark(FilePosition.endOfOrNull(expression.getFilePosition()));
                    out.consume(")");
                }
                out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
                out.consume(this.op.getClosingSymbol());
                break;
            }
            case TERNARY: {
                this.renderParam(0, rc);
                out.consume(this.op.getOpeningSymbol());
                out.consume(" ");
                this.renderParam(1, rc);
                out.consume(this.op.getClosingSymbol());
                out.consume(" ");
                this.renderParam(2, rc);
            }
        }
    }

    private void renderParam(int i, RenderContext rc) {
        TokenConsumer out = rc.getOut();
        ParseTreeNode e = this.children().get(i);
        out.mark(e.getFilePosition());
        if (!Operation.parenthesize(this.op, 0 == i, (Expression)e)) {
            e.render(rc);
        } else {
            out.consume("(");
            e.render(rc);
            out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
            out.consume(")");
        }
    }

    private void renderMemberAccess(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        if (this.isKeywordAccess()) {
            out.consume(Operator.SQUARE_BRACKET.getOpeningSymbol());
            StringLiteral.renderUnquotedValue(this.getMemberName(), rc);
            out.consume(Operator.SQUARE_BRACKET.getClosingSymbol());
        } else {
            out.consume(this.op.getSymbol());
            this.renderParam(1, rc);
        }
    }

    private boolean isKeywordAccess() {
        return this.getOperator() == Operator.MEMBER_ACCESS && this.children().get(1) instanceof Reference && this.isKeyword(this.getMemberName());
    }

    private String getMemberName() {
        return ((Reference)this.children().get(1)).getIdentifierName();
    }

    private boolean isKeyword(String name) {
        return Keyword.fromString(name) != null;
    }

    private static boolean parenthesize(Operator op, boolean firstOp, Expression child) {
        boolean isDividend;
        if (child instanceof FunctionConstructor || child instanceof ObjectConstructor) {
            return firstOp;
        }
        if (child instanceof NumberLiteral) {
            if (firstOp && op == Operator.MEMBER_ACCESS) {
                return true;
            }
            if (OperatorType.PREFIX == op.getType()) {
                return ((NumberLiteral)child).getValue().doubleValue() < 0.0;
            }
        }
        boolean bl = isDividend = firstOp && (op == Operator.DIVISION || op == Operator.ASSIGN_DIV);
        if (isDividend && !(child instanceof Reference) && !(child instanceof NumberLiteral) && !(child instanceof Operation)) {
            return true;
        }
        if (!(child instanceof Operation)) {
            return false;
        }
        Operator childOp = ((Operation)child).getOperator();
        if (firstOp) {
            if (childOp == Operator.FUNCTION_CALL && op == Operator.MEMBER_ACCESS) {
                return false;
            }
            if (isDividend && childOp != Operator.FUNCTION_CALL && childOp != Operator.MEMBER_ACCESS) {
                return true;
            }
            if (childOp == Operator.POST_DECREMENT) {
                switch (op) {
                    case ASSIGN_RSH: 
                    case ASSIGN_USH: 
                    case RSHIFT: 
                    case RUSHIFT: 
                    case GREATER_THAN: 
                    case GREATER_EQUALS: {
                        return true;
                    }
                }
            }
        }
        if (op == Operator.FUNCTION_CALL && firstOp && childOp == Operator.CONSTRUCTOR && child.children().size() == 1) {
            return true;
        }
        int delta = op.getPrecedence() - childOp.getPrecedence();
        if (delta < 0) {
            return true;
        }
        if (delta == 0) {
            if (op.getType() == OperatorType.PREFIX) {
                if (op == Operator.CONSTRUCTOR) {
                    return Operation.mightHaveParenthesesStealableByNew((Operation)child);
                }
                return false;
            }
            return childOp.getAssociativity() == Associativity.LEFT != firstOp;
        }
        return false;
    }

    private static int minArity(Operator op) {
        if (op == Operator.FUNCTION_CALL) {
            return 1;
        }
        if (op == Operator.CONSTRUCTOR) {
            return 1;
        }
        return op.getType().getArity();
    }

    private static int maxArity(Operator op) {
        if (op == Operator.FUNCTION_CALL) {
            return Integer.MAX_VALUE;
        }
        if (op == Operator.CONSTRUCTOR) {
            return Integer.MAX_VALUE;
        }
        return op.getType().getArity();
    }

    @Override
    public String typeOf() {
        List<? extends Expression> operands = this.children();
        switch (this.getOperator()) {
            case ASSIGN_RSH: 
            case ASSIGN_USH: 
            case RSHIFT: 
            case RUSHIFT: 
            case PRE_INCREMENT: 
            case PRE_DECREMENT: 
            case TO_NUMBER: 
            case NEGATION: 
            case INVERSE: 
            case MULTIPLICATION: 
            case DIVISION: 
            case MODULUS: 
            case SUBTRACTION: 
            case LSHIFT: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_SUB: 
            case ASSIGN_LSH: 
            case ASSIGN_AND: 
            case ASSIGN_XOR: 
            case ASSIGN_OR: {
                return "number";
            }
            case NOT: 
            case GREATER_THAN: 
            case GREATER_EQUALS: 
            case DELETE: 
            case IN: 
            case LESS_THAN: 
            case LESS_EQUALS: 
            case INSTANCE_OF: 
            case EQUAL: 
            case NOT_EQUAL: 
            case STRICTLY_EQUAL: 
            case STRICTLY_NOT_EQUAL: {
                return "boolean";
            }
            case VOID: {
                return "undefined";
            }
            case LOGICAL_OR: 
            case LOGICAL_AND: 
            case TERNARY: {
                String t1 = operands.get(operands.size() - 2).typeOf();
                String t2 = operands.get(operands.size() - 1).typeOf();
                return t1 != null && t1.equals(t2) ? t1 : null;
            }
            case ADDITION: {
                String t1 = operands.get(operands.size() - 2).typeOf();
                String t2 = operands.get(operands.size() - 1).typeOf();
                if ("string".equals(t1) || "string".equals(t2)) {
                    return "string";
                }
                if ("number".equals(t1) && "number".equals(t2)) {
                    return "number";
                }
                return null;
            }
            case TYPEOF: {
                return "string";
            }
            case COMMA: {
                return operands.get(1).typeOf();
            }
        }
        return null;
    }

    @Override
    public Expression fold(boolean isFn) {
        Expression folded;
        if (this.getOperator() == Operator.FUNCTION_CALL) {
            return this.foldCall();
        }
        switch (this.children().size()) {
            case 1: {
                folded = this.foldUnaryOp();
                break;
            }
            case 2: {
                folded = this.foldBinaryOp();
                break;
            }
            case 3: {
                folded = this.foldTernaryOp();
                break;
            }
            default: {
                return this;
            }
        }
        if (isFn && Operation.isFnSpecialForm(folded) && !Operation.isFnSpecialForm(this)) {
            FilePosition pos = this.getFilePosition();
            folded = Operation.create(pos, Operator.COMMA, new IntegerLiteral(FilePosition.startOf(pos), 0L), folded);
        }
        return folded;
    }

    private Expression foldUnaryOp() {
        Expression operand = this.children().get(0);
        switch (this.op) {
            case NOT: {
                Boolean b = operand.conditionResult();
                if (b != null && operand.simplifyForSideEffect() == null) {
                    return new BooleanLiteral(this.getFilePosition(), b == false);
                }
                if (operand instanceof Operation) {
                    Operator negation;
                    Operation opr = (Operation)operand;
                    switch (opr.getOperator()) {
                        case NOT_EQUAL: {
                            negation = Operator.EQUAL;
                            break;
                        }
                        case EQUAL: {
                            negation = Operator.NOT_EQUAL;
                            break;
                        }
                        case STRICTLY_NOT_EQUAL: {
                            negation = Operator.STRICTLY_EQUAL;
                            break;
                        }
                        case STRICTLY_EQUAL: {
                            negation = Operator.STRICTLY_NOT_EQUAL;
                            break;
                        }
                        default: {
                            negation = null;
                        }
                    }
                    if (negation != null) {
                        return Operation.create(this.getFilePosition(), negation, opr.children().toArray(NO_EXPRESSIONS));
                    }
                }
                return this;
            }
            case TYPEOF: {
                String type = operand.typeOf();
                if (type != null && operand.simplifyForSideEffect() == null) {
                    return StringLiteral.valueOf(this.getFilePosition(), type);
                }
                return this;
            }
        }
        Object v = Operation.toLiteralValue(operand);
        if (v != null) {
            FilePosition pos = this.getFilePosition();
            switch (this.getOperator()) {
                case NEGATION: {
                    long n;
                    if (!(v instanceof Number)) break;
                    if (operand instanceof IntegerLiteral && (n = ((IntegerLiteral)operand).getValue().longValue()) != Long.MIN_VALUE && n != 0L) {
                        return new IntegerLiteral(pos, -n);
                    }
                    return new RealLiteral(pos, -((Number)v).doubleValue());
                }
                case INVERSE: {
                    if (!(v instanceof Number)) break;
                    return new IntegerLiteral(pos, ((Number)v).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                }
                case TO_NUMBER: {
                    if (!(v instanceof Number)) break;
                    return this.children().get(0);
                }
            }
        }
        return this;
    }

    private Expression foldTernaryOp() {
        Expression cond;
        Boolean condResult;
        if (this.getOperator() == Operator.TERNARY && (condResult = (cond = this.children().get(0)).conditionResult()) != null && cond.simplifyForSideEffect() == null) {
            return this.children().get(condResult != false ? 1 : 2);
        }
        return this;
    }

    private Expression foldBinaryOp() {
        List<? extends Expression> operands = this.children();
        Expression left = operands.get(0);
        Expression right = operands.get(1);
        Operator op = this.getOperator();
        if (op == Operator.LOGICAL_AND || op == Operator.LOGICAL_OR) {
            Boolean bv = left.conditionResult();
            if (bv != null) {
                Expression sideEffect = left.simplifyForSideEffect();
                if (bv == (op == Operator.LOGICAL_AND)) {
                    return sideEffect == null ? right : Operation.createInfix(Operator.COMMA, sideEffect, right);
                }
                return left;
            }
            bv = right.conditionResult();
            if (bv != null && bv == (op == Operator.LOGICAL_AND) && "boolean".equals(left.typeOf()) && "boolean".equals(right.typeOf()) && right.simplifyForSideEffect() == null) {
                return left;
            }
        } else if (op == Operator.MEMBER_ACCESS) {
            Reference r;
            if (left instanceof StringLiteral && "length".equals((r = (Reference)right).getIdentifierName())) {
                return new IntegerLiteral(this.getFilePosition(), ((StringLiteral)left).getUnquotedValue().length());
            }
        } else if (op == Operator.COMMA && left.simplifyForSideEffect() == null) {
            return right;
        }
        Object lhs = Operation.toLiteralValue(left);
        Object rhs = Operation.toLiteralValue(right);
        if (lhs != null && rhs != null) {
            FilePosition pos = this.getFilePosition();
            switch (op) {
                case EQUAL: 
                case NOT_EQUAL: 
                case STRICTLY_EQUAL: 
                case STRICTLY_NOT_EQUAL: {
                    boolean isStrict = op == Operator.STRICTLY_EQUAL || op == Operator.STRICTLY_NOT_EQUAL;
                    boolean isEqual = op == Operator.EQUAL || op == Operator.STRICTLY_EQUAL;
                    boolean areEqual = lhs.equals(rhs);
                    if (!isStrict && !areEqual && !lhs.getClass().equals(rhs.getClass())) break;
                    return new BooleanLiteral(pos, areEqual == isEqual);
                }
                case ADDITION: {
                    if (!(lhs instanceof String) && !(rhs instanceof String)) break;
                    if (lhs instanceof Number) {
                        lhs = NumberLiteral.numberToString(((Number)lhs).doubleValue());
                    } else if (rhs instanceof Number) {
                        rhs = NumberLiteral.numberToString(((Number)rhs).doubleValue());
                    }
                    return StringLiteral.valueOf(pos, "" + lhs + rhs);
                }
            }
            if (lhs instanceof Number && rhs instanceof Number) {
                double result;
                double a = ((Number)lhs).doubleValue();
                double b = ((Number)rhs).doubleValue();
                if (Operation.isIntOp(op)) {
                    long result2;
                    switch (op) {
                        case BITWISE_AND: {
                            result2 = Operation.toInt32(a) & Operation.toInt32(b);
                            break;
                        }
                        case BITWISE_OR: {
                            result2 = Operation.toInt32(a) | Operation.toInt32(b);
                            break;
                        }
                        case BITWISE_XOR: {
                            result2 = Operation.toInt32(a) ^ Operation.toInt32(b);
                            break;
                        }
                        case LSHIFT: {
                            result2 = Operation.toInt32(a) << (int)Operation.toUint32(b);
                            break;
                        }
                        case RSHIFT: {
                            result2 = Operation.toInt32(a) >> (int)Operation.toUint32(b);
                            break;
                        }
                        case RUSHIFT: {
                            result2 = Operation.toUint32(a) >>> (int)Operation.toUint32(b);
                            break;
                        }
                        default: {
                            return this;
                        }
                    }
                    return new IntegerLiteral(pos, result2);
                }
                switch (op) {
                    case ADDITION: {
                        result = a + b;
                        break;
                    }
                    case SUBTRACTION: {
                        result = a - b;
                        break;
                    }
                    case MULTIPLICATION: {
                        result = a * b;
                        break;
                    }
                    case DIVISION: {
                        result = a / b;
                        break;
                    }
                    case MODULUS: {
                        result = Math.IEEEremainder(a, b);
                        break;
                    }
                    default: {
                        return this;
                    }
                }
                return new RealLiteral(pos, result);
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression foldCall() {
        List<? extends Expression> operands = this.children();
        Expression fn = operands.get(0);
        if (fn instanceof FunctionConstructor) {
            FunctionConstructor fc;
            if (operands.size() != 1 || !(fc = (FunctionConstructor)fn).getParams().isEmpty() || fc.getIdentifierName() != null) return this;
            switch (fc.getBody().children().size()) {
                case 0: {
                    return Operation.undefined(this.getFilePosition());
                }
                case 1: {
                    Expression e;
                    Statement s = fc.getBody().children().get(0);
                    if (s instanceof ReturnStmt) {
                        Expression e2 = ((ReturnStmt)s).getReturnValue();
                        if (e2 == null) {
                            return Operation.undefined(this.getFilePosition());
                        }
                        if (Operation.mentionsThisOrArguments(e2)) return this;
                        return e2;
                    }
                    if (!(s instanceof ExpressionStmt) || Operation.mentionsThisOrArguments(e = ((ExpressionStmt)s).getExpression())) return this;
                    return Operation.create(this.getFilePosition(), Operator.VOID, e);
                }
            }
            return this;
        } else {
            Expression target;
            if (!Operation.is((ParseTreeNode)fn, Operator.MEMBER_ACCESS) || !(fn.children().get(0) instanceof StringLiteral)) return this;
            StringLiteral sl = (StringLiteral)fn.children().get(0);
            String methodName = ((Reference)fn.children().get(1)).getIdentifierName();
            if (!"indexOf".equals(methodName) || operands.size() != 2 || !((target = operands.get(1)) instanceof StringLiteral)) return this;
            int index = sl.getUnquotedValue().indexOf(((StringLiteral)target).getUnquotedValue());
            return new IntegerLiteral(this.getFilePosition(), index);
        }
    }

    private static Object toLiteralValue(Expression e) {
        if (Operation.is((ParseTreeNode)e, Operator.VOID) && e.simplifyForSideEffect() == null) {
            return UNDEFINED;
        }
        if (e instanceof Literal) {
            if (e instanceof StringLiteral) {
                return ((StringLiteral)e).getUnquotedValue();
            }
            if (e instanceof NumberLiteral) {
                return ((NumberLiteral)e).doubleValue();
            }
            if (e instanceof BooleanLiteral || e instanceof NullLiteral) {
                return e.getValue();
            }
        }
        return null;
    }

    private static boolean isIntOp(Operator op) {
        switch (op) {
            case RSHIFT: 
            case RUSHIFT: 
            case LSHIFT: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: {
                return true;
            }
        }
        return false;
    }

    static long toInt32(double number) {
        number = number < 0.0 ? Math.ceil(number) : Math.floor(number);
        double int32bit = number % 4.294967296E9;
        return (int)int32bit;
    }

    static long toUint32(double number) {
        number = number < 0.0 ? Math.ceil(number) : Math.floor(number);
        double int32bit = number % 4.294967296E9;
        return (long)int32bit & 0xFFFFFFFFL;
    }

    private static boolean mentionsThisOrArguments(Expression e) {
        if (e instanceof Reference) {
            String s = ((Reference)e).getIdentifierName();
            return "this".equals(s) || "arguments".equals(s);
        }
        if (e instanceof FunctionConstructor) {
            return false;
        }
        for (ParseTreeNode parseTreeNode : e.children()) {
            if (!(parseTreeNode instanceof Expression) || !Operation.mentionsThisOrArguments((Expression)parseTreeNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFnSpecialForm(Expression e) {
        if (e instanceof Reference) {
            Reference r = (Reference)e;
            return "eval".equals(r.getIdentifierName());
        }
        if (e instanceof Operation) {
            Operator op = ((Operation)e).getOperator();
            return Operator.MEMBER_ACCESS == op || Operator.SQUARE_BRACKET == op;
        }
        return false;
    }

    private static boolean mightHaveParenthesesStealableByNew(Operation oper) {
        int lastToCheck;
        Operator op = oper.getOperator();
        if (op == Operator.FUNCTION_CALL) {
            return true;
        }
        if (op.getPrecedence() > Operator.CONSTRUCTOR.getPrecedence()) {
            return false;
        }
        switch (op) {
            case SQUARE_BRACKET: {
                lastToCheck = 1;
                break;
            }
            case MEMBER_ACCESS: {
                lastToCheck = 2;
                break;
            }
            default: {
                return true;
            }
        }
        for (int i = 0; i < lastToCheck; ++i) {
            Expression child = oper.children().get(i);
            if (!(child instanceof Operation) || !Operation.mightHaveParenthesesStealableByNew((Operation)child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonML toJsonML() {
        FilePosition pos = this.getFilePosition();
        List<? extends Expression> operands = this.children();
        int n = operands.size();
        switch (this.op) {
            case CONSTRUCTOR: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.NewExpr, pos).addChildren(operands).build();
            }
            case FUNCTION_CALL: {
                Expression fn = operands.get(0);
                if (Operation.is((ParseTreeNode)fn, Operator.MEMBER_ACCESS) || Operation.is((ParseTreeNode)fn, Operator.SQUARE_BRACKET)) {
                    Operation method = (Operation)fn;
                    JsonML methodName = Operation.is((ParseTreeNode)fn, Operator.MEMBER_ACCESS) ? ((Reference)method.children().get(1)).toJsonMLStr() : method.children().get(1).toJsonML();
                    return JsonMLCompatible.JsonMLBuilder.builder(TagType.InvokeExpr, pos).setAttribute(TagAttr.OP, method.getOperator().getSymbol()).addChild(method.children().get(0)).addChild(methodName).addChildren(operands.subList(1, n)).build();
                }
                if (fn instanceof Reference && "eval".equals(((Reference)fn).getIdentifierName())) {
                    return JsonMLCompatible.JsonMLBuilder.builder(TagType.EvalExpr, pos).addChildren(operands.subList(1, n)).build();
                }
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.CallExpr, pos).addChildren(operands).build();
            }
            case MEMBER_ACCESS: 
            case SQUARE_BRACKET: {
                JsonML property = this.op == Operator.MEMBER_ACCESS ? ((Reference)operands.get(1)).toJsonMLStr() : operands.get(1).toJsonML();
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.MemberExpr, pos).setAttribute(TagAttr.OP, this.op.getSymbol()).addChild(operands.get(0)).addChild(property).build();
            }
            case POST_INCREMENT: 
            case POST_DECREMENT: 
            case PRE_INCREMENT: 
            case PRE_DECREMENT: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.CountExpr, pos).setAttribute(TagAttr.OP, this.op.getSymbol()).setAttribute(TagAttr.IS_PREFIX, this.op.getType() == OperatorType.PREFIX).addChildren(operands).build();
            }
            case DELETE: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.DeleteExpr, pos).addChildren(operands).build();
            }
            case NOT: 
            case VOID: 
            case TO_NUMBER: 
            case NEGATION: 
            case INVERSE: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.UnaryExpr, pos).setAttribute(TagAttr.OP, this.op.getSymbol()).addChildren(operands).build();
            }
            case TYPEOF: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.TypeofExpr, pos).addChildren(operands).build();
            }
            case COMMA: 
            case RSHIFT: 
            case RUSHIFT: 
            case GREATER_THAN: 
            case GREATER_EQUALS: 
            case MULTIPLICATION: 
            case DIVISION: 
            case MODULUS: 
            case SUBTRACTION: 
            case LSHIFT: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: 
            case IN: 
            case LESS_THAN: 
            case LESS_EQUALS: 
            case INSTANCE_OF: 
            case EQUAL: 
            case NOT_EQUAL: 
            case STRICTLY_EQUAL: 
            case STRICTLY_NOT_EQUAL: 
            case ADDITION: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.BinaryExpr, pos).setAttribute(TagAttr.OP, this.op.getSymbol()).addChildren(operands).build();
            }
            case LOGICAL_AND: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.LogicalAndExpr, pos).addChildren(operands).build();
            }
            case LOGICAL_OR: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.LogicalOrExpr, pos).addChildren(operands).build();
            }
            case TERNARY: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.ConditionalExpr, pos).addChildren(operands).build();
            }
            case ASSIGN_RSH: 
            case ASSIGN_USH: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_SUB: 
            case ASSIGN_LSH: 
            case ASSIGN_AND: 
            case ASSIGN_XOR: 
            case ASSIGN_OR: 
            case ASSIGN: 
            case ASSIGN_SUM: {
                return JsonMLCompatible.JsonMLBuilder.builder(TagType.AssignExpr, pos).setAttribute(TagAttr.OP, this.op.getSymbol()).addChildren(operands).build();
            }
        }
        throw new SomethingWidgyHappenedError(this.op.toString());
    }
}

