/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleChain;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rewriter {
    private final RuleChain rules = new RuleChain();
    private final Set<String> ruleNames = new HashSet<String>();
    private final Set<ParseTreeNode> tainted = new HashSet<ParseTreeNode>();
    private final Set<ParseTreeNode> forSideEffect = new HashSet<ParseTreeNode>();
    final MessageQueue mq;
    private final boolean taintChecking;
    private final boolean logging;

    public Rewriter(MessageQueue mq, boolean taintChecking, boolean logging) {
        assert (mq != null);
        this.mq = mq;
        this.taintChecking = taintChecking;
        this.logging = logging;
    }

    public Iterable<? extends Rule> getRules() {
        return this.rules.getAllRules();
    }

    protected final ParseTreeNode expand(ParseTreeNode node, Scope scope) {
        boolean debug = false;
        List<Rule> run = debug ? this.rules.getAllRules() : this.rules.applicableTo(node);
        for (Rule rule : run) {
            try {
                ParseTreeNode result = rule.fire(node, scope);
                if (result == Rule.NONE) continue;
                if (debug && !this.rules.applicableTo(node).contains(rule)) {
                    throw new SomethingWidgyHappenedError(rule.getName() + " should be applicable to " + node);
                }
                if (this.logging) {
                    this.logResults(rule, node, result, null);
                }
                result.makeImmutable();
                return result;
            }
            catch (RuntimeException ex) {
                if (this.logging) {
                    this.logResults(rule, node, null, ex);
                }
                throw ex;
            }
        }
        this.mq.addMessage((MessageTypeInt)RewriterMessageType.UNMATCHED_NODE_LEFT_OVER, node.getFilePosition(), node);
        return node;
    }

    public void addRule(Rule rule) {
        if (!this.ruleNames.add(rule.getName())) {
            throw new IllegalArgumentException("Duplicate rule name: " + rule.getName());
        }
        this.rules.add(rule);
        rule.setRewriter(this);
    }

    public void addRules(Rule[] rules) {
        for (Rule r : rules) {
            this.addRule(r);
        }
    }

    private void logResults(Rule rule, ParseTreeNode input, ParseTreeNode result, Exception exception) {
        StringBuilder s = new StringBuilder();
        s.append("-----------------------------------------------------------------------\n");
        if (rule != null) {
            s.append("rule: ").append(rule.getName()).append("\n");
        }
        if (input != null) {
            s.append("input: (").append(input.getClass().getSimpleName()).append(") ").append(Rewriter.render(input)).append("\n");
        }
        if (result != null) {
            s.append("result: (").append(result.getClass().getSimpleName()).append(") ").append(Rewriter.render(result)).append("\n");
        }
        if (exception != null) {
            s.append("error: ").append(exception.toString()).append("\n");
        }
        System.err.println(s.toString());
    }

    public static String render(ParseTreeNode n) {
        StringBuilder output = new StringBuilder();
        JsPrettyPrinter renderer = new JsPrettyPrinter(output);
        n.render(new RenderContext(renderer));
        renderer.noMoreTokens();
        return output.toString();
    }

    public final ParseTreeNode expand(ParseTreeNode node) {
        this.tainted.clear();
        this.forSideEffect.clear();
        node.makeImmutable();
        if (this.taintChecking) {
            this.flagTainted(node, this.mq);
            ParseTreeNode result = this.expand(node, null);
            if (!this.mq.hasMessageAtLevel(MessageLevel.ERROR)) {
                this.checkTainted(result, this.mq);
            }
            result.makeImmutable();
            return result;
        }
        return this.expand(node, null);
    }

    private void flagTainted(ParseTreeNode node, MessageQueue mq) {
        if (this.tainted.contains(node)) {
            mq.addMessage((MessageTypeInt)RewriterMessageType.MULTIPLY_TAINTED, node, node.getFilePosition());
        }
        this.tainted.add(node);
        for (ParseTreeNode parseTreeNode : node.children()) {
            this.flagTainted(parseTreeNode, mq);
        }
    }

    private boolean checkTainted(ParseTreeNode node, MessageQueue mq) {
        if (this.tainted.contains(node) && !SyntheticNodes.is(node)) {
            mq.addMessage((MessageTypeInt)RewriterMessageType.UNSEEN_NODE_LEFT_OVER, node, node.getFilePosition());
            return false;
        }
        for (ParseTreeNode parseTreeNode : node.children()) {
            if (this.checkTainted(parseTreeNode, mq)) continue;
            return false;
        }
        return true;
    }

    private <T extends ParseTreeNode> T removeTaint(T node) {
        if (this.taintChecking) {
            this.tainted.remove(node);
        }
        return node;
    }

    protected <T extends ParseTreeNode> T noexpand(T node) {
        return this.removeTaint(node);
    }

    protected Reference noexpand(Reference node) {
        this.removeTaint(node.getIdentifier());
        return this.removeTaint(node);
    }

    protected Declaration noexpand(Declaration node) {
        if (node.getInitializer() != null) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.NOEXPAND_BINARY_DECL, node.getFilePosition(), node);
            return node;
        }
        this.removeTaint(node.getIdentifier());
        return this.removeTaint(node);
    }

    protected ParseTreeNodeContainer noexpandParams(ParseTreeNodeContainer node) {
        if (this.taintChecking) {
            for (ParseTreeNode parseTreeNode : node.children()) {
                this.noexpand((Declaration)parseTreeNode);
            }
            return this.removeTaint(node);
        }
        return node;
    }

    protected void setTaint(ParseTreeNode node) {
        this.tainted.add(node);
    }

    protected void clearTaint(ParseTreeNode node) {
        this.tainted.remove(node);
    }

    public void markForSideEffect(ParseTreeNode node) {
        this.forSideEffect.add(node);
    }

    public void markTreeForSideEffect(ParseTreeNode node) {
        if (node instanceof Statement) {
            node.makeImmutable();
            this.markForSideEffect(node);
            for (ParseTreeNode parseTreeNode : node.children()) {
                this.markTreeForSideEffect(parseTreeNode);
            }
        }
    }

    public boolean isForSideEffect(ParseTreeNode node) {
        return this.forSideEffect.contains(node);
    }
}

