/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.UriFetcher;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.binary.Base64;

public class DataUriFetcher
implements UriFetcher {
    private static final Pattern DATA_URI_RE = Pattern.compile("([^,]*?)(;base64)?,(.*)", 34);
    private static final String DATA_URI_DEFAULT_CHARSET = "US-ASCII";

    private boolean isDataUri(URI uri) {
        return null != uri && "data".equals(uri.getScheme()) && uri.isOpaque();
    }

    private String charsetFromMime(String mime) {
        String charset;
        try {
            ContentType parsedType = new ContentType(mime);
            charset = parsedType.getParameter("charset");
        }
        catch (ParseException e) {
            charset = null;
        }
        if (null == charset || "".equals(charset)) {
            return DATA_URI_DEFAULT_CHARSET;
        }
        return charset;
    }

    public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
        byte[] raw = this.fetchBinary(ref, mimeType);
        return FetchedData.fromBytes(raw, mimeType, this.charsetFromMime(mimeType), new InputSource(ref.getUri()));
    }

    public final byte[] fetchBinary(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
        URI uri = ref.getUri();
        if (!this.isDataUri(uri)) {
            throw new UriFetcher.UriFetchException(ref, mimeType);
        }
        String dataUri = uri.getSchemeSpecificPart();
        Matcher m = DATA_URI_RE.matcher(dataUri);
        if (m.find()) {
            try {
                String charset = this.charsetFromMime(m.group(DATA_URI.TYPE.ordinal()));
                boolean base64 = null != m.group(DATA_URI.BASE64.ordinal());
                byte[] encoded = m.group(DATA_URI.DATA.ordinal()).getBytes(charset);
                byte[] decoded = base64 ? new Base64().decode(encoded) : encoded;
                return decoded;
            }
            catch (UnsupportedEncodingException e) {
                throw new UriFetcher.UriFetchException(ref, mimeType, e);
            }
        }
        throw new UriFetcher.UriFetchException(ref, mimeType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DATA_URI {
        ALL,
        TYPE,
        BASE64,
        DATA;

    }
}

