/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.util.ContentType;
import java.io.Serializable;
import java.net.URI;

public final class Job
implements Serializable {
    private static final long serialVersionUID = -8600982817211362662L;
    private final ParseTreeNode root;
    private final ContentType type;
    private final URI baseUri;

    public static Job job(ParseTreeNode rootNode, URI baseUri) {
        ContentType type;
        if (rootNode instanceof Statement || rootNode instanceof Expression || rootNode instanceof UncajoledModule || rootNode instanceof CajoledModule) {
            type = ContentType.JS;
        } else if (rootNode instanceof Dom) {
            type = ContentType.HTML;
            assert (baseUri != null);
        } else if (rootNode instanceof CssTree.StyleSheet) {
            type = ContentType.CSS;
            assert (baseUri != null);
        } else {
            throw new SomethingWidgyHappenedError("Unknown input type " + rootNode);
        }
        return new Job(rootNode, type, baseUri);
    }

    public static Job jsJob(Statement root, URI baseUri) {
        return new Job(root, ContentType.JS, baseUri);
    }

    public static Job exprJob(Expression root, URI baseUri) {
        return new Job(root, ContentType.JS, baseUri);
    }

    public static Job moduleJob(UncajoledModule root, URI baseUri) {
        return new Job(root, ContentType.JS, baseUri);
    }

    public static Job cajoledJob(CajoledModule root) {
        return new Job(root, ContentType.JS, null);
    }

    public static Job domJob(Dom root, URI baseUri) {
        assert (baseUri != null);
        return new Job(root, ContentType.HTML, baseUri);
    }

    public static Job cssJob(CssTree.StyleSheet root, URI baseUri) {
        assert (baseUri != null);
        return new Job(root, ContentType.CSS, baseUri);
    }

    Job(ParseTreeNode root, ContentType type, URI baseUri) {
        this.root = root;
        this.type = type;
        this.baseUri = baseUri;
    }

    public Job clone() {
        return new Job(this.root.clone(), this.type, this.baseUri);
    }

    public ParseTreeNode getRoot() {
        return this.root;
    }

    public ContentType getType() {
        return this.type;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String toString() {
        return "(Job " + this.getType().name() + " " + this.getRoot() + ")";
    }
}

