/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.precajole.PrecajoleMap;
import com.google.caja.precajole.StaticPrecajoleMap;
import javax.annotation.Nullable;

public final class PluginMeta {
    private int guidCounter;
    private final UriFetcher uriFetcher;
    @Nullable
    private final UriPolicy uriPolicy;
    @Nullable
    private String idClass;
    private PrecajoleMap precajoleMap = null;
    private boolean precajoleMinify = false;

    public PluginMeta() {
        this(UriFetcher.NULL_NETWORK, UriPolicy.DENY_ALL);
    }

    public PluginMeta(UriFetcher uriFetcher, @Nullable UriPolicy uriPolicy) {
        this(uriFetcher, uriPolicy, StaticPrecajoleMap.getInstance(), false);
    }

    public PluginMeta(UriFetcher uriFetcher, @Nullable UriPolicy uriPolicy, @Nullable PrecajoleMap precajoleMap, boolean precajoleMinify) {
        if (uriFetcher == null) {
            throw new NullPointerException();
        }
        this.uriFetcher = uriFetcher;
        this.uriPolicy = uriPolicy;
        this.precajoleMap = precajoleMap;
        this.precajoleMinify = precajoleMinify;
    }

    public String generateUniqueName(String prefix) {
        return prefix + "_" + ++this.guidCounter + "___";
    }

    public int generateGuid() {
        return ++this.guidCounter;
    }

    @Nullable
    public UriPolicy getUriPolicy() {
        return this.uriPolicy;
    }

    public UriFetcher getUriFetcher() {
        return this.uriFetcher;
    }

    @Nullable
    public String getIdClass() {
        return this.idClass;
    }

    public void setIdClass(@Nullable String idClass) {
        this.idClass = idClass;
    }

    public void setPrecajoleMap(PrecajoleMap map) {
        this.precajoleMap = map;
    }

    public PrecajoleMap getPrecajoleMap() {
        return this.precajoleMap;
    }

    public void setPrecajoleMinify(boolean value) {
        this.precajoleMinify = value;
    }

    public boolean getPrecajoleMinify() {
        return this.precajoleMinify;
    }
}

