/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.CajaException;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.plugin.DataUriFetcher;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import java.util.List;

public interface UriFetcher {
    public static final UriFetcher NULL_NETWORK = new DataUriFetcher();

    public FetchedData fetch(ExternalReference var1, String var2) throws UriFetchException;

    public static final class ChainingUriFetcher {
        public static UriFetcher make(final UriFetcher ... fetchers) {
            return new UriFetcher(){
                List<Throwable> causes = Lists.newArrayList();

                public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetchException {
                    for (UriFetcher fetcher : fetchers) {
                        try {
                            return fetcher.fetch(ref, mimeType);
                        }
                        catch (UriFetchException e) {
                            this.causes.add(e);
                        }
                    }
                    throw new UriFetchException(ref, mimeType, this.causes);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UriFetchException
    extends CajaException {
        private static final long serialVersionUID = -7915784512753732116L;
        public final ExternalReference ref;
        public final String expectedMimeType;

        public UriFetchException(ExternalReference ref, String mimeType, Throwable cause) {
            super(new Message((MessageTypeInt)PluginMessageType.FAILED_TO_LOAD_EXTERNAL_URL, ref.getReferencePosition(), MessagePart.Factory.valueOf(ref.getUri().toString())), cause);
            this.ref = ref;
            this.expectedMimeType = mimeType;
        }

        public UriFetchException(ExternalReference ref, String mimeType, List<Throwable> causes) {
            this(ref, mimeType, causes.isEmpty() ? null : causes.get(0));
        }

        public UriFetchException(ExternalReference ref, String mimeType) {
            this(ref, mimeType, (Throwable)null);
        }
    }
}

